package provide TclPLT 1.0

proc PLTnumbers3D {pN Plane Axis sAxis Level } {
   global PltInfo WinInfo GphInfo 

# GET the plot window number

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# SAVE some things which will be changed and need to be reset

   set OrigX1 $WinInfo($wN,p0) ; set OrigX2 $WinInfo($wN,p3)
   set OrigY1 $WinInfo($wN,p1) ; set OrigY2 $WinInfo($wN,p4)
   set OrigZ1 $WinInfo($wN,p2) ; set OrigZ2 $WinInfo($wN,p5)
   set OrigXs $WinInfo($wN,a0) ; set OrigYs $WinInfo($wN,a1)
   set OrigZs $WinInfo($wN,a2)

# SET up some information which is based on the base axis

   switch -exact -- $Axis {
      X {
         set Hi $WinInfo($wN,p3) ; set Low $WinInfo($wN,p0)
         if { $WinInfo($wN,a0) == 0 } { set SgN + } else { set SgN * }
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a1) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN.a0
      }
      Y {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set Hi $WinInfo($wN,p4) ; set Low $WinInfo($wN,p1)
         if { $WinInfo($wN,a1) == 0 } { set SgN + } else { set SgN * }
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN.a1
      }
      Z {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set Hi $WinInfo($wN,p5) ; set Low $WinInfo($wN,p2)
         if { $WinInfo($wN,a2) == 0 } { set SgN + } else { set SgN * }
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a1) 0
	 set Sca $wN.a2
      }
   }
   if { $Low > $Hi } { TUdataSwap Low Hi }


# RESCALE all the axes.  Only the base axes being ticked are left

   GPHwinScale $wN Xc Yc Zc 0

# BASIC text size used for offsets

   set nDef [llength $sAxis]
   for { set I 0 } { $I < $nDef } { incr I } {
      set tLoc [lindex $sAxis $I]
      if [string match MIN $tLoc] { set Ax ${Axis}b } else { set Ax ${Axis}t }

# Tick and number option lists

      set tI $PltInfo($wN,tI$Ax)
      set nI $PltInfo($wN,nI$Ax)

# GET the distance between the major and minor tick marks

      if [string match + $SgN] {
         set dMj [expr ($Hi - $Low)/ double([lindex $tI 4])]
      } else { set dMj 10.0 }

# SET up the number options

      TextProp [lindex $nI 3] Courier [lindex $nI 4]
      set Place [lindex $nI 0]
      set Color [lindex $nI 2]

# THE approximate character size in window coordinates

      set cS [GPHtextLen "5" XYZ]
      set cX [expr 0.65 * [lindex $cS 0]]
      set cY [expr 0.65 * [lindex $cS 1]]
      set cZ [expr 0.65 * [lindex $cS 2]]

      set fA ${Plane}$Ax
      set rV [PLTnumPos $pN $fA $Place]

      set Just [lindex $rV 0]
      set Vs [lindex $rV 1]
      set lSgN [lindex $rV 2]
      set sX [lindex $rV 3]
      set sY [lindex $rV 4]
      set sZ [lindex $rV 5]
      set sV [lindex $rV 6]
      set aL [list [lindex $rV 7] [lindex $rV 8] [lindex $rV 9]] 

# INITIALIZE the label out X, Y, and Z locations.  Some of these
#   are modified later

      set Va [expr $Vs $lSgN ($Level + 0.6) * $cX]
      set Vb [expr $Vs $lSgN ($Level + 0.6) * $cY]
      set Vc [expr $Vs $lSgN ($Level + 0.6) * $cZ]

# SET up the print commands

      switch -exact -- $Plane {
         XYB -
         XYT {
	    if [string match XYB $Plane] { set Vc 0.0 } else { set Vc 1.0 }
            if [string match X $Axis] {
	       set pCmd { TexT $wN $V $Vb $Vc $Just $Pr $Color $aL } 
	    } else {
	       set pCmd { TexT $wN $Va $V $Vc $Just $Pr $Color $aL } 
	    }
         }
         XZB -
         XZT {
	    if [string match XZB $Plane] { set Vb 0.0 } else { set Vb 1.0 }
            if [string match X $Axis] {
	       set pCmd { TexT $wN $V $Vb $Vc $Just $Pr $Color $aL } 
	    } else {
	       set pCmd { TexT $wN $Va $Vb $V $Just $Pr $Color $aL } 
	    }
         }
         YZB -
         YZT {
	    if [string match YZB $Plane] { set Va 0.0 } else { set Va 1.0 }
            if [string match Y $Axis] {
	       set pCmd { TexT $wN $Va $V $Vc $Just $Pr $Color $aL } 
	    } else {
	       set pCmd { TexT $wN $Va $Vb $V $Just $Pr $Color $aL } 
	    }
         }
      }

# PRINT

      set V $Low
      set Vx $Va ; set Vy $Vb ; set Vz $Vc

      if [string match X $Axis] { 
          set cV $cX
      } elseif [string match Y $Axis] { set cV $cY } else { set cV $cZ}

      set pFmt [lindex $nI 1] 
      set prInfo [PLTgetSkip $pN $Axis $Low $Hi $dMj $SgN $pFmt $Plane] 
      set Skip [lindex $prInfo 0]
      set MxT  [lindex $prInfo 1]
      set Ends [lindex $nI 5]

      set nPr 0
      set MaxLab -1
      while { $V <= $Hi } {
         set Pr [PLTnumFmt $V $pFmt]
	 set nC [string length $Pr]
	 if { $nC > $MaxLab } { set MaxLab $nC }

         set Vv $V
         set V [expr $V $sV * $cV]
         set Va [expr $Va $sX * $cX]
         set Vb [expr $Vb $sY * $cY]
         set Vc [expr $Vc $sZ * $cZ]

         if {[expr $nPr % $Skip] == 0 } {
	    switch -exact -- $Ends {
	       NONE {  set OK 1 }
	       MIN  {  if { $nPr == 0 } { set OK 0 } else { set OK 1 } }
	       MAX  {  if { $nPr == $MxT } { set OK 0 } else { set OK 1 } }
	       BOTH {  if {($nPr == $MxT) || ($nPr == 0) } {
                           set OK 0
			} else { set OK 1 }
	       }
	    }
         } else { set OK 0 }

         if $OK { eval $pCmd }

	 incr nPr

	 set V $Vv
         set V [expr $V $SgN $dMj]
         set Va $Vx ; set Vb $Vy ; set Vc $Vz
      }

# UPDATE the number limits 
  
      set lX [expr $MaxLab * $cX]
      set lY [expr $MaxLab * $cY]
      set lZ [expr $MaxLab * $cZ]

      switch -exact -- $Plane {
         XYB -
         XYT {
            if [string match X $Axis] {
               if [string match Xt $Ax] {
                  set lY [expr $Vb + $MaxLab * $cY]
               } else { set lY [expr $Vb - $MaxLab * $cY] }
   	    PLTaxisLims $pN $fA NUMBER $lY $lY
            } else {
               if [string match Yt $Ax] {
                  set lX [expr $Va + $cX]
               } else { set lX [expr $Va - $cX] }
	       PLTaxisLims $pN $fA NUMBER $lX $lX
	    }
         }
         XZB -
         XZT {
            if [string match Z $Axis] {
               if [string match Zt $Ax] {
                  set lX [expr $Va + $MaxLab * $cX]
               } else { set lX [expr $Va - $MaxLab * $cX] }
               PLTaxisLims $pN $fA NUMBER $lX $lX
            } else {
               if [string match Xt $Ax] {
                  set lZ [expr $Vc + $cZ]
               } else { set lZ [expr $Vc - $cZ] }
               PLTaxisLims $pN $fA NUMBER $lZ $lZ
            }
         }
         YZB -
         YZT {
            if [string match Z $Axis] {
               if [string match Zt $Ax] {
                  set lY [expr $Vb + $MaxLab * $cY]
               } else { set lY [expr $Vb - $MaxLab * $cY] }
   	    PLTaxisLims $pN $fA NUMBER $lY $lY
            } else {
               if [string match Yt $Ax] {
                  set lZ [expr $Vc + $cZ]
               } else { set lZ [expr $Vc - $cZ] }
	       PLTaxisLims $pN $fA NUMBER $lZ $lZ
	    }
         }
      }
   }

# RESTORE original settings

   set WinInfo($wN,p0) $OrigX1 ; set WinInfo($wN,p3) $OrigX2
   set WinInfo($wN,p1) $OrigY1 ; set WinInfo($wN,p4) $OrigY2
   set WinInfo($wN,p2) $OrigZ1 ; set WinInfo($wN,p5) $OrigZ2
   set WinInfo($wN,a0) $OrigXs ; set WinInfo($wN,a1) $OrigYs
   set WinInfo($wN,a2) $OrigZs

   GPHwinScale $wN Xc Yc Zc 0
}
