# THIS procedure returns the Offsets and justifications for either axis 
#  number or axis labels.  For 3D plots it also returns the text orientation
#
#  Item is either NUMBERS or Labels
#  Pos will be either INSIDE or OUTSIDE

package provide TclPLT 1.0

proc PLTlabelsPos { pN Axis Pos lJust } {
   global PltInfo WinInfo

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# 2 and 3D plots are handled differently

   if { $PltInfo($pN,Dimen) == 2 } {

# SET a pointer to the correct offset 

      switch -exact -- $Axis {
         Xb { if [string match $Pos INSIDE] { set P 5 } else { set P 1  } }
         Yb { if [string match $Pos INSIDE] { set P 6 } else { set P 2  } }
         Xt { if [string match $Pos INSIDE] { set P 7 } else { set P 3  } }
         Yt { if [string match $Pos INSIDE] { set P 8 } else { set P 4  } }
         Xc { if [string match $Pos INSIDE] { set P 9 } else { set P 10 } }
      }

# PICK apart the axis

      set Ax [string index $Axis 0]
      set Ap [string index $Axis 1]

# THIS is where to start the label. 

      set sP [lindex $PltInfo($pN,nO) $P ]
      set Jf $lJust

# DETERMINE the rotation

      if [string match Y $Ax] {
         if [string match INSIDE $Pos] { 
            if [string match t $Ap] { set RoT 270. } else { set RoT 90. }
         } else {
            if [string match t $Ap] { set RoT 90. } else { set RoT 270. }
         }
      } else { set RoT 0.0 }

# GET the sign to use when adding offsets to the base position

      set bL [expr ($P - 1) / 2]
      if { ($bL == 0) || ($bL == 3) || ($bL == 4) } { 
         set SgN - 
      } else { set SgN + }
     
      set rV [list $Jf $sP $SgN $RoT]

   } else {

# 3D annotation is always set to be level with axis plane being annotated.
#   Since each axis belongs to two places it can have two differet annotation
#   orientations.
#
#  The varaibles sX, sY, and sZ proscribe shifts in the starting position of
#     the text so that after rotations the text is in the correct location.

# SET a pointer to the correct offset 

      switch -exact -- $Axis {
         XYBXb { if [string match $Pos INSIDE] { set P 5  } else { set P 1  } }
         XYBYb { if [string match $Pos INSIDE] { set P 6  } else { set P 2  } }
         XYBXt { if [string match $Pos INSIDE] { set P 7  } else { set P 3  } }
         XYBYt { if [string match $Pos INSIDE] { set P 8  } else { set P 4  } }
         XYTXb { if [string match $Pos INSIDE] { set P 13 } else { set P 9  } }
         XYTYb { if [string match $Pos INSIDE] { set P 14 } else { set P 10 } }
         XYTXt { if [string match $Pos INSIDE] { set P 15 } else { set P 11 } }
         XYTYt { if [string match $Pos INSIDE] { set P 16 } else { set P 12 } }
         XZBXb { if [string match $Pos INSIDE] { set P 21 } else { set P 17 } }
         XZBZb { if [string match $Pos INSIDE] { set P 22 } else { set P 18 } }
         XZBXt { if [string match $Pos INSIDE] { set P 23 } else { set P 19 } }
         XZBZt { if [string match $Pos INSIDE] { set P 24 } else { set P 20 } }
         XZTXb { if [string match $Pos INSIDE] { set P 29 } else { set P 25 } }
         XZTZb { if [string match $Pos INSIDE] { set P 30 } else { set P 26 } }
         XZTXt { if [string match $Pos INSIDE] { set P 31 } else { set P 27 } }
         XZTZt { if [string match $Pos INSIDE] { set P 32 } else { set P 28 } }
         YZBYb { if [string match $Pos INSIDE] { set P 37 } else { set P 33 } }
         YZBZb { if [string match $Pos INSIDE] { set P 38 } else { set P 34 } }
         YZBYt { if [string match $Pos INSIDE] { set P 39 } else { set P 35 } }
         YZBZt { if [string match $Pos INSIDE] { set P 40 } else { set P 36 } }
         YZTYb { if [string match $Pos INSIDE] { set P 45 } else { set P 41 } }
         YZTZb { if [string match $Pos INSIDE] { set P 46 } else { set P 42 } }
         YZTYt { if [string match $Pos INSIDE] { set P 47 } else { set P 43 } }
         YZTZt { if [string match $Pos INSIDE] { set P 48 } else { set P 44 } }
      }

# PICK apart the axis

      set Plane [string range $Axis 0 2]
      set Ax [string index $Axis 3]
      set Ap [string index $Axis 4]

# THIS is where to start the label

      set sP [lindex $PltInfo($pN,nO) $P ]

# SET up some factors used to determine the direction to move the start 
#    position when adding levels

      set bL [expr ($P - 1) / 8]
      set tP [expr $P - 1 - $bL * 8]
      set sL [ expr $tP / 2 ]
      if { ($sL == 0) || ($sL == 3) } { set SgN - } else { set SgN + }

# DETERMINE the justification and rotaton for either TEXT labels or for the
#   numerical annocation.

      set sX "+ 0.0" ; set sY "+ 0.0" ; set sZ "+ 0.0" ; set sV "+ 0.0"
      set Rx 0.0 ; set Ry 0.0 ; set Rz 0.0
      switch -exact -- $Axis {
         XYTYb -
         XYTYt -
         XYBYb -
         XYBYt {
	    set Rx 270.0
	    set Jf $lJust
         }
         XYTXt -
         XYBXt {
	    set Ry 90.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sX { + 0.5 * $nC } 
               set sY { + 1.0 } 
            }
         }
         XYTXb -
         XYBXb {
	    set Ry 90.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sX { + 0.5 * $nC } 
               set sY { - 1.0 } 
            }
         }
         XZBXt -
         XZBXb {
            set Ry 270.0
	    set Jf right
            if [string match center $lJust] {
               set sX { - 0.5 * $nC } 
            }
         }
         XZBZb {
            set Rx 270.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
               set sX { - 1.0 } 
            }
         }
         XZBZt {
            set Rx 270.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
               set sX { + 1.0 } 
            }
         }
         XZTXb -
         XZTXt {
            set Ry 90.0
	    set Jf right
            if [string match center $lJust] {
               set sX { + 0.5 * $nC } 
            }
	 }
         XZTZb {
            set Rx 90.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
               set sX { - 1.0 } 
            }
	 }
         XZTZt {
            set Rx 90.0 ; set Rz 90.0
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
            }
	 }
         YZTYb -
         YZTYt -
         YZBYb -
         YZBYt {
	    set Rx 0.0
	    set Jf $lJust
         }
         YZTZt -
         YZBZt {
	    set Rz 90.0 
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
               set sY { + 1.0 } 
            }
         }
         YZTZb -
         YZBZb {
	    set Rz 90.0 
	    set Jf right
            if [string match center $lJust] {
               set sZ { - 0.5 * $nC } 
            }
         }
      } 

      set rV [list $Jf $sP $SgN $sX $sY $sZ $sV $Rx $Ry $Rz]

   }

   return $rV
}
