package provide TclPLT 1.0

#INPUTS
#
# pN       Plot Number
# Axis     Axis: ALL, Xb, Xt, Yb, Yt
# Parent   TICKS, NUMBERS, AXIS
# Item 
# New      New value


proc PLTinfoChg { pN Axis Parent Item  New } {
   global PltInfo 

# RESET Y axis designation if called with Yr of Yl 

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

   switch -exact -- $Parent {
      TICKS  {
         switch -exact -- $Axis {
            ALL {
               set Chg 4
               set aX(0) $pN,tIXb
               set aX(1) $pN,tIXt
               set aX(2) $pN,tIYb
               set aX(3) $pN,tIYt
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg 2
                  set aX(4) $pN,tIZb
                  set aX(5) $pN,tIZt
	       }
            }
            X  {
               set Chg 2
               set aX(0) $pN,tIXb
               set aX(1) $pN,tIXt
            }
            Y  {
               set Chg 2
               set aX(0) $pN,tIYb
               set aX(1) $pN,tIYt
            }
            Z  {
               set Chg 2
               set aX(0) $pN,tIZb
               set aX(1) $pN,tIZt
            }
            XYP  {
               set Chg 2
               set aX(0) $pN,tIXb
               set aX(1) $pN,tIYb
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg
                  set aX(2) $pN,tIZb
               }
            }
            XYS  {
               set Chg 2
               set aX(0) $pN,tIXt
               set aX(1) $pN,tIYt
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg
                  set aX(2) $pN,tIZt
               }
            }
            default {
               set Chg 1
               set aX(0) $pN,tI$Axis
            }
         }

         for { set I 0 } { $I < $Chg } { incr I } {
            set TesT PltInfo($aX($I))
            if ![info exists $TesT] {
                  set PltInfo($aX($I)) [list X X X X X X X X X X] 
            }
            switch $Item {
               MINPHI - 
               MJPOSITION { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 0 0 $New ]
               }
               MAXPHI - 
               MNPOSITION { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 1 1 $New ]
               }
               MINTHETA - 
               MJLENGTH { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 2 2 $New ]
               }
               MAXTHETA - 
               MNLENGTH { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 3 3 $New ]
               }
               NSTERM - 
               MJNUMBER { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 4 4 $New ]
               }
               MNNUMBER { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 5 5 $New ]
               }
               MJCOLOR { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 6 6 $New ]
               }
               MNCOLOR { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 7 7 $New ]
               }
               MJSTART { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 8 8 $New ]
               }
               MJSTEP { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 9 9 $New ]
               }
            }
         }
      } 
      
      NUMBERS {
         switch -exact -- $Axis {
            ALL {
               set Chg 4
               set aX(0) $pN,nIXb
               set aX(1) $pN,nIXt
               set aX(2) $pN,nIYb
               set aX(3) $pN,nIYt
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg 2
                  set aX(4) $pN,nIZb
                  set aX(5) $pN,nIZt
	       }
            }
            X  {
               set Chg 2
               set aX(0) $pN,nIXb
               set aX(1) $pN,nIXt
            }
            Y  {
               set Chg 2
               set aX(0) $pN,nIYb
               set aX(1) $pN,nIYt
            }
            Z  {
               set Chg 2
               set aX(0) $pN,nIZb
               set aX(1) $pN,nIZt
            }
            XYP  {
               set Chg 2
               set aX(0) $pN,nIXb
               set aX(1) $pN,nIYb
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg
                  set aX(2) $pN,nIZb
	       }
            }
            XYS  {
               set Chg 2
               set aX(0) $pN,nIXt
               set aX(1) $pN,nIYt
	       if { $PltInfo($pN,Dimen) == 3 } {
	          incr Chg
                  set aX(2) $pN,nIZt
               }
            }
            default {
               set Chg 1
               set aX(0) $pN,nI$Axis
            }
         }

         for { set I 0 } { $I < $Chg } { incr I } {
            set TesT PltInfo($aX($I))
            if ![info exists $TesT] {
                  set PltInfo($aX($I)) [list X X X X X X X X X X] 
            }
            switch $Item {
               NPOSITION  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 0 0 $New ]
               }
               NFORMAT  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 1 1 $New ]
               }
               NCOLOR  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 2 2 $New ]
               }
               NSIZE  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 3 3 $New ]
               }
               NBOLD  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 4 4 $New ]
               }
               NENDS  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 5 5 $New ]
               }
               TCOLOR  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 6 6 $New ]
               }
               TSIZE  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 7 7 $New ]
               }
               TBOLD { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 8 8 $New ]
               }
               TPOSITION  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 9 9 $New ]
               }
               TANGLE  { 
                  set PltInfo($aX($I)) [lreplace $PltInfo($aX($I)) 10 10 $New ]
	       }
            }
         }
      }
      AXIS {
         if ![info exists PltInfo($pN,aI)] { 
	     set PltInfo($pN,aI) [list X X X X X X] 
	 }
         switch $Item {
            FORMAT  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 0 0 $New ]
            }
            COLOR  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 1 1 $New ]
            }
            ORIGINX  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 2 2 $New ]
            }
            ORIGINY  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 3 3 $New ]
            }
            BASEX  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 4 4 $New ]
            }
            BASEY  { 
               set PltInfo($pN,aI) [lreplace $PltInfo($pN,aI) 5 5 $New ]
            }
         }
      }
   }
}
