package provide TclPLT 1.0

# INPUTS
#  
#  pN     -  Plot Number
#  Xs     -  Array of X values
#  Ys     -  Array of Y values
#  Zs     -  Array of Z values
#  Beg     -  Starting point in arrays
#  End     -  Ending point in arrays
#  Ops List
#    Index 0 : Plot Format  (2D, 3D) -> 3D not implemented
#    Index 1 : Line Color
#    Index 2 : Base Axis
#    Index 3 : Fill (OFF/ON)
#  ExC List
#    Index 0 : X Data Exclusion : NONE < > >= <= ==  
#    Index 1 : X Data Exclusoin Value
#    Index 2 : Y Data Exclusion : NONE < > >= <= ==  
#    Index 3 : Y Data Exclusoin Value
#    Index 4 : Z Data Exclusion : NONE < > >= <= ==  
#    Index 5 : Z Data Exclusoin Value

                
proc PLThistogramPlot { wN xA yA Xs Ys Zs Beg End Ops { ExC "" } } {
   global WinInfo PltInfo GphInfo 

# GET axis definitions to old style 

   if { [string match Yl $yA] } { set yA Yb }
   if { [string match Yr $yA] } { set yA Yt }

# Save values which might get changed and need to be reset

   set lC $GphInfo(lColor)
   set fC $GphInfo(fColor)
   set OldX $WinInfo($wN,X)
   set OldY $WinInfo($wN,Y)
   set OldClip $WinInfo($wN,Clip)

# GET the correct set of axis scaled

   if { [string match Xb $xA] } { set aX Xp } else { set aX Xs }
   if { [string match Yb $yA] } { set aY Yp } else { set aY Ys }
   GPHwinScale $wN $aX $aY Zc 0

# Set up the X and Y exclusion commands.

   set eL [llength $ExC]

   if { $eL > 0 } { set Cond [lindex $ExC 0] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdx { if { $X($J) == [lindex $ExC 1] } { set OKx 0 } } }
      >    { set Cmdx { if { $X($J) > [lindex $ExC 1] }  { set OKx 0 } } }
      <    { set Cmdx { if { $X($J) < [lindex $ExC 1] }  { set OKx 0 } } }
      >=   { set Cmdx { if { $X($J) >= [lindex $ExC 1] } { set OKx 0 } } }
      <=   { set Cmdx { if { $X($J) <= [lindex $ExC 1] } { set OKx 0 } } }
      default { set Cmdx {set OKx 1 } }
   }

   if { $eL > 2 } { set Cond [lindex $ExC 2] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdy { if { $Y($I) == [lindex $ExC 3] } { set OKy 0 } } }
      >    { set Cmdy { if { $Y($I) > [lindex $ExC 3] }  { set OKy 0 } } }
      <    { set Cmdy { if { $Y($I) < [lindex $ExC 3] }  { set OKy 0 } } }
      >=   { set Cmdy { if { $Y($I) >= [lindex $ExC 3] } { set OKy 0 } } }
      <=   { set Cmdy { if { $Y($I) <= [lindex $ExC 3] } { set OKy 0 } } }
      default { set Cmdy {set OKy 1 } }
   }

   if { $eL > 4 } { set Cond [lindex $ExC 4] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdz { if { $Z($I) == [lindex $ExC 5] } { set OKz 0 } } }
      >    { set Cmdz { if { $Z($I) > [lindex $ExC 5] }  { set OKz 0 } } }
      <    { set Cmdz { if { $Z($I) < [lindex $ExC 5] }  { set OKz 0 } } }
      >=   { set Cmdz { if { $Z($I) >= [lindex $ExC 5] } { set OKz 0 } } }
      <=   { set Cmdz { if { $Z($I) <= [lindex $ExC 5] } { set OKz 0 } } }
      default { set Cmdz {set OKz 1 } }
   }

# SET the plot histogram color and type

   set oL [llength $Ops]
   if { $oL > 1 } { set cC [lindex $Ops 1] } else { set cC 255 }
   if { $oL > 2 } { set bX [lindex $Ops 2] } else { set bX X }
   if { $oL > 3 } { set bF [lindex $Ops 3] } else { set bF ON }

   if [string match ON $bF] {
      PlotColor HOLD $cC $cC
   } else { PlotColor HOLD $cC OFF }

   set pType [lindex $Ops 0]$bX
   set ByeByeX 0

   set OKx 1 ; set OKy 1 ; set OKz 1 
   switch -exact -- $pType {
      2DX {

# BECAUSE it wasn't demanded in earlier versions its entirely possible that
#   there is no X array.  In this case we compute a set of X values which
#   are evenly spaced across the plot.

         upvar $Xs Xt
         upvar $Ys Y

         if { [info exists Xt] == 0 } {
            set ByeByeX 1
            set nP [expr $End - $Beg]
            set Xt(0) $WinInfo($wN,p0)
            if { $nP > 0 } {
               set IncX [expr ($WinInfo($wN,p3) - $Xt(0))/double($nP)]
            } else { set IncX 0 }
            for { set J 0; set I 1 } { $I <= $nP } { incr I ; incr J } {
               set Xt($I) [ expr $Xt($J) + $IncX ]
            }
         } 

         set WinInfo($wN,Clip) 2
         set Yb $WinInfo($wN,p1)
        
         set I $Beg
         if { $I == $End } { set J $I } else { set J [expr $I + 1] }

	 set dX [expr ($Xt($J) - $Xt($I)) / 2.0]
         set X(0) [expr $Xt($I) - $dX]
         for { } { $I < $End } { incr I ; incr J } {
	    set dX [expr ($Xt($J) - $Xt($I)) / 2.0]
            set X($J) [expr $Xt($I) + $dX]
         }
         set X($J) [expr $Xt($I) + $dX]

         set I $Beg
	 set J $Beg 
         eval $Cmdx
	 set PrevOK $OKx
	 
         if { $I == $End } { set J $I } else { set J [expr $I + 1] }

         for { } { $I <= $End } { incr I ; incr J } { 
            eval $Cmdx ; eval $Cmdy
	    if { $OKy } {
	       if { $PrevOK && $OKx } {
                  Box $wN $X($I) $Yb 0.0 $X($J) $Y($I) 0.0 
	       }
            } 
	    set PrevOK $OKx ; set OKx 1 ; set OKy 1 
         }
      }

      2DY {
         upvar $Xs X
         upvar $Ys Yt

         set WinInfo($wN,Clip) 2
         set Xb $WinInfo($wN,p0)
        
         set I $Beg
         if { $I == $End } { set J $I } else { set J [expr $I + 1] }

	 set dY [expr ($Yt($J) - $Yt($I)) / 2.0]
         set Y(0) [expr $Yt($I) - $dY]
         for { } { $I < $End } { incr I ; incr J } {
	    set dY [expr ($Yt($J) - $Yt($I)) / 2.0]
            set Y($J) [expr $Yt($I) + $dY]
         }
         set Y($J) [expr $Yt($I) + $YX]

         set I $Beg
	 set J $Beg 
         eval $Cmdy
	 set PrevOK $OKy
	 
         if { $I == $End } { set J $I } else { set J [expr $I + 1] }

         for { } { $I <= $End } { incr I ; incr J } { 
            eval $Cmdx ; eval $Cmdy
	    if { $OKx } {
	       if { $PrevOK && $OKy } {
                  Box $wN $Xb $Y($I) 0.0 $X($I) $Y($J) 0.0 
	       }
            } 
	    set PrevOK $OKy ; set OKx 1 ; set OKy 1 
         }
      }
   }

   PlotColor HOLD $lC $fC
   GPHwinScale $wN $OldX $OldY Zc 0
   set WinInfo($wN,Clip) $OldClip

   if $ByeByeX { unset Xt }
}
