package provide TclPLT 1.0

# INPUTS
#  
#  wN      -  Plot Window Number
#  Data1   -  Array of X values
#  Data2   -  Array of Y values
#  Data3   -  Array of Intensity values
#  Format  -  Plot format ; AUTO/MANUAL 
#             AUTO   - evenly spaced grids - Data1 and Data2 are ignored
#             MANUAL - Data1 and Data2 give data location in plot
#  Ops Array should be the grid information array and may include the
#     extra elements:
#
#    UF  : UPDATE FREQUENCY
                
proc PLTflatPlot { wN xA yA Data1 Data2 Data3 Format Ops cInfo } {
   global WinInfo PltInfo GphInfo uGrid ugI

#  GET the array to local values.  AUTO plots have only a Data3 array
#    associated with them

   upvar $cInfo cI
   upvar $Ops Opt
   upvar $Data3 V3
   if ![string match AUTO $Format] {
      upvar $Data1 V1
      upvar $Data2 V2
   }

   if { [string match Yl $yA] } { set yA Yb }
   if { [string match Yr $yA] } { set yA Yt }

# GET the pertinent options

   set RC $Opt(8)
   set tX $Opt(4)
   set tY $Opt(5)

   if [info exists Opt(UF)] { set uF $Opt(UF) } else { set uF 1000000 }

# TURN on clipping and save old state

   set OldClip $WinInfo($wN,Clip)
   set WinInfo($wN,Clip) 2

# GET the correct set of axis scaled

   if { [string match Xb $xA] } { set aX Xp } else { set aX Xs }
   if { [string match Yb $yA] } { set aY Yp } else { set aY Ys }
   GPHwinScale $wN $aX $aY Zc 0

# FOR an auto plot we take the grid and use the information used to from
#   the grid to create the X and Y arrays

   if [string match AUTO $Format] {
      set nX $Opt(4)
      set nY $Opt(5)
      for { set I 0 } { $I < $nX } { incr I } {
         for { set J 0 } { $J < $nY } { incr J } {
	    TUgridInfo 1 Opt rV $I $J 
	    TUgridInfo 22 Opt bC $rV(0)
	    set K $rV(0)
            if { $V3($K) > -9.0e30 } {
	       set C [PLTvalueColor $V3($K) cI]
               PlotColor HOLD $C $C
               Box $wN $bC(0) $bC(1) 0.0 $bC(2) $bC(3) 0.0
            }
         }
	 if { [expr $I % $uF] == 0 } { update }
      }
   } else {
      set K 0
      if [string match $RC COLUMN] {
         for { set Ia 0 ; set Ib 1 } { $Ia < $tX } { incr Ia ; incr Ib } {
            set Xp(0) $V1($Ia)
            set Xp(1) $V1($Ib)
            set Xp(2) $V1($Ib)
            set Xp(3) $V1($Ia)
            for { set Ja 0 ; set Jb 1 } { $Ja < $tY } { incr Ja ; incr Jb } {
               if { $V3($K) > -1.0e50 } {
                  set C [PLTvalueColor $V3($K) cI]
                  PlotColor HOLD $C $C
                  set Yp(0) $V2($Ja)
                  set Yp(1) $V2($Ja)
                  set Yp(2) $V2($Jb)
                  set Yp(3) $V2($Jb)
                  Poly $wN Xp Yp Xp 4
               }
               incr K
            }
	    if { [expr $Ia % $uF] == 0 } { update }
         }
      } else {
         for { set Ja 0 ; set Jb 1 } { $Ja < $tY } { incr Ja ; incr Jb } {
            for { set Ia 0 ; set Ib 1 } { $Ia < $tX } { incr Ia ; incr Ib } {
               if { $V3($K) > -9.0e30 } {
		  set C [PLTvalueColor $V3($K) cI]
                  PlotColor HOLD $C $C
                  set Xp(0) $V1($Ia) ; set Yp(0) $V2($Ja)
                  set Xp(1) $V1($Ib) ; set Yp(1) $V2($Ja)
                  set Xp(2) $V1($Ib) ; set Yp(2) $V2($Jb)
                  set Xp(3) $V1($Ia) ; set Yp(3) $V2($Jb)
                  Poly $wN Xp Yp Xp 4
               }
               incr K
            }
	    if { [expr $Ja % $uF] == 0 } { update }
         }
      }
   } 

   set WinInfo($wN,Clip) $OldClip
   PlotColor HOLD HOLD OFF
}
