# THIS procedure produces the contour for the value cLevel within the data
#    grid Grid.

package provide TclPLT 1.0

proc PLTcontourLevel { wN Grid xC yC gInfo Status cLevel dType MisC } {
   upvar $Grid G
   upvar $xC cX
   upvar $yC cY
   upvar $Status S
   upvar $gInfo gI
   upvar $MisC mS

# THE number of points in the data grid 

   set nG [expr $gI(4) * $gI(5)]

# THE length of a grid in X (column) and Y (row)

   set InFo(0) [expr ($gI(1) - $gI(0)) / double($gI(4))]
   set InFo(1) [expr ($gI(3) - $gI(2)) / double($gI(5))]
   set InFo(2) $mS(0)

# LOOP over the grid data as RoW and CoL.
 
   for { set R 0 ; set kR 0 } { $R < $mS(4) } { incr R ; incr kR $mS(2) } {
      for { set C 0 ; set kC 0 } { $C < $mS(3) } { incr C ; incr kC $mS(1) } {
          set gN(0) [expr $kR + $kC]

# IF all values defining this cell are known to be below the current contour
#   level then don't even look at it.

          if { $S($gN(0)) == 1 } { continue }
  
# CONTOUR cell corners derived from the data grid 

          set CoL [expr ($C + 1 + $gI(4)) % $gI(4)]
          if {$C > $CoL } { incr CoL }
          set RoW [expr ($R + 1 + $gI(5)) % $gI(5)]
          if {$R > $RoW } { incr RoW }

          set gN(1) [expr $C * $mS(1) + $RoW * $mS(2)]
          set gN(2) [expr $CoL * $mS(1) + $RoW * $mS(2)]
          set gN(3) [expr $CoL * $mS(1) + $R * $mS(2)]

# RETRIEVE information on the cell 

          if { [PLTcontourCell gN cX cY InFo G X Y V pF ] < 0} { 
             continue 
          } 

# IF no points in the contour cell are within the contour being drawn then no 
#   need to check on what lines need to be drawn

          if { ($cLevel >= $InFo(3)) && ($cLevel <= $InFo(4)) } {

# SET the number of valid crossings into (out out of) each of the 4 triangular
#   sections into which the contour cell is broken.

             for { set I 0 } { $I < 4 } { incr I } { set SeGs($I) 0 }

# DIFFERENT logic must be used depending on whether the center of the contour
#    grid equals the contour level or not.
             
             if { $V(4) == $cLevel } {
                for { set J 0 ; set M 4 } { $J < 4 } { incr J ; incr M } {
                   set lFlag($M) 0 
                   set lFlag($J) 1  
                   set xt($J) $X(4)
                   set yt($J) $Y(4)
                   if { $pF($J) == 0 } { continue }

                   set L [expr ($J + 1) % 4]
                   if { $V($J) > $V($L) } {
                      set MiN $V($L)
                      set MaX $V($J)
                   } else { set MiN $V($J) ; set MaX $V($L) }
                   if { ($cLevel >= $MiN) && ($cLevel <= $MaX) } { 
                      set SeP [expr $V($J) - $V($L)]
                      if { $SeP != 0.0 } {
                         set rF [expr ($cLevel - $V($L)) / $SeP]
                         set xt($M) [expr $X($L) + ($X($J) - $X($L)) * $rF]
                         set yt($M) [expr $Y($L) + ($Y($J) - $Y($L)) * $sF]
                         set lFlag($M) 1
                         set SeGs($J) 2
                      }
                   }
                }
             } else {

# CHECK each of the 4 radii from the cell center to the corners to see if the
#    contour line passes through any of them.  If so determine the location. 
#    At the same time check the sides of the cell to see if the contour line
#    passes through any of these.

                for { set J 0 ; set M 4 } { $J < 4 } { incr J ; incr M } {
                   set lFlag($J) 0  
                   set lFlag($M) 0 
                   if { $pF($J) == 0 } { continue }

                   set K [expr ($J + 3) % 4]
                   set L 4

                   if { $V($J) > $V($L) } {
                      set MiN $V($L)
                      set MaX $V($J)
                   } else { set MiN $V($J) ; set MaX $V($L) }
                   if { ($cLevel >= $MiN) && ($cLevel <= $MaX) } { 
                      set fR [expr ($cLevel - $V($L)) / ($V($J) - $V($L))]
                      set xt($J) [expr $X($L) + ($X($J) - $X($L)) * $fR]
                      set yt($J) [expr $Y($L) + ($Y($J) - $Y($L)) * $fR]
                      set lFlag($J) 1
                      incr SeGs($J)
                      incr SeGs($K)
                   }

                   set L [expr ($J + 1) % 4]
                   if { $V($J) > $V($L) } {
                      set MiN $V($L)
                      set MaX $V($J)
                   } else { set MiN $V($J) ; set MaX $V($L) }
                   if { ($cLevel >= $MiN) && ($cLevel <= $MaX) } { 
                      set SeP [expr $V($J) - $V($L)]
                      if { $SeP != 0.0 } {
                         set fR [expr ($cLevel - $V($L)) / $SeP]
                         set xt($M) [expr $X($L) + ($X($J) - $X($L)) * $fR]
                         set yt($M) [expr $Y($L) + ($Y($J) - $Y($L)) * $fR]
                         set lFlag($M) 1
                         incr SeGs($J)
                      }
                   }
                }
            }

# IF there is a line then output it.  If dType is 1 then we are dealing with
#   polar coordinates which need to be changed to rectangular before use.


            for { set J 0 ; set L 4 } { $J < 4 } { incr J ; incr L } {
               if { $SeGs($J) != 2 } { continue }
               set K [expr ($J + 1) % 4]
               set M 0
               if { $lFlag($J) == 1 } { set A($M) $J ; incr M }
               if { $lFlag($K) == 1 } { set A($M) $K ; incr M }
               if { $lFlag($L) == 1 } { set A($M) $L }
               if { $dType == 1 } {
                  set x(0) [expr $yt($A(0)) * cos($xt($A(0)))]
                  set y(0) [expr $yt($A(0)) * sin($xt($A(0)))]
                  set x(1) [expr $yt($A(1)) * cos($xt($A(1)))]
                  set y(1) [expr $yt($A(1)) * sin($xt($A(1)))]
                  Line $wN $x(0) $y(0) 0.0 $x(1) $y(1) 0.0
               } else { 
                  Line $wN $xt($A(0)) $yt($A(0)) 0.0 $xt($A(1)) $yt($A(1)) 0.0 
               }
            }
         } else { if { $InFo(4) < $cLevel } { set S(gN(0)) 1 } }
      }
   }
}
