# SYNOPSIS : For axis in MAP plots
#            Depending on the set actions, this routine will produce
#            one or more labeled or unlabled tick marks against Axis
#            or will produce axis text labels.
#
# INPUTS
#  Axis    :  Xb, Xt, Yb, or Yt
#  TicA    :  ALLMAJOR, ALLMINOR, ONEMAJOR, ONEMINOR, BOTH, NONE
#  LabA    :  MANUAL, AUTO, AXIS, NONE
#  Level   :  Level of annotation
#  Pos     :  Location to place LABEL or single tick mark
#  TJust   :  Text justification when LabA is AXIS
#  Label   :  Label when LabA is AXIS
#  aPos    :  Can be used in conjunction with Pos on AXIS and MANUAL lablels 
#             derive the label position along an axis.  If Pos is latitude
#             aPos would be a longitude.  The pair is sometime useful when
#             trying to get a relative position in a non rectangular coordinate
#             coordinate system.
#             

package provide TclPLT 1.0

proc PLTaxisMap { pN Axis TicA LabA Level \
                  { Pos 0.0 } { TJust center} { Label "" } { aPos OFF } } {

   global PltInfo WinInfo GphInfo RtoD

# THE do nothing (or idiot's) check

   if { [string match NONE $LabA] && [string match NONE $TicA] } { return }

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# SAVE the label length

  set lLen [string length $Label]

# OFFSET the level by a little more than half a character so that the top
#   of the text is at the output location.

   if { $Level < 0.0 } { set LSgN - } else { set LSgN + } 
#  set Level [expr $Level $LSgN 0.6]

# SET up the screen designation
 
   set sC Scr$GphInfo(CurScr)

#  GET the curent window number and the current Axis labeling and tick mark
#     information.  Also get the type of mapping being used

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN
   PLTinfoCur $pN $Axis nI tI
   set iD $GphInfo(CoSyS)

# INITIALIZE the plot boundaries

   PLTaxisLims $pN $Axis INITIALIZE

#  SAVE the current color and text settings so they can be put back later
#    also save the current window clipping setting
  
   set OldlC $GphInfo(lColor)
   set OldtC $GphInfo(tColor)
   set OldtS $GphInfo(tSize)
   set OldtB $GphInfo(tBold)
   set OldCS $GphInfo(CoSyS)
   set OldCI $GphInfo(CsOps)
   set SaveClip $WinInfo($wN,Clip)

# Drawing the latitude and longitude lines use some of the same information.
#    set that up now if either action is to be taken

   if { ![string match NONE $TicA] || [string match AUTO $LabA] } { 

#  SET the stepping length for the ticks

      set dV   [lindex $tI 9]

# SET up the maximum extent of the tick lines. For latitude lines these can be
#   different than the total latitudinal extent.

      set MinX [lindex $tI 0]
      set MaxX [lindex $tI 1]
      if [string match X* $Axis] { 
         set NSTerm [lindex $tI 4]
         set MaxY [expr abs($NSTerm)]
         set MinY [expr -$MaxY]
         if { $MaxY > [lindex $tI 3] } { set MaxY [lindex $tI 3] }
         if { $MinY < [lindex $tI 2] } { set MinY [lindex $tI 2] }
      } else { 
         set MinY [lindex $tI 2]
         set MaxY [lindex $tI 3]
      }
   }

# CHECK to make sure that we are not going to cause an overflow with any
#  of the max's or mins

   switch -exact -- $GphInfo(CoSyS) {
      MERCATOR {
         if [info exists MinY] {
            if { $MinY <= -90.0 } { set MinY -89.0 }
            if { $MaxY >= 90.0 }  { set MaxY 89.0  }
         }
      }
   }

# DO the tick marks if any are being output, up top.  There are no minor
#   tick marks and the major tick marks are really lines of constant latitude
#   and longitude.

   if ![string match NONE $TicA] { 

#  SET the color 

      PlotColor HOLD [lindex $tI 6] OFF

#  TURN on clipping for the tick marks
   
      set WinInfo($wN,Clip) 1

# SET up drawing commands

      if [string match X* $Axis] { 
	 set tCmd { MapLine $wN $V $MinY $V $MaxY 90 }
	 set MinL $MinX
	 set MaxL $MaxX
      } else { 
         set tCmd { MapLine $wN $MinX $V $MaxX $V 180 } 
	 set MinL $MinY
	 set MaxL $MaxY
      }

      if [string match ALLMAJOR $TicA] { 
         set V 0.0

	 eval $tCmd
         set OK 1
         while { $OK } {
            set V [expr $V + $dV]
            if { $V <= $MaxL } { eval $tCmd } else { set OK 0 }
         }
         set V 0.0
         set OK 1
         while { $OK } {
            set V [expr $V - $dV]
            if { $V >= $MinL } { eval $tCmd } else { set OK 0 }
         }
      } elseif [string match ONEMAJOR $TicA] { eval $tCmd }
   }

# IF there are no labels to add then we are done.  Reset anything we might
#   have changed and then leave

   if [string match NONE* $LabA] { 
      TextProp $OldtS HOLD $OldtB
      set GphInfo(lColor) $OldlC
      set GphInfo(tColor) $OldtC
      SetCorSys $OldCS $OldCI
      return
   }

# LABELS and axis Numeration are output in a CARTESIAN representation of the
#   plot box.  NUMERATION however must have its X or Y data given in the
#   projection coordinates.

   SetCorSys CARTESIAN [list 0.0 0.0 0.0]

# NOW establish where the labels are to be put, their color, justification,
#   etc. There are different values for number and axis text.

   if [string match AXIS $LabA] {
      TextProp [lindex $nI 7] HOLD [lindex $nI 8]
      set Place [lindex $nI 9]
      set Color [lindex $nI 6]
      set Just $TJust
      set aBase nO
   } else { 
      TextProp [lindex $nI 3] HOLD [lindex $nI 4]
      set Place [lindex $nI 0]
      set Color [lindex $nI 2]
      switch -exact -- $Axis {
         Xt -
	 Xb { set Just center }
	 Yt { 
            if [string match INSIDE $Place] { 
               set Just left 
            } else { set Just right }
	 }
	 Yb { 
            if [string match INSIDE $Place] { 
               set Just right 
            } else { set Just left }
	 }
      }

      set aBase tO
   }

# DETERMINE the offset into the current axis offset

   if [string match Xb $Axis ] { 
      set aO 1  
   } elseif [string match Xt $Axis ] { 
      set aO 3 
   } elseif [string match Yb $Axis ] { 
      set aO 2  
   } else { set aO 4 } 

#  SET up label INSIDE/OUTSIDE information.  This sets the sign used when 
#    shifting the label off the axis and identifies the axis as a primary 
#    or secondary window axis 

   if [ string match INSIDE $Place ] {
      if [string match *t $Axis] { set LSgn - } else { set LSgn + } 
      incr aO 4
   } else { 
      if [string match *t $Axis] { set LSgn + } else { set LSgn - } 
   }

#  NOW rescale the axis perpendicular to the axis being labeled.  The axis
#    is rescaled to be LINEAR from 0 to 1.

   if [ string match X* $Axis ] {
      set bAxis X
      set Dir 1
      set WinInfo($wN,a1) 0
      set WinInfo($wN,p1) 0.0
      set WinInfo($wN,p4) 1.0
      if [ string match Xb $Axis ] { set aX Xp } else { set aX Xs } 
      set aY Yc
   } else {
      set bAxis Y
      set Dir 0
      set WinInfo($wN,a0) 0
      set WinInfo($wN,p0) 0.0
      set WinInfo($wN,p3) 1.0
      if [ string match Yb $Axis ] { set aY Yp } else { set aY Ys } 
      set aX Xc
   }
   GPHwinScale $wN $aX $aY Zc 0

# GET the character size and the offset for labeling.

   set tS [GPHtextLen "5" XY]
   set Off [expr ($Level $LSgN 0.5 * $Dir) * [lindex $tS $Dir]]

# TURN off clipping since labels can be outside the plot box

      WinClip $pN 0

# OKAY, all set up. Now if auto-labeling an axis do that now

   if [string match AUTO $LabA] { 
      set Stat(0) 0
      if [string match X* $Axis] { 
	 set tCmd { GPHmapXY $OldCS 1 VaR FiX v f Stat 0 $OldCI }
         set pCmd { PLTdoLab $pN $V $Y $Just $Lab $Color $lInFo $I }
	 set MinL $MinX
	 set MaxL $MaxX
	 set FiX(0) $MinY
         set Y [expr [lindex $PltInfo($wN,tO) $aO ] $LSgn $Off]
      } else {
	 set tCmd { GPHmapXY $OldCS 1 FiX VaR f v Stat 0 $OldCI }
         set pCmd { PLTdoLab $pN $X $V $Just $Lab $Color $lInFo $I }
	 set MinL $MinY
	 set MaxL $MaxY
	 set FiX(0) $MinX
         set X [expr [lindex $PltInfo($wN,tO) $aO ] $LSgn $Off]
      }

      set LaBs ""
      set VaR(0) 0.0 
      eval $tCmd
      lappend LaBs [list $v(0) $VaR(0)]
	 
      set OK 1
      while { $OK } {
        set VaR(0) [expr $VaR(0) + $dV]
         if { $VaR(0) <= $MaxL } { 
	    eval $tCmd
            lappend LaBs [list $v(0) $VaR(0)]
         } else { set OK 0 }
      }
      set VaR(0) 0.0
      set OK 1
      while { $OK } {
         set VaR(0) [expr $VaR(0) - $dV]
         if { $VaR(0) >= $MinL } { 
	    eval $tCmd
            lappend LaBs [list $v(0) $VaR(0)]
         } else { set OK 0 }
      }
      set LaBs [lsort -real -increasing -index 0 $LaBs]
      set SkiP [PLTgetSkipMap $pN $bAxis $LaBs [lindex $nI 1]]
      set nL [llength $LaBs]
      set lInFo [list $SkiP $nL NONE] 
      set MaxLab ""
      set MaxLabSz 0
      for { set I 0 } { $I < $nL } { incr I } {
         set V [lindex [lindex $LaBs $I] 0]
         set Lab [PLTnumFmt [lindex [lindex $LaBs $I] 1] [lindex $nI 1]]
	 set lSz [string length $Lab]
	 if { $lSz > $MaxLabSz } { set MaxLabSz $lSz ; set MaxLab $Lab }
         eval $pCmd
      }

      if { $bAxis == "Y" } {
        set X [expr $X $LSgn [GPHtextLen $MaxLab X]]
        PLTaxisLims $pN $Axis NUMBER $X $X
      } else {
         set Y [expr $Y $LSgn [GPHtextLen "5" Y]]
         PLTaxisLims $pN $Axis NUMBER $Y $Y
      }
   }

# NOWS the time to set aPos to something if its not set

   if [string match OFF $aPos] {
      if {$bAxis == "X" } { 
         set aPos [lindex $tI 2]
      } else { set aPos [lindex $tI 0] }
   }

# MANUAL numerical label

   if [string match MANUAL $LabA] {
      if { $lLen == 0 } { set Label $Pos }
      if {$bAxis == "X" } {
         set Y [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
         set VaR(0) $Pos ; set FiX(0) $aPos ; set Stat(0) 0
	 set GPHmapXY $OldCS 1 VaR FiX v f Stat 0 $OldCI
	 set X $v(0)
         set Yo [expr $Y $LSgn 0.5 * [GPHtextLen "5" Y]]
         PLTaxisLims $pN $Axis NUMBER $Yo $Yo
      } else {
         set X [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
         set VaR(0) $aPos ; set FiX(0) $Pos ; set Stat(0) 0
	 set GPHmapXY $OldCS 1 VaR FiX v f Stat 0 $OldCI
	 set Y $f(0)
         set Xo [expr $X $LSgn [GPHtextLen $S X]]
         PLTaxisLims $pN $Axis NUMBER $Xo $Xo 
      }
      TexT $wN $X $Y 0.0 $Just $S $Color
   }

# AXIS label and idiot check that we're not outputting an empty label

   if { [string match AXIS $LabA] && ( $lLen > 0) } {
      set S $Label
      set Pos [PLTlabPos $pN $Axis $Pos $OldCS $OldCI $aPos]
      if {$bAxis == "X" } {
         set Y [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
         set X $Pos
      } else {
         set X [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
         set Y $Pos
         set S ""
         set sLen [expr [string length $Label] - 1]
         for {set I 0 } { $I <= $sLen } { incr I } {
	    if { $I != $sLen } {
                append S [string index $Label $I]\n
            } else { append S [string index $Label $I] }
         }
      }
      TexT $wN $X $Y 0.0 $Just $S $Color
   } 

   TextProp $OldtS HOLD $OldtB
   set GphInfo(lColor) $OldlC
   set GphInfo(tColor) $OldtC
   GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) $WinInfo($wN,Z) 0                            
   SetCorSys $OldCS $OldCI
}
