# THIS procedure keeps track of the farthest exent of the tick marks and
#    numerical labels from a given axis.
#
# THE order of the list is as follows
#
# 2D plots
#
#  Index 0 : 0 if nothing has be put into list, 1 otherwise
#  Index 1 : Xb axis maximum outside position
#  Index 2 : Yl axis maximum outside position
#  Index 3 : Xt axis maximum outside position
#  Index 4 : Yr axis maximum outside position
#  Index 5 : Xb axis maximum inside position
#  Index 6 : Yl axis maximum inside position
#  Index 7 : Xt axis maximum inside position
#  Index 8 : Yr axis maximum inside position
#  Index 9 : Xc maximum inside position (outer circle on POLAR PLOTS)
#  Index 10 :Yc maximum outside position (outer circle on POLAR PLOTS)

# 3D plots

#  Index 0  : 0 if nothing has be put into list, 1 otherwise
#  Index 1  : XYBxb axis maximum outside position 
#  Index 2  : XYByb axis maximum outside position
#  Index 3  : XYBxt axis maximum outside position 
#  Index 4  : XYByt axis maximum outside position
#  Index 5  : XYBxb axis maximum inside position 
#  Index 6  : XYByb axis maximum inside position
#  Index 7  : XYBxt axis maximum inside position 
#  Index 8  : XYByt axis maximum inside position
#  Index 9  : XYTxb axis maximum outside position 
#  Index 10 : XYTyb axis maximum outside position
#  Index 11 : XYTxt axis maximum outside position 
#  Index 12 : XYTyt axis maximum outside position
#  Index 13 : XYTxb axis maximum inside position 
#  Index 14 : XYTyb axis maximum inside position
#  Index 15 : XYTxt axis maximum inside position 
#  Index 16 : XYTyt axis maximum inside position
#  Index 17 : XZBxb axis maximum outside position 
#  Index 18 : XZBzb axis maximum outside position
#  Index 19 : XZBxt axis maximum outside position 
#  Index 20 : XZBzt axis maximum outside position
#  Index 21 : XZBxb axis maximum inside position 
#  Index 22 : XZBzb axis maximum inside position
#  Index 23 : XZBxt axis maximum inside position 
#  Index 24 : XZBzt axis maximum inside position 
#  Index 25 : XZTxb axis maximum outside position 
#  Index 26 : XZTzb axis maximum outside position
#  Index 27 : XZTxt axis maximum outside position 
#  Index 28 : XZTzt axis maximum outside position
#  Index 29 : XZTxb axis maximum inside position 
#  Index 30 : XZTzb axis maximum inside position
#  Index 31 : XZTxt axis maximum inside position 
#  Index 32 : XZTzt axis maximum inside position 
#  Index 33 : YZByb axis maximum outside position 
#  Index 34 : YZBzb axis maximum outside position
#  Index 35 : YZByt axis maximum outside position 
#  Index 36 : YZBzt axis maximum outside position
#  Index 37 : YZByb axis maximum inside position 
#  Index 38 : YZBzb axis maximum inside position
#  Index 39 : YZByt axis maximum inside position 
#  Index 40 : YZBzb axis maximum inside position 
#  Index 41 : YZTyb axis maximum outside position 
#  Index 42 : YZTzb axis maximum outside position
#  Index 43 : YZTyt axis maximum outside position 
#  Index 44 : YZTzt axis maximum outside position
#  Index 45 : YZTyb axis maximum inside position 
#  Index 46 : YZTzb axis maximum inside position
#  Index 47 : YZTyt axis maximum inside position 
#  Index 48 : YZTzb axis maximum inside position 

package provide TclPLT 1.0

proc PLTaxisLims { pN Axis Item { V1 0 } { V2 0 } } {
   global PltInfo WinInfo

# IF we are initializing just set all the eXents to the plot window size.

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

   set N $pN,nO
   set T $pN,tO

  set wN $PltInfo($pN,wN)

   if [string match INITIALIZE $Item] { 
      set x $WinInfo($wN,p0)
      set y $WinInfo($wN,p1)
      set X $WinInfo($wN,p3)
      set Y $WinInfo($wN,p4)

      set nS [lindex $PltInfo($N) 0]
      set tS [lindex $PltInfo($T) 0]
      switch -exact -- [lindex $PltInfo($pN,aI) 0] {
         MAP -
         BOX {
            if !$nS { set PltInfo($T) [list 1 $x $y $X $Y $x $y $X $Y] }
            if !$tS { set PltInfo($N) [list 1 $x $y $X $Y $x $y $X $Y] }
         }
         CROSSHAIR {
            set x [lindex $PltInfo($pN,aI) 2]
            set y [lindex $PltInfo($pN,aI) 3]
            if !$nS { set PltInfo($T) [list 1 $x $y 0. 0. $x $y 0. 0.] }
            if !$tS { set PltInfo($N) [list 1 $x $y 0. 0. $x $y 0. 0.] }
         }
         POLAR {
            if !$nS { set PltInfo($T) [list 1 $x $y $X $Y $x $y $X $Y 0. 0.] }
            if !$tS { set PltInfo($N) [list 1 $x $y $X $Y $x $y $X $Y 0. 0.] }
         }
         BOX3D {
            set z $WinInfo($wN,p2)
            set Z $WinInfo($wN,p5)
            if !$nS { 
               set PltInfo($T) [list 1 $x $y $X $Y $x $y $X $Y \
                                       $x $y $X $Y $x $y $X $Y
	       set PltInfo($T) [list 1 $x $y $z $X $Y $Z $x $y $Z $X $Y $Z \
	                               $x $y $z $X $Y $Z $x $y $Z $X $Y $Z ]
	       set PltInfo($N) [list 1 $x $y $z $X $Y $Z $x $y $Z $X $Y $Z \
	                               $x $y $z $X $Y $Z $x $y $Z $X $Y $Z ]
            }
         }
      }
   } else {

# SET the element which we are working with

      if [string match TICK $Item] { set pT $pN,tO } else { set pT $pN,nO }

# THIS is where the elements we will be checking can be found.

      switch -exact -- $Axis {
         Xb     { set mnO 1  ; set mxO 5  }
         Yb     { set mnO 2  ; set mxO 6  }
         Xt     { set mnO 7  ; set mxO 3  }
         Yt     { set mnO 8  ; set mxO 4  }
         Xc     { set mnO 9  ; set mxO 10 }
         XYBXb  { set mnO 1  ; set mxO 5  }
         XYBYb  { set mnO 2  ; set mxO 6  }
         XYBXt  { set mnO 7  ; set mxO 3  }
         XYBYt  { set mnO 8  ; set mxO 4  }
         XYTXb  { set mnO 9  ; set mxO 13 }
         XYTYb  { set mnO 10 ; set mxO 14 }
         XYTXt  { set mnO 15 ; set mxO 11 }
         XYTYt  { set mnO 16 ; set mxO 12 }
         XZBXb  { set mnO 17 ; set mxO 21 }
         XZBZb  { set mnO 18 ; set mxO 22 }
         XZBXt  { set mnO 23 ; set mxO 19 }
         XZBZt  { set mnO 24 ; set mxO 20 }
         XZTXb  { set mnO 25 ; set mxO 29 }
         XZTZb  { set mnO 26 ; set mxO 30 }
         XZTXt  { set mnO 31 ; set mxO 27 }
         XZTZt  { set mnO 32 ; set mxO 28 }
         YZBYb  { set mnO 33 ; set mxO 37 }
         YZBZb  { set mnO 34 ; set mxO 38 }
         YZBYt  { set mnO 39 ; set mxO 35 }
         YZBZt  { set mnO 40 ; set mxO 36 }
         YZTYb  { set mnO 41 ; set mxO 45 }
         YZTZb  { set mnO 42 ; set mxO 46 }
         YZTYt  { set mnO 47 ; set mxO 43 }
         YZTZt  { set mnO 48 ; set mxO 44 }
      }

      set MiN [lindex $PltInfo($pT) $mnO ]
      set MaX [lindex $PltInfo($pT) $mxO ]
      if { $V1 < $MiN } { set MiN $V1 }
      if { $V1 > $MaX } { set MaX $V1 }
      if { $V2 < $MiN } { set MiN $V2 }
      if { $V2 > $MaX } { set MaX $V2 }

      set PltInfo($pT) [lreplace $PltInfo($pT) $mnO $mnO $MiN] 
      set PltInfo($pT) [lreplace $PltInfo($pT) $mxO $mxO $MaX] 
      set PltInfo($pT) [lreplace $PltInfo($pT) 0 0 1] 
   }
}
