package provide TclPLT 1.0

proc PLTaxis3D { pN Planes } {
   global PltInfo WinInfo GphInfo

   set wN $PltInfo($pN,wN)
   set Oldc $GphInfo(lColor)
   set Oldf $GphInfo(fColor)

   set Type [lindex $PltInfo($pN,aI) 0]
   PlotColor HOLD [lindex $PltInfo($pN,aI) 1] OFF

   set X1 $WinInfo($wN,p0)
   set X2 $WinInfo($wN,p3)
   set Y1 $WinInfo($wN,p1)
   set Y2 $WinInfo($wN,p4)
   set Z1 $WinInfo($wN,p2)
   set Z2 $WinInfo($wN,p5)

   set nP [llength $Planes]
   switch -exact -- $Type {
      BOX3D {
         for { set I 0 } { $I < $nP } { incr I } {
            switch -exact -- [lindex $Planes $I] {
               XYB { Box $wN $X1 $Y1 $Z1 $X2 $Y2 $Z1 }
               XYT { Box $wN $X1 $Y1 $Z2 $X2 $Y2 $Z2 }
               XZB { Box $wN $X1 $Y1 $Z1 $X2 $Y1 $Z2 }
               XZT { Box $wN $X1 $Y2 $Z1 $X2 $Y2 $Z2 }
               YZB { Box $wN $X1 $Y1 $Z1 $X1 $Y2 $Z2 }
               YZT { Box $wN $X2 $Y1 $Z1 $X2 $Y2 $Z2 }
	    }
         }
      }
      CROSSHAIR3D {
      }
   }
   PlotColor HOLD $Oldc Oldf
}
