package provide TclPLT 1.0

#INPUTS  
#   
#  pP       The data array
#  nP       The number of point in the data array
#  Sca      The scaling to be used for the data
#  MjT      The number of major tick marks along axis
#  BotV     Ignore any data below this value when autoscaling
#  TopV     Ignore any data above this value when autoscaling
#  dV       User supplied base interval

proc PLTautoScale {Min Max Sca MjT { dV -1.0 }} {
   global PltInfo WinInfo

   if [string match LOG $Sca] { set Sca 1 }
   if [string match LINEAR $Sca] { set Sca 0 }

   set MjT [expr double($MjT)]
   set Min [expr double($Min)]
   set Max [expr double($Max)]

   set Edge(0)   1.2
   set Edge(1)   1.5
   set Edge(2)   2.0
   set Edge(3)   2.5
   set Edge(4)   3.0
   set Edge(5)   4.0
   set Edge(6)   5.0
   set Edge(7)   6.0
   set Edge(8)   7.0
   set Edge(9)   7.5
   set Edge(10)  8.0
   set Edge(11)  9.0
   set Edge(12) 10.0
   set Edge(13) 12.0
   set Edge(14) 15.0
   set Edge(15) 20.0

   set OK 1

#
#   Check the relationship between the max and min value, basically need 
#   to know if the values are the same or different to within  some error. 
#   This is done by finding the aboslute value of the ratio of the 2 values
#

   set DiF [expr abs($Max - $Min)]

#
#   This is code used if the data max and min are the same .00001
#   If they are then separate them slightly so that the autoscale code 
#   will not break down
#   1.  Determine if the axis is linear of log scaled
#       A) Log scaled
#          i) center line about +- .01 of value
#       B) Linear scaled
#          i) if not zero set center line about +- .01 of value
#             otherwise center about -.1 and .1
#

   if { $DiF < 0.00001 } {
      if { $Sca == 1 } { 
         set Max [expr $Max * 10.0]
         set Min [expr $Min * 0.1]
      } else {
         if { $Min != 0.0 } {
            if { $Max > 0.0 } {
               set Max [expr $Max + 0.1 * $Max]
            } else { set Max [expr $Max - 0.1 * $Max] }
            if { $Min > 0.0 } {
               set Min [expr $Min + 0.1 * $Min]
            } else { set Min [expr $Min - 0.1 * $Min] }
         } else {
            set Max [expr $Max + 0.1]
            set Min [expr $Min - 0.1]
         }
      }
   }

#
#   If intvl is <= to zero then this is a free form auto scale -
#   there is no user restrictions and we can do what we think is
#   best.  This is only important if the axis is linear scaled.  Log
#   scaled axes ignore intvl altogether
#
#   Determine the following
#   TotLen - the interval between each major tick mark between 0 & 100
#   BasE   - 10**x which will reduce totlen to value between 0 & 10
#   ExP    - the exponent of base (x)
#   Inc    - integer portion of totlen
#
 
   if { ($dV <= 0.0) && ($Sca == 0) } {
       set TotLen [expr abs($Max - $Min) / $MjT ]
       if { $TotLen <= 0.0 } {
          set ExP 1.0
       } else {
          set ExP [expr int(log10($TotLen))]
          if { $TotLen < 1.0 } { incr ExP -1 }
       }
       set BasE [expr pow(10.0, double($ExP))]
       set TotLen [expr $TotLen / $BasE]
       set Inc [expr int($TotLen)]

#
#   Use Inc to determine the best interval between tick marks from a
#   small subset of predetermined values
#
 
       set I 0
       while {($Inc > $Edge($I)) && ($I < 15 ) } { incr I }

       while {$OK} {
 
#
#   1. Get the interval to used between the tick marks (add back the
#      factor of 10**x we removed and remove factor of 10 built into
#      edges array).
#   2. Get half the distance normalized to the tic interval.
#

          set Val [expr $Edge($I) * $BasE]
          set dF  [expr int(($Val * $MjT - $Max + $Min) / $Val / 2.0)]
 
#
#   Compute the minimum and maximum values
#
 
          set Mn [expr (int($Min / $Val) - $dF)  * $Val]
          set Mx [expr $Mn + $MjT * $Val]

#
#   If the minimum is not small enough can we just shift it down and
#   still cover the max data.  If not then go to the next edge value 
#   Make similar check for maximim if minimum is ok
#
 
          if { $Mn > $Min } {
             set Mn [ expr $Mn - $Val]
             set Mx [ expr $Mx - $Val]
             if { $Mx < $Max } {
                incr I 
	        if { $I > 15 } { set OK 0 ; set I 15 } else { set OK 1 }
                continue;
             }
          } elseif { $Mx < $Max } {
             set Mn [ expr $Mn + $Val]
             set Mx [ expr $Mx + $Val]
             if { $Mn > $Min } {
                incr I 
	        if { $I > 15 } { set OK 0 ; set I 15 } else { set OK 1 }
                continue;
             }
          }

         set OK 0
      }
   } else {
      set ExP 0
      if { $Sca } {
         set ExP [expr int(floor(log10($Min)))]
         set Mn [expr pow(10.0, double($ExP))]
         set ExP [expr int(ceil(log10($Max)))]
         set Mx [expr pow(10.0, double($ExP))]
      } else {

# DETERMINE the total number of major intervals for the Min and Max

         set TotLen [expr ($Max - $Min) / $dV ]

# SEE if is a partial interval or its exact

         set ReM [expr $TotLen - int($TotLen)]

# COMPUTE the required number of tick marks to span the values

         if { $ReM > 0.001 } { 
            set TicKs [expr int($TotLen + 1)] 
         } else { set TicKs int($TotLen) }

# DO the required number of intervals evenly fit into the number of intervals
#   defined for the plot?

         set Inc [ expr int($TicKs / $MjT) ]
         set RmD [expr $TicKs % $MjT ]

#        if { $Min < 0.0 } { set MnS - } else { set MnS + }
#        if { $Max < 0.0 } { set MxS - } else { set MxS + }

# IF we have an exact match then get the Mn and Mx we need to use

         if { ($RmD == 0 ) && ($ReM == 0.0) } {
            set Mn $Min
            set Mx [ expr $Max + $dV * TicKs]
            set Val $dV
         } else {

# WE cover more distance that the data covers so center the coverage. 
#     Increment the number intervals needed within a major division

            incr Inc

# THIS is the dV now per major division

            set Val [expr $Inc * $dV]

# COMPUTE the minimum value.

            set mD [expr $Min / $Val ]
            set ReM [expr abs($mD - int($mD))]
            if { $ReM > 0.001 } { 
               if { $mD > 0.0 } {
                  set Mn [expr int($mD + 1) * $Val] 
               } else { set Mn [expr int($mD - 1) * $Val] }
            } else { set Mn [expr int($mD) * $Val] }

# COMPUTE the number of divisions which extend beyond the maximum value and
#   divide by two to center.

            set dF [expr ($Val * $MjT - $Max + $Mn) / $Val /2.0]

# COMPUTE new Mn to center range

	    if { $Mn > 0.0 } {
               set Mn [expr $Mn + int($dF) * $Val] 
            } else { set Mn [expr $Mn - int($dF) * $Val] }

# COMPUTE the Mx to center range

            set Mx [expr $Mn + $MjT * $Val]
         }
      }
   }

   if { $Sca == 0 } {
      set V $Val
      set V [expr fmod($V, 1.0)]
      set V [string trim $V '0']
      set ExP [expr [string length $V] - 1]
   }

   return [list $Mn $Mx $ExP ]
}
