/*  The C equivalent of PLTcontourCell,  It consists of a straignt C        */
/*      interface                                                           */
/*                                                                          */
/*  There are 10 OBJV elements - last two optional.  These are:             */
/*     OBJV[0] :  Routine name                                              */
/*     OBJV[1] :  Plot Window Number                                        */
/*     OBJV[2] :  Data Grid Array                                           */
/*     OBJV[3] :  X Center Cell Array                                       */
/*     OBJV[4] :  Y Center Cell Array                                       */
/*     OBJV[5] :  Data Grid Info Array                                      */
/*     OBJV[6] :  Status Array                                              */
/*     OBJV[7] :  Contour Level                                             */
/*     OBJV[8] :  Coordinate System                                         */
/*     OBJV[9] :  Miscellaneous Information Array                           */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int ContLevelCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv)
{
   void    *memPtr1, *memPtr2;
   int     dType, nX, nY, EndC, EndR, cM, rM;
   int     Flg = TCL_LEAVE_ERR_MSG;
   ReaL_8  BegX, EndX, BegY, EndY, MiN, MaX;
   ReaL_8  *G, *xC, *yC, One = 1.0;
   ReaL_8  cLevel, IgN, IncX, IncY, SeP, rF;
   ReaL_8  X[5], Y[5], V[5], xt[8], yt[8], x1, x2, y1, y2;
   ByTe_4  Bytes, nG, gN[5], A[3], CoL, RoW, I, J, K, L, M, vCnt; 
   ByTe_2  SeGs[4], lFlag[8];
   ByTe_1  *S, cS[4], *wN;
   ByTe_1  *xCyclic, *yCyclic;

   register ByTe_4  R, C, kR, kC;
   ByTe_1  *aName, FunC[200], *FFmt = "Line %s %f %f 0.0 %f %f 0.0";
   ByTe_1  *sName, Index[10];

   Tcl_Obj *rVO, *rV1;
                                                                                
/* MAKE sure that all the IO parameters are present                         */

   if (objc < 10 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: PLTcontourLevel wN ..." );
     return TCL_ERROR;
   }

   rV1 = Tcl_NewObj();

/* GET some of the array inputs                                             */

/*
   Tcl_GetIntFromObj (tI, objv[1], &wN);
*/
   wN = Tcl_GetStringFromObj(objv[1], (int *)0);
   Tcl_GetDoubleFromObj (tI, objv[7], &cLevel);
   Tcl_GetIntFromObj (tI, objv[8], &dType);

   sName = Tcl_GetStringFromObj(objv[6], (int *)0);
   aName = Tcl_GetStringFromObj(objv[5], (int *)0);

   rVO = Tcl_GetVar2Ex(tI, aName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &BegX);
   rVO = Tcl_GetVar2Ex(tI, aName, "1", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &EndX);
   rVO = Tcl_GetVar2Ex(tI, aName, "2", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &BegY);
   rVO = Tcl_GetVar2Ex(tI, aName, "3", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &EndY);
   rVO = Tcl_GetVar2Ex(tI, aName, "4", Flg);
   Tcl_GetIntFromObj (tI, rVO, &nX);
   rVO = Tcl_GetVar2Ex(tI, aName, "5", Flg);
   Tcl_GetIntFromObj (tI, rVO, &nY);

   rVO = Tcl_GetVar2Ex(tI, aName, "15", Flg);
   xCyclic = Tcl_GetStringFromObj(rVO, (int *)0);
   rVO = Tcl_GetVar2Ex(tI, aName, "16", Flg);
   yCyclic = Tcl_GetStringFromObj(rVO, (int *)0);

   aName = Tcl_GetStringFromObj(objv[9], (int *)0);

   rVO = Tcl_GetVar2Ex(tI, aName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &IgN);
   rVO = Tcl_GetVar2Ex(tI, aName, "1", Flg);
   Tcl_GetIntFromObj (tI, rVO, &cM);
   rVO = Tcl_GetVar2Ex(tI, aName, "2", Flg);
   Tcl_GetIntFromObj (tI, rVO, &rM);
   rVO = Tcl_GetVar2Ex(tI, aName, "3", Flg);
   Tcl_GetIntFromObj (tI, rVO, &EndC);
   rVO = Tcl_GetVar2Ex(tI, aName, "4", Flg);
   Tcl_GetIntFromObj (tI, rVO, &EndR);

   nG = nX * nY;
   Bytes = 3 * sizeof(ReaL_8) * nG;
   if ((memPtr1 = malloc (Bytes)) == NULL) {  return TCL_ERROR; }
   G  = (ReaL_8 *)memPtr1;
   xC = (ReaL_8 *)memPtr1 + nG;
   yC = (ReaL_8 *)memPtr1 + 2 * nG;

   if (TclArrayToC (tI, objv[2], (void *)G, nG, 0, 'D') == 0) {
      free (memPtr1);
      return TCL_OK;
   }
   if (TclArrayToC (tI, objv[3], (void *)xC, nG, 0, 'D') == 0) {
      free (memPtr1);
      return TCL_OK;
   }
   if (TclArrayToC (tI, objv[4], (void *)yC, nG, 0, 'D') == 0) {
      free (memPtr1);
      return TCL_OK;
   }

   Bytes = sizeof(ByTe_1) * nG;
   if ((memPtr2 = malloc (Bytes)) == NULL)
     return TCL_ERROR;
   S  = (ByTe_1 *)memPtr2;

   if (TclArrayToC (tI, objv[6], (void *)S, nG, 0, 'C') == 0) {
      free (memPtr1);
      free (memPtr2);
      return TCL_OK;
   }

   IncX = (EndX - BegX) / (ReaL_4)nX;
   IncY = (EndY - BegY) / (ReaL_4)nY;
   for (R = 0, kR = 0; R < EndR; ++R, kR += rM ) { 
      for (C = 0, kC = 0; C < EndC; ++C, kC += cM ) { 
         gN[0] = kR + kC;
         if (S[gN[0]] == 1) { continue; }

         CoL = (C + 1 + nX) % nX;
         if (C > CoL) { ++CoL; }
         RoW = (R + 1 + nY) % nY;
         if (R > RoW) { ++RoW; }

         gN[1] = C * cM + RoW * rM;
         gN[2] = CoL * cM + RoW * rM;
         gN[3] = CoL * cM + R * rM;

         V[4] = 0.0;
         vCnt = 0;
         MaX = -1.0e30;
         MiN = 1.0e30;
         for (I = 0; I < 4; ++I ) { cS[I] = 1; }
         for (I = 0; I < 4; ++I ) {
            V[I] = *(G + gN[I]); 
            X[I] = *(xC + gN[I]); 
            Y[I] = *(yC + gN[I]); 
            if (V[I] > IgN) {
               V[4] += V[I];
               if ( MiN > V[I] ) {  MiN = V[I]; }
               if ( MaX < V[I] ) {  MaX = V[I]; }
               ++vCnt;
            } else {
               cS[I] = 0;
               cS[(I + 3) % 4] = 0;
            }
         }
 
         if ( vCnt != 0 ) {
            V[4] /= (ReaL_8)vCnt;
            X[4] = X[0] + IncX / 2.0;
            Y[4] = Y[0] + IncY / 2.0;
         } else {  continue; }

         if ((cLevel >= MiN) && (cLevel < MaX)) {
            for (I = 0; I < 4; ++I ) { SeGs[I] = 0; }
            if (V[4] == cLevel) {
               for (J = 0, M = 4; J < 4; ++J, ++M ) { 
                  lFlag[M] = 0;
                  lFlag[J] = 1;
                  xt[J] = X[4];
                  yt[J] = Y[4];
                  if (cS[J] == 0) { continue; }
                  L = (J + 1) % 4;
                  if (V[J] > V[L]) {
                     MiN = V[L];
                     MaX = V[J];
                  } else { MiN = V[J]; MaX = V[L]; }
                  if ( (cLevel >= MiN) && (cLevel <= MaX) ) {
                     SeP = V[J] - V[L];
                     if ( SeP != 0.0 ) {
                        rF = (cLevel - V[L]) / SeP;
                        xt[M] = X[L] + (X[J] - X[L]) * rF;
                        yt[M] = Y[L] + (Y[J] - Y[L]) * rF;
                        lFlag[M] = 1;
                        SeGs[J] = 2;
                     }
                  }
               }
            } else {
               for (J = 0, M = 4; J < 4; ++J, ++M ) { 
                  lFlag[M] = 0;
                  lFlag[J] = 0;
                  if (cS[J] == 0) { continue; }
                  K = (J + 3) % 4;
                  L = 4;
                  if (V[J] > V[L]) {
                     MiN = V[L];
                     MaX = V[J];
                  } else { MiN = V[J]; MaX = V[L]; }
                  if ( (cLevel >= MiN) && (cLevel <= MaX) ) {
                     rF = (cLevel - V[L]) / (V[J] - V[L]);
                     xt[J] = X[L] + (X[J] - X[L]) * rF;
                     yt[J] = Y[L] + (Y[J] - Y[L]) * rF;
                     lFlag[J] = 1;
                     ++SeGs[J];
                     ++SeGs[K];
                  }
                  L = (J + 1) % 4;
                  if (V[J] > V[L]) {
                     MiN = V[L];
                     MaX = V[J];
                  } else { MiN = V[J]; MaX = V[L]; }
                  if ( (cLevel >= MiN) && (cLevel <= MaX) ) {
                     SeP = V[J] - V[L];
                     if (SeP != 0.0) {
                        rF = (cLevel - V[L]) / SeP;
                        xt[M] = X[L] + (X[J] - X[L]) * rF;
                        yt[M] = Y[L] + (Y[J] - Y[L]) * rF;
                        lFlag[M] = 1;
                        ++SeGs[J];
                     }
                  }
               }
            }

            for (J = 0, L = 4; J < 4; ++J, ++L ) { 
               if (SeGs[J] != 2 ) { continue; }
               K = (J + 1) % 4;
               M = 0;
               if (lFlag[J] == 1 ) { A[M++] = J; }
               if (lFlag[K] == 1 ) { A[M++] = K; }
               if (lFlag[L] == 1 ) { A[M] = L; }
               if (dType == 1) {
                  x1 = yt[A[0]] * cos(xt[A[0]]);
                  y1 = yt[A[0]] * sin(xt[A[0]]);
                  x2 = yt[A[1]] * cos(xt[A[1]]);
                  y2 = yt[A[1]] * sin(xt[A[1]]);
                  sprintf (FunC, FFmt, wN, x1, y1, x2, y2);
               } else {
                  sprintf (FunC,FFmt,wN,xt[A[0]],yt[A[0]],xt[A[1]],yt[A[1]]);
               }
               Tcl_Eval(tI, FunC);
            }
         } else { 
            if (MaX < cLevel) { 
               sprintf(Index, "%d", gN[0]);
	       rV1 = Tcl_DuplicateObj(rV1);
	       Tcl_SetDoubleObj(rV1, One);
	       Tcl_SetVar2Ex(tI, sName, Index, rV1, Flg);
           }
        }
     }
  }
  return TCL_OK;
}
