/*  The C equivalent of PLTcontourCell,  It consists of a straignt C        */
/*      interface                                                           */
/*                                                                          */
/*  There are 10 OBJV elements - last two optional.  These are:             */
/*     OBJV[0] :  Routine name                                              */
/*     OBJV[1] :  Data Grid Number (gN)                                     */
/*     OBJV[2] :  X Center Cell Array                                       */
/*     OBJV[3] :  Y Center Cell Array                                       */
/*     OBJV[4] :  Info-Array                                                */
/*     OBJV[5] :  Data Grid Array                                           */
/*     OBJV[6] :  Cell X Position Array                                     */
/*     OBJV[7] :  Cell Y Position Array                                     */
/*     OBJV[8] :  Cell Intensity Array                                      */
/*     OBJV[9] :  Cell Status Array                                         */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int ContCellCmd (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   int     rV = 1;
   int     Flg = TCL_LEAVE_ERR_MSG;
   ReaL_8  X[5], Y[5], V[5], cF[5];
   register ByTe_4  I, J;
   ByTe_2  S[4];
   ByTe_1  *aName, *aNameX, *aNameY, *aNameV;
   ByTe_1  Index[10], *gN;
   Tcl_Obj *oPtr;
   Tcl_Obj *rVO;
                                                                                
/* MAKE sure that all the IO parameters are present                         */

   if (objc < 10 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: PLTcontourCell gN ..." );
     return TCL_ERROR;
   }

/* GET some of the array inputs                                             */

   aName = Tcl_GetStringFromObj(objv[4],(int *)0);
   if ( (rVO = Tcl_GetVar2Ex(tI, aName, "0", Flg)) != NULL) {
      Tcl_GetDoubleFromObj (tI, rVO, &cF[0]);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, aName, "1", Flg)) != NULL) {
      Tcl_GetDoubleFromObj (tI, rVO, &cF[1]);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, aName, "2", Flg)) != NULL) {
      Tcl_GetDoubleFromObj (tI, rVO, &cF[2]);
   }

   aName  = Tcl_GetStringFromObj(objv[1], (int *)0);
   aNameX = Tcl_GetStringFromObj(objv[2], (int *)0);
   aNameY = Tcl_GetStringFromObj(objv[3], (int *)0);
   aNameV = Tcl_GetStringFromObj(objv[5], (int *)0);

   for (I=0; I<4; ++I ) { 
      sprintf (Index, "%d", I);
      rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
      gN =  Tcl_GetStringFromObj(rVO, (int *)0);
      rVO = Tcl_GetVar2Ex(tI, aNameX, gN, Flg);
      Tcl_GetDoubleFromObj (tI, rVO, &X[I]);
   
      rVO = Tcl_GetVar2Ex(tI, aNameY, gN, Flg);
      Tcl_GetDoubleFromObj (tI, rVO, &Y[I]);

      rVO = Tcl_GetVar2Ex(tI, aNameV, gN, Flg);
      Tcl_GetDoubleFromObj (tI, rVO, &V[I]);
   }
   V[4] = 0.0;

/* INITIALIZE cell status array                                             */
  
   for (I = 0; I < 4; ) { S[I++] = 1; }

   J = 0;
   cF[3] = 1.0e30;
   cF[4] = -1.0e30;
   for (I = 0; I < 4; ++I ) { 
      if ( V[I] > cF[2] ) {
         V[4] += V[I];
         if ( cF[3] > V[I] ) {  cF[3] = V[I]; }
         if ( cF[4] < V[I] ) {  cF[4] = V[I]; }
         ++J;
      } else {
         S[I] = 0;
         S[(I + 3) % 4] = 0;
      }
   }
 
   if ( J != 0 ) {
      V[4] /= (ReaL_8)J;
      X[4] = X[0] + cF[0] / 2.0;
      Y[4] = Y[0] + cF[1] / 2.0;
   } else {  rV = -1; }

   if ( rV == 1 ) {
      CArrayToTcl(tI, objv[4], cF, 5, 0, 'D');
      CArrayToTcl(tI, objv[6], X, 5, 0, 'D');
      CArrayToTcl(tI, objv[7], Y, 5, 0, 'D');
      CArrayToTcl(tI, objv[8], V, 5, 0, 'D');
      CArrayToTcl(tI, objv[9], S, 4, 0, 'S');
   } 

   oPtr = Tcl_GetObjResult(tI);
   Tcl_SetIntObj (oPtr, rV);
   return TCL_OK;
}
