package provide TclPLT 1.0

proc PlotFunc { wN pN FmT InPuT Beg End dX { PoPs "" } } {
    global PltInfo WinInfo

    upvar $PoPs  oP

#  Set Defaults 

    if ![info exists oP(XLAB)]  { set oP(XLAB)  "" }
    if ![info exists oP(YLAB)]  { set oP(YLAB)  "" }
    if ![info exists oP(NCOL)]  { set oP(NCOL)  255 }
    if ![info exists oP(LCOL)]  { set oP(LCOL)  255 }
    if ![info exists oP(PSET)]  { set oP(PSET)  YES }
    if ![info exists oP(XAS)]   { set oP(XAS)   NO }
    if ![info exists oP(YAS)]   { set oP(YAS)   YES }
    if ![info exists oP(XASOP)] { set oP(XASOP)  "" }
    if ![info exists oP(YASOP)] { set oP(YASOP)  "" }
    if ![info exists oP(PFMT)]  { set oP(PFMT)  LINE }
    if ![info exists oP(POPS)]  { set oP(POPS)  [list 255] }
    if ![info exists oP(AX)]    { set oP(AX)  Xb }
    if ![info exists oP(AY)]    { set oP(AY)  Yb }
    if ![info exists oP(XTIC)] { set oP(XTIC) BOTH }
    if ![info exists oP(YTIC)] { set oP(YTIC) BOTH }

    set Np 0
    if [string match ALGORITHM $FmT] {
       for { set X $Beg } { $X <= $End } { set X [expr $X + $dX] ; incr Np } {
          set U($Np) $X
          set V($Np) [expr $InPuT]
       }
    } else {
       set FunC "set V(\$Np) \[\$InPuT \$X\]"
       for { set X $Beg } { $X <= $End } { set X [expr $X + $dX] ; incr Np } {
          set U($Np) $X
	  eval $FunC
       }
    }

    DefinePlot $pN $wN
    if [string match YES $oP(XAS)] { AutoScale $pN $oP(AX) U $Np $oP(XASOP) }
    if [string match YES $oP(YAS)] { AutoScale $pN $oP(AY) V $Np $oP(YASOP) }

    if [string match YES $oP(PSET)] {
       if { [string match Yl $oP(AY)] || [string match Yb $oP(AY)] } {
          set yN BOT
          if [string match BOTH $oP(YTIC) ] { set yT BOTH } else { set yT BOT }
          set ylLab $oP(YLAB)
          set yrLab ""
       } else {
          set yN TOP
          if [string match BOTH $oP(YTIC) ] { set yT BOTH } else { set yT TOP }
          set yrLab $oP(YLAB)
          set ylLab ""
       }
       if [string match Xb $oP(AX)] {
          set xN BOT
          if [string match BOTH $oP(XTIC) ] { set xT BOTH } else { set xT BOT }
          set xbLab $oP(XLAB)
          set xtLab ""
       } else {
          set xN TOP
          if [string match BOTH $oP(XTIC) ] { set xT BOTH } else { set xT TOP }
          set xbLab $oP(XLAB)
          set xtLab ""
       }

       set LOps [list $xbLab 1.0 $ylLab 1.0 $xtLab 1.0 $yrLab 1.0]
       set NOps [list $xN $yN $xT $yT]

       PLTinfoChg $pN ALL NUMBERS NCOLOR $oP(NCOL)
       PLTinfoChg $pN ALL NUMBERS TCOLOR $oP(LCOL)
       PlotOutlines $pN $LOps $NOps
    }

    Plot2D $pN $oP(AX) $oP(AY) U V 0 [expr $Np -1] $oP(PFMT) $oP(POPS)
}
