package provide TclPLT 1.0

# INPUTS
#  
#  wN      -  Plot Window Number
#  Data1   -  Array of X values
#  Data2   -  Array of Y values
#  Data3   -  Array of Intensity values
#  Format  -  Plot format ; AUTO/MANUAL 
#             AUTO   - evenly spaced grids - Data1 and Data2 are ignored
#             MANUAL - Data1 and Data2 give data location in plot
#  Ops Array should be the grid information array and may include the
#     extra elements:
#
#    UF  : UPDATE FREQUENCY
#    PF  : FLAT/ELEVATE/SCATTER (ELEVATE and SCATTER work with vtk driver)
                
proc Plot3D { pN Xaxis Yaxis Data1 Data2 Data3 Format Ops cInfo } {
   global WinInfo PltInfo GphInfo uGrid ugI

# GET Y axis designation to its normal naming convention

   if { [string match Yl $Yaxis] } { set Yaxis Yb }
   if { [string match Yr $Yaxis] } { set Yaxis Yt }

#  Get the curent window number

   set wN $PltInfo($pN,wN)

#  GET the array to local values.  AUTO plots have only a Data3 array
#    associated with them

   upvar $cInfo cI
   upvar $Ops Opt
   upvar $Data3 V3
   if ![string match AUTO $Format] {
      upvar $Data1 V1
      upvar $Data2 V2
   }

# GET the format.  Its FLAT is not specified

   if [info exists Opt(PF)] { set pFmt $Opt(PF) } else { set pFmt FLAT }

# NOT shunt off the the proper plot routine

   switch -exact -- $pFmt {
      ELEVATE { 
         PLTvtk3DGrid $wN _X _Y V3 Opt cI 
      }
      FLAT { PLTflatPlot $wN $Xaxis $Yaxis V1 V2 V3 $Format Opt cI }
      SCATTER { }
   }
}
