package provide TclPLT 1.0

# SYNOPSIS : Depending on the set actions, this routine will produce
#            one or more labeled or unlabled lick marks against Axis
#            or will produce axis text labels.
#
# INPUTS
#  TAction :  ALLMAJOR, ALLMINOR, ONEMAJOR, ONEMINOR, BOTH, NONE
#  LAction :  MANUAL, AUTO, AXIS, NONE
#  Level   :  Level of annotation
#  Pos     :  Location to place LABEL
#  TJust   :  Text justification when LAction is TEXT
#  Label   :  Label when LAction is TEXT

#  PUTTING up the axis and labeling around a polar plot is not as straight
#    forward as around a rectangular plot.  Generally to set offsets you
#    need to draw the tick marks on all axis prior to putting up labels.
#    Because of this there is really very little pre-setup that should be
#    omitted due ticks not being drawn.

proc PLTwheelLabs {pN TAction LAction Level Min Max Sca } { 
   global PltInfo WinInfo GphInfo DevInfo RtoD

# SAVE current text settings so we can reset them later and turn off fill
#   should it be on

   if [string match LINEAR $Sca] { set Sca 0 }
   if [string match LOG $Sca] { set Sca 1 }

   set OldlC $GphInfo(lColor)
   set OldtC $GphInfo(tColor)
   set OldtS $GphInfo(tSize)
   set OldtB $GphInfo(tBold)
   PlotColor HOLD HOLD OFF
                                                                                
# GET the screen designation and the window in which we are outputting

   set sC Scr$GphInfo(CurScr)
   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# GET the current Y tick and label inforamtion settings.

   PLTinfoCur $pN Yb nI tI

# GET the tick and number limits initialized.

   PLTaxisLims $pN Yb INITIALIZE 

#  NEED the distance across the plot so that we can normalize tick mark
#    lengths.  Lengths are given between 0 and 1 and 1 looks like it runs
#    from the origin to the outer extent of the plot.

   set yL  [expr abs($WinInfo($pN,p4) - $WinInfo($pN,p1))]

# RANGE of color bar

   set sMj $Min
   set eMj $Max

# NEED to map the color table min and max values to  0 to 360 degrees. This
#   is done as P = AV + B where P is the phase and V is the value.  Since
#   it is linear need to us log of Max and Min when axis is log scaled.

   if $Sca {
      set Mn [expr log10($Min)]
      set Mx [expr log10($Max)]
      set A [expr 360.0 / ($Mx - $Mn)]
      set B [expr -$A * $Mn]

      set sMj [expr pow(10.0, ceil(log10($Min)))]
      set bMj [expr pow(10.0, floor(log10($Min)))]
      set IncSgn *
      set dMj 10.0

      if { [lindex $tI 5] == 2 }  {
         set dMn 5
      } elseif { [lindex $tI 5] < 6 }  {
         set dMn 2
      } else { set dMn 1 }

   } else { 
      set A [expr 360.0 / ($Max - $Min)]
      set B [expr -$A * $Min]
      set IncSgn +
      set dMj [expr ($eMj - $sMj) / double([lindex $tI 4])]
      set dMn [expr $dMj / double([lindex $tI 5]) ]
   }


#  GET the maximum extent of the plot in both X (radius) and Y (phi).  For now
#    make the tacit assumption that polar plots run 0 to 360 degrees. 

   set StartX 0.0
   set StopX  $WinInfo($pN,p3)
   set StartY 0.0
   set StopY  360.0

# IF there are labels to be output set up the text properties now

   if ![string match NONE $LAction] {
      if [ string match AXIS $LAction ] {
         TextProp [lindex $nI 7 ] HOLD [lindex $nI 8 ]
         set Place [lindex $nI 9 ]
         set Pos [PLTlabPos $pN Yb $Pos]
         set lCol [lindex $nI 6]
      } else {
         TextProp [lindex $nI 3 ] HOLD [lindex $nI 4 ]
         set Place [lindex $nI 0 ]
         set Just center
         set lCol [lindex $nI 2]
      }
      set TmP [ GPHtextLen "5" XY]
      set tS(0) [lindex $TmP 0]
      set tS(1) [lindex $TmP 1]
   }

# SET up any tick mark properites that depend on what tick marks are being
#     output

   if {[ string match *MAJ* $TAction ] || [ string match BOTH $TAction ] } {
       set DoMajor 1
   } else { set DoMajor 0 }
   if {[ string match *MIN* $TAction ] || [ string match BOTH $TAction ]} {
       set DoMinor 1
   } else { set DoMinor 0 }
   if {[ string match MANUAL $LAction ] || [ string match AUTO $LAction ]} {
       set DoPrint 1
   } else { set DoPrint 0 }

# DO the tick mark output first if there is any to be done

   if ![string match NONE $TAction] {

# SET up variables common to tick marks being produced on either the X or
#   the Y axes.  The first of these are the tick mark lengths together with
#   the algorithms to use in establishing the tick end points.  The latter 
#   depends on the format of the tick mark being drawn. 

      set tLMj [expr [lindex $tI 2] * $yL]
      switch -exact -- [lindex $tI 0] {
         INSIDE   {  set VaMj $StopX ; set VbMj [expr $StopX - $tLMj] }
         OUTSIDE  {  set VaMj $StopX ; set VbMj [expr $StopX + $tLMj] }
         STRADDLE {  
	    set VaMj [expr $StopX - $tLMj / 2.0]
	    set VbMj [expr $StopX + $tLMj / 2.0]
         }
         SPAN     {  set VaMj 0.0 ; set VbMj $StopX }
      }

      set tLMn [expr [lindex $tI 3] * $yL]
      switch -exact -- [lindex $tI 1] {
         INSIDE   {  set VaMn $StopX ; set VbMn [expr $StopX - $tLMn] }
         OUTSIDE  {  set VaMn $StopX ; set VbMn [expr $StopX + $tLMn] }
         STRADDLE {  
	    set VaMn [expr $StopX - $tLMn / 2.0]
	    set VbMn [expr $StopX + $tLMn / 2.0]
         }
         SPAN     {  set VaMn 0.0 ; set VbMn $StopX }
      }

      if $DoPrint {
         if { $Level < 0.0 } { 
	    set Off [expr ($Level - 0.5) * $tS(1)]
	 } else { set Off [expr ($Level + 0.5) * $tS(1)] }
	 set lR  [expr [lindex $PltInfo($pN,tO) 3 ] + $Off]
	 set lCol [lindex $nI 2]
	 TextProp [lindex $nI 3] HOLD [lindex $nI 4]
	 if [ string match INSIDE $Place ] { set SgN - } else { set SgN + }
      }

      if { $DoMajor && ![string match SPAN [lindex $tI 0]] } {
         set DeG [expr atan2($tLMj, $StopX)]
         set Xa [expr $tLMj * sin(-$VaMj * $DeG)]
         set Xb [expr $tLMj * sin($VbMj * $DeG)]
	 PLTaxisLims $pN Xc TICK $Xa $Xb
      }

      if { $DoMinor && ![string match SPAN [lindex $tI 1]] } {
         set DeG [expr atan2($tLMn, $StopX)]
         set Xa [expr $tLMn * sin(-$VaMn * $DeG)]
         set Xb [expr $tLMn * sin($VbMn * $DeG)]
	 PLTaxisLims $pN Xc TICK $Xa $Xb
      }

# SET the tick mark colors 

      set tColMj [lindex $tI 6]
      set tColMn [lindex $tI 7]

      set W1 $sMj
      while { $W1 < $eMj } {
	 if $Sca {
	    set Phi [expr ($A * log10($W1) + $B) / $RtoD]
         } else { set Phi [expr ($A * $W1 + $B) / $RtoD] }

         set Xa [expr $VaMj * cos ($Phi)]   
         set Ya [expr $VaMj * sin ($Phi)]
         set Xb [expr $VbMj * cos ($Phi)]   
         set Yb [expr $VbMj * sin ($Phi)]
	 set GphInfo(lColor) $tColMj
         Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0

         if $DoPrint {
	    set X  [expr $lR * cos($Phi)]
	    set Y  [expr $lR * sin($Phi)]
            set Phi [expr $Phi * $RtoD]
	    if { ($Phi < 80.0) || ($Phi > 280.0) } {
	       set Just right
            } elseif { ($Phi > 110.0) && ($Phi < 250.0) } {
                set Just left
            } else { set Just center }
            set LaB [PLTnumFmt $W1 [lindex $nI 1] ]
            PLTdoLab $pN $X $Y $Just $LaB $lCol [list 1 0 NONE]
	    set Xo [expr $X $SgN [GPHtextLen $LaB X]]
	    set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
	    PLTaxisLims $pN Yb NUMBER $Xo $Xo
	    PLTaxisLims $pN Yt NUMBER $Xo $Xo
	    PLTaxisLims $pN Xb NUMBER $Yo $Yo
	    PLTaxisLims $pN Xt NUMBER $Yo $Yo
         }
          
         if $DoMinor {
	    set W2 [expr $W1 $IncSgn $dMn]
            set GphInfo(lColor) $tColMn
            set NextMj [expr $W1 $IncSgn $dMj]
	    set tCnt 1
	    while { ($W2 < $NextMj) && ($W2 <= $eMj) } {
	       if $Sca {
	          set Phi [expr ($A * log10($W2) + $B) / $RtoD]
               } else { set Phi [expr ($A * $W2 + $B) / $RtoD] }

               set Xa [expr $VaMn * cos ($Phi)]   
               set Ya [expr $VaMn * sin ($Phi)]
               set Xb [expr $VbMn * cos ($Phi)]   
               set Yb [expr $VbMn * sin ($Phi)]
               set GphInfo(lColor) $tColMj
               Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
               set W2 [expr $W1 $IncSgn $dMn * $tCnt]
	       incr tCnt
            }
	 }
	 set W1 [expr $W1 $IncSgn $dMj]
      }

      if { ($bMj < $Min) && $DoMinor && $Sca } {
         set GphInfo(lColor) $tColMn
	 set tCnt 1

	 set W2 [expr $bMj $IncSgn $dMn]
	 while { $W2 < $Min } {
            set W2 [expr $bMj $IncSgn $dMn * $tCnt]
	    incr tCnt
         }

	 while { $W2 < $sMj } {
	    if $Sca {
	       set Phi [expr ($A * log10($W2) + $B) / $RtoD]
            } else { set Phi [expr ($A * $W2 + $B) / $RtoD] }

            set Xa [expr $VaMn * cos ($Phi)]   
            set Ya [expr $VaMn * sin ($Phi)]
            set Xb [expr $VbMn * cos ($Phi)]   
            set Yb [expr $VbMn * sin ($Phi)]
            set GphInfo(lColor) $tColMj
            Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
            set W2 [expr $bMj $IncSgn $dMn * $tCnt]
	    incr tCnt
         }
      }
   }

   TextProp $OldtS HOLD $OldtB
   set GphInfo(lColor) $OldlC
   set GphInfo(tColor) $OldtC
}
