package provide TclPLT 1.0

# INPUTS
#    Axis    :  X Y
#    Btime   :  Beginning Time List
#    Etime   :  Ending Time List
#
#  TIME FORMATS
#       Index 0 - Year
#       Index 1 - Day
#       Index 2 - Hour
#       Index 3 - Minute
#       Index 4 - Sec
#       Index 5 - Nanosecond
#  or
#       Index 0 - Year
#       Index 1 - Day
#       Index 2 - Millisecond
#       Index 3 - Nanosecond
# or
#       Index 0 - Year
#       Index 1 - Day
#       Index 2 - Hour
#       Index 3 - Minute
#       Index 4 - Sec
#       Index 5 - Millisecond
#       Index 6 - Microsecond
#       Index 7 - Nanosecond

proc PLTtimeBase { pN Axis Btime Etime } {

   global PltInfo

# RETRIEVE the plot window so that we can pull out some of its characteristics

   set wN $PltInfo($pN,wN)

# RETRIEVE the number of pixels along the time based axis

   switch -exact -- $Axis {
      X  {  set nPix [lindex $PltInfo($pN,Pix) 0] }
      Y  {  set nPix [lindex $PltInfo($pN,Pix) 1] }
   }

# DETERMINE a suitable time base to use in all computations.  Then set
#
#      bT:  A relative start time
#      eT:  The difference between the plot start and stop times     
#      T1:  The plot start time as Year ... Nsec
#      T2:  The plot end time as Year ... Nsec
#      dT:  The relative plot end time from a time of 0.0 in Year ... Nsec

   set Base -1
   set bT 0.0
   set eT [TUtimeConv $Btime $Etime 0 Base] 
   set T1 [TUtimeConv $Btime $bT 3 Base] 
   set T2 [TUtimeConv $Btime $eT 3 Base] 
   set dT [TUtimeConv [list 0 1 0 0] $eT 3 Base] 

# DETERMINE
#
#   dTm:  The time across the plot
#   TpP:  The time per pixel in the plot
#   TLen: The base number of pixels in a generic time label
#   TpL:  The total number of pixels 

   set dTm [ expr ($eT - $bT) ]
   if { $dTm == 0 } return
   set TpP [expr $dTm / $nPix]
   set TLen [GPHtextLen 0000:0000]
   set TpL [ expr $dTm * $TLen / $nPix ]
   
   set TesT  [list 0 1 0 0 0 0 0 0]
   set tPos 0
   while { [lindex $dT $tPos ] == [lindex $TesT $tPos]  } { incr tPos }
   if {$tPos > 0 } { 
      set J [expr $tPos - 1]
      if { [lindex $T2 $J ] != [lindex $T1 $J] } { set tPos $J }
   }
   set Mjs [expr [lindex $T2 $tPos] - [lindex $T1 $tPos] + 1]

   set TmP [lindex $T1 $tPos] 
   for { set I [expr $tPos + 1] } { $I < 8 } { incr I } {
      if {[lindex $T1 $I] > 0 } {
         incr TmP
         break;
      } 
   }

   if { $tPos == 0 } {
      lappend T3 $TmP
      lappend T3 [lindex $T1 1]
      set BeG 2
   } else { set BeG 0 }

   for { set I $BeG } { $I < 8 } { incr I } {
      if {$I < $tPos } {
         lappend T3 [lindex $T1 $I]
      } elseif { $I == $tPos } {
         lappend T3 $TmP
      } else { lappend T3 0 }
   }
  
   set sT [TUtimeConv $T1 $T3 0 Base] 
   set PltInfo($pN,TmI) [list $tPos $Base $bT $eT $sT $nPix $TpP $TpL $Mjs]
}
