package provide TclPLT 1.0

# INPUTS
#  
#  pN     -  Plot Number
#  Xs     -  Array of X values
#  Ys     -  Array of Y values
#  Zs     -  Array of Z values
#  Beg     -  Starting point in arrays
#  End     -  Ending point in arrays
#  Ops List
#    Index 0 : Plot Format  (2D, 3D)
#    Index 1 : Line Color
#  ExC List
#    Index 0 : X Data Exclusion : NONE < > >= <= ==  
#    Index 1 : X Data Exclusoin Value
#    Index 2 : Y Data Exclusion : NONE < > >= <= ==  
#    Index 3 : Y Data Exclusoin Value
#    Index 4 : Z Data Exclusion : NONE < > >= <= ==  
#    Index 5 : Z Data Exclusoin Value

                
proc PLTlinePlot { wN xA yA Xs Ys Zs Vs Beg End Ops { ExC "" } } {
   global WinInfo PltInfo GphInfo 

#  There are 2 different formats of line plot.  All need at least X
#    and Y so get those arrays set here

   upvar $Xs X
   upvar $Ys Y

   if { [string match Yl $yA] } { set yA Yb }
   if { [string match Yr $yA] } { set yA Yt }

# Save some value which might get changed and need to be reset

   set lC $GphInfo(lColor)
   set fC $GphInfo(fColor)
   set OldX $WinInfo($wN,X)
   set OldY $WinInfo($wN,Y)
   set OldClip $WinInfo($wN,Clip)

# GET the correct set of axis scaled

   if { [string match Xb $xA] } { set aX Xp } else { set aX Xs }
   if { [string match Yb $yA] } { set aY Yp } else { set aY Ys }
   GPHwinScale $wN $aX $aY Zc 0

# BECAUSE it wasn't demanded in earlier versions its entirely possible that
#   there is no X array.  In this case we compute a set of X values which
#   are evenly spaced across the plot.

   if { [info exists X] == 0 } {
      set ByeByeX 1
      set nP [expr $End - $Beg]
      set X(0) $WinInfo($wN,p0)
      if { $nP > 0 } {
         set IncX [expr ($WinInfo($wN,p3) - $X(0))/double($nP)]
      } else { set IncX 0 }
      for { set J 0; set I 1 } { $I <= $nP } { incr I ; incr J } {
         set X($I) [ expr $X($J) + $IncX ]
      }
   } else { set ByeByeX 0 }

# Set up the X and Y exclusion commands.

   set eL [llength $ExC]

   if { $eL > 0 } { set Cond [lindex $ExC 0] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdx { if { $X($I) == [lindex $ExC 1] } { set OKx 0 } } }
      >    { set Cmdx { if { $X($I) > [lindex $ExC 1] }  { set OKx 0 } } }
      <    { set Cmdx { if { $X($I) < [lindex $ExC 1] }  { set OKx 0 } } }
      >=   { set Cmdx { if { $X($I) >= [lindex $ExC 1] } { set OKx 0 } } }
      <=   { set Cmdx { if { $X($I) <= [lindex $ExC 1] } { set OKx 0 } } }
      default { set Cmdx {set OKx 1 } }
   }

   if { $eL > 2 } { set Cond [lindex $ExC 2] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdy { if { $Y($I) == [lindex $ExC 3] } { set OKy 0 } } }
      >    { set Cmdy { if { $Y($I) > [lindex $ExC 3] }  { set OKy 0 } } }
      <    { set Cmdy { if { $Y($I) < [lindex $ExC 3] }  { set OKy 0 } } }
      >=   { set Cmdy { if { $Y($I) >= [lindex $ExC 3] } { set OKy 0 } } }
      <=   { set Cmdy { if { $Y($I) <= [lindex $ExC 3] } { set OKy 0 } } }
      default { set Cmdy {set OKy 1 } }
   }

   if { $eL > 4 } { set Cond [lindex $ExC 4] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdz { if { $Z($I) == [lindex $ExC 5] } { set OKz 0 } } }
      >    { set Cmdz { if { $Z($I) > [lindex $ExC 5] }  { set OKz 0 } } }
      <    { set Cmdz { if { $Z($I) < [lindex $ExC 5] }  { set OKz 0 } } }
      >=   { set Cmdz { if { $Z($I) >= [lindex $ExC 5] } { set OKz 0 } } }
      <=   { set Cmdz { if { $Z($I) <= [lindex $ExC 5] } { set OKz 0 } } }
      default { set Cmdz {set OKz 1 } }
   }

# SET the plot line color 

   set oL [llength $Ops]
   if { $oL > 1 } { set cC [lindex $Ops 1] } else { set cC 255 }

   PlotColor HOLD $cC HOLD

# SWITCH between the different line plot formats.  These are
#    2D  - just X and Y
#    3D  - X, Y and Z
#    2DC - X and Y and V is color
#    3DC - X, Y and Z and V is color

  set OKx 1 ; set OKy 1 ; set OKz 1 
   switch -exact -- [lindex $Ops 0] {
      2D {
         set WinInfo($wN,Clip) 2
         set First 1
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy
            if {$OKx && $OKy} {
               if {$First} {
                  GPHlineData $X($I) $Y($I) 0.0 0 0
                  set First 0
               } else { GPHlineData $X($I) $Y($I) 0.0 1 0 }
            } else { 
               set OKx 1 ; set OKy 1 
               if { $First == 0 } { GPHlineData $X($I) $Y($I) 0.0 0 2 }
               set First 1
            }
         }
         GPHlineData 0.0 0.0 0.0 0 2
      }
      2DC {
         upvar $Vs CoLor
         set WinInfo($wN,Clip) 2
         set First 1

	 set I $Beg
         set X1 $X($I)
         set Y1 $Y($I)
         eval $Cmdx ; eval $Cmdy
	 set OKx1 $OKx
	 set OKy1 $OKy
	 incr I

         for { } { $I <= $End } { incr I } { 
            PlotColor HOLD $CoLor($I) HOLD
            eval $Cmdx ; eval $Cmdy
            if {$OKx && $OKy && $OKx1 && $OKy1} {
               GPHlineData $X1 $Y1 0.0 0 0
               GPHlineData $X($I) $Y($I) 0.0 1 1
            }
	    set OKx1 $OKx
	    set OKy1 $OKy
	    set X1 $X($I)
	    set Y1 $Y($I)

         }
      }
      3D {
         upvar $Zs Z
         set First 1
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy ; eval $Cmdz
            if {$OKx && $OKy} {
               if {$First} {
                  GPHlineData $X($I) $Y($I) $Z($I) 0 0
                  set First 0
               } else { GPHlineData $X($I) $Y($I) $Z($I) 1 0 }
            } else { 
               set OKx 1 ; set OKy 1 
               if { $First == 0 } { GPHlineData $X($I) $Y($I) 0.0 0 2 }
               set First 1
            }
         }
      }
   }

   PlotColor HOLD $lC $fC
   GPHwinScale $wN $OldX $OldY Zc 0
   set WinInfo($wN,Clip) $OldClip

   update
   if $ByeByeX { unset X }
}
