package provide TclPLT 1.0

proc PLTlabels3D {pN Plane Axis sAxis Level Just Pos LaB } {
   global PltInfo WinInfo GphInfo 

# GET the plot window number

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# SAVE some things which will be changed and need to be reset

   set OrigX1 $WinInfo($wN,p0) ; set OrigX2 $WinInfo($wN,p3)
   set OrigY1 $WinInfo($wN,p1) ; set OrigY2 $WinInfo($wN,p4)
   set OrigZ1 $WinInfo($wN,p2) ; set OrigZ2 $WinInfo($wN,p5)
   set OrigXs $WinInfo($wN,a0) ; set OrigYs $WinInfo($wN,a1)
   set OrigZs $WinInfo($wN,a2)

# SET up some information which is based on the base axis

   switch -exact -- $Axis {
      X {
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a1) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN.a0
      }
      Y {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN.a1
      }
      Z {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a1) 0
	 set Sca $wN.a2
      }
   }

# RESCALE all the axes.  Only the base axes being ticked are left

   GPHwinScale $wN Xc Yc Zc 0

# BASIC text size used for offsets

   if [string match MIN $sAxis] { set Ax ${Axis}b } else { set Ax ${Axis}t }

# Pointer to the label options

   set nI $PltInfo($wN,nI$Ax)

# SET up the label options

   TextProp [lindex $nI 7] Courier [lindex $nI 8]
   set Place [lindex $nI 9]
   set Color [lindex $nI 6]

# THE approximate character size in window coordinates

   set cS [GPHtextLen "5" XYZ]
   set cX [expr 0.65 * [lindex $cS 0]]
   set cY [expr 0.65 * [lindex $cS 1]]
   set cZ [expr 0.65 * [lindex $cS 2]]

   set fA ${Plane}$Ax
   set rV [PLTlabelsPos $pN $fA $Place $Just]

   set Jt [lindex $rV 0]
   set Vs [lindex $rV 1]
   set lSgN [lindex $rV 2]
   set sX [lindex $rV 3]
   set sY [lindex $rV 4]
   set sZ [lindex $rV 5]
   set sV [lindex $rV 6]
   set aL [list [lindex $rV 7] [lindex $rV 8] [lindex $rV 9]] 

# INITIALIZE the label out X, Y, and Z locations.  Some of these
#   are modified later

   set Vx [expr $Vs $lSgN ($Level + 0.6) * $cX]
   set Vy [expr $Vs $lSgN ($Level + 0.6) * $cY]
   set Vz [expr $Vs $lSgN ($Level + 0.6) * $cZ]

   set pCmd { TexT $wN $Vx $Vy $Vz $Jt $LaB $Color $aL } 

# SET up the print commands

   switch -exact -- $Plane {
      XYB -
      XYT {
         if [string match XYB $Plane] { set Vz 0.0 } else { set Vz 1.0 }
         if [string match X $Axis] { set Vx $Pos } else { set Vy $Pos } 
      }
      XZB -
      XZT {
         if [string match XZB $Plane] { set Vy 0.0 } else { set Vy 1.0 }
         if [string match X $Axis] { set Vx $Pos } else { set Vz $Pos } 
      }
      YZB -
      YZT {
         if [string match YZB $Plane] { set Vx 0.0 } else { set Vx 1.0 }
         if [string match Y $Axis] { set Vy $Pos } else { set Vz $Pos } 
      }
   }

# PRINT

   if [string match X $Axis] { 
       set cV $cX
   } elseif [string match Y $Axis] { set cV $cY } else { set cV $cZ}

   set nC [string length $LaB]

   set Vx [expr $Vx $sX * $cX]
   set Vy [expr $Vy $sY * $cY]
   set Vz [expr $Vz $sZ * $cZ]

   eval $pCmd


# RESTORE original settings

   set WinInfo($wN,p0) $OrigX1 ; set WinInfo($wN,p3) $OrigX2
   set WinInfo($wN,p1) $OrigY1 ; set WinInfo($wN,p4) $OrigY2
   set WinInfo($wN,p2) $OrigZ1 ; set WinInfo($wN,p5) $OrigZ2
   set WinInfo($wN,a0) $OrigXs ; set WinInfo($wN,a1) $OrigYs
   set WinInfo($wN,a2) $OrigZs

   GPHwinScale $wN Xc Yc Zc 0
}
