package provide TclPLT 1.0

proc PLTlabPos { pN Axis Pos { CoSyS CARTESIAN } { CoI 0 } { aPos 0.0 } } {

   global PltInfo  WinInfo

   set wN $PltInfo($pN,wN)

   switch -exact -- $Axis {
      Xb  {  set Min $WinInfo($wN,pp0) 
             set Max $WinInfo($wN,pp3) 
             set Sca $WinInfo($wN,pa0) 
	     set aX 1
          }
      Xt  {  if [info exists WinInfo($wN,sp0) ] {
                set Min $WinInfo($wN,sp0) 
             } else { set Min $WinInfo($wN,pp0) } 
             if [info exists WinInfo($wN,sp3) ] {
                set Max $WinInfo($wN,sp3) 
             } else { set Max $WinInfo($wN,pp3) }
             if [info exists WinInfo($wN,sa0) ] {
                set Sca $WinInfo($wN,sa0) 
             } else { set Sca $WinInfo($wN,pa0) }
	     set aX 1
          }
      Yl -
      Yb  {  set Min $WinInfo($wN,pp1) 
             set Max $WinInfo($wN,pp4) 
             set Sca $WinInfo($wN,pa1) 
	     set aX 0
          }
      Yr -
      Yt  {  if [info exists WinInfo($wN,sp1) ] {
                set Min $WinInfo($wN,sp1) 
             } else { set Min $WinInfo($wN,pp1) } 
             if [info exists WinInfo($wN,sp4) ] {
                set Max $WinInfo($wN,sp4) 
             } else { set Max $WinInfo($wN,pp4) }
             if [info exists WinInfo($wN,sa1) ] {
                set Sca $WinInfo($wN,sa1) 
             } else { set Sca $WinInfo($wN,pa1) }
	     set aX 0
          }
   }



   switch -exact -- $Pos {
      MINIMUM  {  set V $Min }
      MAXIMUM  {  set V $Max }
      CENTER   {  
         if {$Sca == 1 } {
            set V [expr log($Min * $Max) / 2.0]
            set V [expr exp($V)]
         } else { set V [expr ($Max + $Min) / 2.0] }
      }
      default  {  
         if [string match CARTESIAN $CoSyS] {
            set V $Pos 
	 } else {
	    set S(0) 0
	    if $aX {
	       set X(0) $Pos ; set Y(0) $aPos
	       GPHmapXY $CoSyS 1 X Y x y S 0 $CoI
	       set V $x(0)
            } else {
	       set X(0) $aPos ; set Y(0) $Pos
	       GPHmapXY $CoSyS 1 X Y x y S 0 $CoI
	       set V $y(0)
            }
	 }
      }
   }

   return $V
}
