# THIS returns a skip factor to use when output lablel.  For the X axis
#   this is set to the largest required skip value.

package provide TclPLT 1.0

proc PLTgetSkipMap { pN Axis lList FmT } {
   global GphInfo 

   set nP [expr [llength $lList] - 1]
   set SkiP 0
   if { $Axis == "X" } {
      set lenG [expr 1.5 * [GPHtextLen "0"]]
      for { set I 0 } { $I < $nP } { } {
         set xA [lindex [lindex $lList $I] 0]
         set lA [format $FmT [lindex [lindex $lList $I] 1]]
	 set lenA [GPHtextLen $lA]
         incr I
	 set OK 1
	 set tSkip 0
	 while { $OK && ($I <= $nP) } {
            set xB [lindex [lindex $lList $I] 0]
            set lB [format $FmT [lindex [lindex $lList $I] 1]]
	    set lenB [GPHtextLen $lA]
	    set xC [expr ($xA + $xB) / 2.0]
	    set xL [expr $xB - $xA - 0.5 * ($lenB + $lenA)]
	    if { $xL < $lenG } {
               incr tSkip
	       incr I
            } else { set OK 0 } 
	 }
	 if { $tSkip > $SkiP } { set SkiP $tSkip }
      }
   } else {
      set lenT [GPHtextLen "O" Y]
      set lenG [expr 1.5 * $lenT]
      for { set I 0 } { $I < $nP } { } {
         set yA [lindex [lindex $lList $I] 0]
         incr I
	 set OK 1
	 set tSkip 0
	 while { $OK && ($I <= $nP) } {
            set yB [lindex [lindex $lList $I] 0]
	    set yC [expr ($yA + $yB) / 2.0]
	    set yL [expr $yB - $yA - $lenT]
	    if { $yL < $lenG } {
               incr tSkip
	       incr I
            } else { set OK 0 } 
	 }
	 if { $tSkip > $SkiP } { set SkiP $tSkip }
      }
   } 
       
   incr SkiP

   return $SkiP
}
