package provide TclPLT 1.0

proc PLTgetSkip { pN Axis bMj eMj dMj Sgn FmT { Plane XYB } } {
   global GphInfo WinInfo PltInfo 

# NEED to adjust eMj so that we don't get caught with round off errors
#   when doing the <= compare. 

   set eMj [expr $eMj + 1.0e-5 * $dMj]

   set wN $PltInfo($pN,wN)
   switch -exact -- $Axis {
      X { set Sca $WinInfo($wN,a0) }
      Y { set Sca $WinInfo($wN,a1) }
      Z { set Sca $WinInfo($wN,a2) }
   } 

   if $Sca { set tL [expr log10($dMj)] } else { set tL $dMj }

   set V $bMj
   set MLen 0
   set Max -1

   if [string match expon $FmT] {
      while { $V <= $eMj } {
         set S [expr int(log10($V))]
         set TLen [GPHtextLen $S $Axis]
         if { $TLen > $MLen } { set MLen $TLen }
         set V [expr $V $Sgn $dMj]
         incr Max
      }
   } else {
      while { $V <= $eMj } {
         set S [format $FmT $V]
         set TLen [GPHtextLen $S $Axis]
         if { $TLen > $MLen } { set MLen $TLen }
         set V [expr $V $Sgn $dMj]
         incr Max
      }
   } 

   if { $WinInfo($wN,Dimen) == 3 } {
      switch -exact -- $Plane {
         XYB -
         XYT {
            if { $Axis == "X" }  {
               set MLen [lindex [GPHrealLen $GphInfo(tSize) 1 SCALED ] 0] 
	    } 
         }
         XZB -
         XZT -
         YZB -
         YZT {
            if { $Axis == "Z" }  {
               set MLen [lindex [GPHrealLen $GphInfo(tSize) 1 SCALED ] 2] 
	    }
	 }
      }
   } else { 
      if { $Axis == "Y" }  {
         set MLen [lindex [GPHrealLen $GphInfo(tSize) 1 SCALED ] 1] 
      } 
   }

   set Skip [expr int(ceil($MLen / $tL))] 

   return [list $Skip $Max]
}
