package provide TclPLT 1.0

# INPUTS
#  
#  pN     -  Plot Number
#  X1     -  Lower X edge
#  X2     -  Upper X edge
#  Y1     -  Lower Y edge
#  Y2     -  Upper Y edge
#  V      -  Array of intensity values
#  Beg     -  Starting point in arrays
#  End     -  Ending point in arrays
#  Ops List
#    Index 0 : Plot Format  (CROSS BOX FBOX)
#    Index 1 : Color
#  cV - color conversion array
#  ExC List
#    Index 0 : X Data Exclusion : NONE < > >= <= ==  
#    Index 1 : X Data Exclusoin Value
#    Index 2 : Y Data Exclusion : NONE < > >= <= ==  
#    Index 3 : Y Data Exclusoin Value
#    Index 4 : V Data Exclusion : NONE < > >= <= ==  
#    Index 5 : V Data Exclusoin Value
               
proc PLTerrorPlot { wN xA yA X1 X2 Y1 Y2 Vv Beg End Ops cV { ExC "" } } {
   global WinInfo PltInfo GphInfo 

#  SEE what data sets we have. 

   if { [string length $X1] > 0 } { 
      upvar $X1 T
      if [info exists T] { set hX1 1 } else { set hX1 0 }
   } else { set hX1 0 }
   if { [string length $X2] > 0 } { 
      upvar $X2 T
      if [info exists T] { set hX2 1 } else { set hX2 0 }
   } else { set hX2 0 }
   if { [string length $Y1] > 0 } { 
      upvar $Y1 T
      if [info exists T] { set hY1 1 } else { set hY1 0 }
   } else { set hY1 0 }
   if { [string length $Y2] > 0 } { 
      upvar $Y2 T
      if [info exists T] { set hY2 1 } else { set hY2 0 }
   } else { set hY2 0 }
   if { [string length $Vv] > 0 } { 
      upvar $Vv T
      if [info exists T] { set hVv 1 } else { set hVv 0 }
   } else { set hVv 0 }

   if { $hX1 && $hX2 } {
      upvar $X1 Xa
      upvar $X2 Xb
   } else { upvar $X1 Xa ; upvar $X1 Xb }

   if { $hY1 && $hY2 } {
      upvar $Y1 Ya
      upvar $Y2 Yb
   } else { upvar $Y1 Ya ; upvar $Y1 Yb }

   if { [string match Yl $yA] } { set yA Yb }
   if { [string match Yr $yA] } { set yA Yt }

# Save some values which might get changed and need to be reset

   set lC $GphInfo(lColor)
   set fC $GphInfo(fColor)
   set OldX $WinInfo($wN,X)
   set OldY $WinInfo($wN,Y)
   set OldClip $WinInfo($wN,Clip)

# GET the correct set of axis scaled

   if { [string match Xb $xA] } { set aX Xp } else { set aX Xs }
   if { [string match Yb $yA] } { set aY Yp } else { set aY Ys }
   GPHwinScale $wN $aX $aY Zc 0

# Set up the X and Y exclusion commands.

   set eL [llength $ExC]

   if { $eL > 0 } { set Cond [lindex $ExC 0] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdx { if { $Xc == [lindex $ExC 1] } { set OKx 0 } } }
      >    { set Cmdx { if { $Xc > [lindex $ExC 1] }  { set OKx 0 } } }
      <    { set Cmdx { if { $Xc < [lindex $ExC 1] }  { set OKx 0 } } }
      >=   { set Cmdx { if { $Xc >= [lindex $ExC 1] } { set OKx 0 } } }
      <=   { set Cmdx { if { $Xc <= [lindex $ExC 1] } { set OKx 0 } } }
      default { set Cmdx {set OKx 1 } }
   }

   if { $eL > 2 } { set Cond [lindex $ExC 2] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdy { if { $Yc == [lindex $ExC 3] } { set OKy 0 } } }
      >    { set Cmdy { if { $Yc > [lindex $ExC 3] }  { set OKy 0 } } }
      <    { set Cmdy { if { $Yc < [lindex $ExC 3] }  { set OKy 0 } } }
      >=   { set Cmdy { if { $Yc >= [lindex $ExC 3] } { set OKy 0 } } }
      <=   { set Cmdy { if { $Yc <= [lindex $ExC 3] } { set OKy 0 } } }
      default { set Cmdy {set OKy 1 } }
   }

   if { $eL > 4 } { set Cond [lindex $ExC 4] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdv { if { $Vc($I) == [lindex $ExC 5] } { set OKv 0 } } }
      >    { set Cmdv { if { $Vc($I) > [lindex $ExC 5] }  { set OKv 0 } } }
      <    { set Cmdv { if { $Vc($I) < [lindex $ExC 5] }  { set OKv 0 } } }
      >=   { set Cmdv { if { $Vc($I) >= [lindex $ExC 5] } { set OKv 0 } } }
      <=   { set Cmdv { if { $Vc($I) <= [lindex $ExC 5] } { set OKv 0 } } }
      default { set Cmdz {set OKz 1 } }
   }

# IF there is a V array then this is a 3D plot where color forms the 3rd
#   dimension.  That means that there must be a cV array.

   if !$hVv {
      set OKx 1 ; set OKy 1 ;
      PlotColor HOLD [lindex $Ops 1] OFF
      switch -exact -- [lindex $Ops 0] {
         CROSS {
            set WinInfo($wN,Clip) 2
            for { set I $Beg } { $I <= $End } { incr I } { 
	       set Xc [expr ($Xa($I) + $Xb($I))/2.0]
	       set Yc [expr ($Ya($I) + $Yb($I))/2.0]
               eval $Cmdx ; eval $Cmdy
               if {$OKx && $OKy} {
	          Line $wN $Xa($I) $Yc 0.0 $Xb($I) $Yc 0.0
	          Line $wN $Xc $Ya($I) 0.0 $Xc $Yb($I) 0.0
               } else { set OKx 1 ; set OKy 1 }
            } 
         }
         BOX {
            set WinInfo($wN,Clip) 2
            for { set I $Beg } { $I <= $End } { incr I } { 
	       set Xc [expr ($Xa($I) + $Xb($I))/2.0]
	       set Yc [expr ($Ya($I) + $Yb($I))/2.0]
               eval $Cmdx ; eval $Cmdy
               if {$OKx && $OKy} {
	          Box $wN $Xa($I) $Ya($I) 0.0 $Xb($I) $Yb($I) 0.0
               } else { set OKx 1 ; set OKy 1 }
            } 
         }
      }
   } else {
      upval $Vc Vc
      upval $cV cI
      set OKx 1 ; set OKy 1 ; sey OKv 1
      switch -exact -- [lindex $Ops 0] {
         CROSS {
            set WinInfo($wN,Clip) 2
            for { set I $Beg } { $I <= $End } { incr I } { 
	       set Xc [expr ($Xa($I) + $Xb($I))/2.0]
	       set Yc [expr ($Ya($I) + $Yb($I))/2.0]
               eval $Cmdx ; eval $Cmdy eval $Cmdv
               if {$OKx && $OKy && $OKv } {
                  PlotColor HOLD [PLTvalueColor $Vc($I) cI]
	          Line $wN $Xa($I) $Yc 0.0 $Xb($I) $Yc 0.0
	          Line $wN $Xc $Ya($I) 0.0 $Xc $Yb($I) 0.0
               } else { set OKx 1 ; set OKy 1 ; set OKv 1 }
            } 
         }
         BOX {
            set WinInfo($wN,Clip) 2
            for { set I $Beg } { $I <= $End } { incr I } { 
	       set Xc [expr ($Xa($I) + $Xb($I))/2.0]
	       set Yc [expr ($Ya($I) + $Yb($I))/2.0]
               eval $Cmdx ; eval $Cmdy eval $Cmdv
               if {$OKx && $OKy && $OKv } {
                  PlotColor HOLD [PLTvalueColor $Vc($I) cI]
	          Box $wN $Xa($I) $Ya($I) 0.0 $Xb($I) $Yb($I) 0.0
               } else { set OKx 1 ; set OKy 1 ; set OKv 1 }
            } 
         }
         FBOX {
            set WinInfo($wN,Clip) 2
            for { set I $Beg } { $I <= $End } { incr I } { 
	       set Xc [expr ($Xa($I) + $Xb($I))/2.0]
	       set Yc [expr ($Ya($I) + $Yb($I))/2.0]
               eval $Cmdx ; eval $Cmdy eval $Cmdv
               if {$OKx && $OKy && $OKv } {
                  set cC [PLTvalueColor $Vc($I) cI]
                  PlotColor HOLD $cC $cC
	          Box $wN $Xa($I) $Ya($I) 0.0 $Xb($I) $Yb($I) 0.0
               } else { set OKx 1 ; set OKy 1 ; set OKv 1 }
            } 
         }
      }
   } 

   PlotColor HOLD $lC $fC
   GPHwinScale $wN $OldX $OldY Zc 0
   set WinInfo($wN,Clip) $OldClip
}
