package provide TclPLT_C 1.0

# A contour cell looks like ...
#
#                  c1       s1     c2
#                      x ....... x
#                      . \     / .
#                  s0  .   \ /   . s2
#                      .   / \   .
#                      . /     \ .
#                      x ....... x
#                   c0      s3     c3
# 
#  where c's are corners, x's are values  and s's are sections
#
#  SIDES:  Each side in a cell has a status associated with it.  These
#     are in a single array.  The location in the array is determined
#     essentially by the cell corner positions. Status information of
#     a vertical side is in the upper 4 bits in the array location of
#     the grid corner directly below it. Status information of a horizontal
#     side is in the lower 4 bits in the array location of the grid corner 
#     directly to its left.
#   

proc PLTcontourCell { gN cX cY InFo Grid xX yY vV sS } {
   upvar $gN gP
   upvar $Grid G
   upvar $InFo cF
   upvar $cX Xc
   upvar $cY Yc
   upvar $xX X
   upvar $yY Y
   upvar $vV V
   upvar $sS S

# INITIALIZE the section status flag to OK

   for { set I 0 } { $I < 4 } { incr I } { set S($I) 1 }

#  Initialize Max/Min variables

   set cF(3) 1.0e30
   set cF(4) -1.0e30

# LOAD the cell information

   set V(4) 0.0
   set vCnT 0
   for { set I 0 } { $I < 4 } { incr I } { 
      set X($I) $Xc($gP($I))
      set Y($I) $Yc($gP($I))
      set V($I) $G($gP($I))
      if { $V($I) > $cF(2) } {
         set V(4) [expr $V(4) + $V($I)] 
         if { $cF(3) > $V($I) } { set cF(3) $V($I) }
         if { $cF(4) < $V($I) } { set cF(4) $V($I) }
         incr vCnT
      } else {
         set S($I) 0
         set S([expr ($I + 3) % 4]) 0
      }
   }

   if { $vCnT != 0 } { 
       set V(4) [expr $V(4) / double($vCnT)]
   } else { return -1 }

   set X(4) [expr $Xc($gP(0)) + $cF(0) / 2.0]
   set Y(4) [expr $Yc($gP(0)) + $cF(1) / 2.0]

   return 1
}
