# THIS procedure provides the color mapping information which is used
#   by routines to map value to color. 

package provide TclPLT 1.0

proc PLTcolorMap { Min Max Sca ExT CMaP } {
   global WinInfo GphInfo 

   upvar $CMaP cM

#  ESTABLIST the total number of color available

   if [string match NO $ExT] {
      set nC [expr $GphInfo(nColors) - 1]
   } else { set nC $GphInfo(nColors) }

#  THIS is the lowest color value which can be used

   set cM(2) 0

#  AND this is the highest 

   set cM(3) [expr $nC - 1]

#  NOW set up the coefficients which will take value to color.  This is
#     done through the liner equation
#
#        C = cMaP(0) * V + cMaP(1)              (linear scaling)
#
#     or
#
#        C = cMaP(0) * log10(V) + cMaP(1)       (log scaling)
#
#
#  cMaP(4) holds a numerical representation of the scaling

   switch -exact --  $Sca {
      LINEAR  {   
          set cM(4) 0
          set cM(0) [expr ($cM(3) - $cM(2))/double($Max - $Min)]
          set cM(1) [expr $cM(2) - $cM(0) * $Min]
      }
      LOG  {   
          set cM(4) 1
          set ToP [expr log10($Max)]
          set BoT [expr log10($Min)]
          set cM(0) [expr ($cM(3) - $cM(2))/double(($ToP - $BoT))]
          set cM(1) [expr $cM(2) - $cM(0) * $BoT]
      }
   }

# RETURN the number of colors being used

   return $nC
}
