package provide TclPLT 1.0

# INPUTS
#    pN      Plot number
#    Axis    :  Xb, Xt, Yb, or Yt  
#    Num     : produce numbers: YES NO
#    Text    : produce text labels: YES NO
#    Nlevel  : Number Level 
#    Tlevel  : Text Level 

proc PLTaxisTmYrMo { pN Axis Num Text NLevel TLevel } {
   global PltInfo WinInfo

#  GET the curent window number and the tick mark and number information
#    for the axis being worked on

   set wN $PltInfo($pN,wN)
   set Info  $PltInfo($pN,TmI)
   PLTinfoCur $pN $Axis nI tI

#  GET a size for the labeled minor ticks.  Set them to halfway between a
#     major and mormal minor tick
      
   set ltLen [expr ([lindex $tI 2] + [lindex $tI 3]) / 2.0]
   set otLen [lindex $tI 3]


#  This is the numerical annotation omit flag for this axis

   set OmiT [lindex $nI 5]

   set fT 0
   set lT 0
   if { [string match MIN $OmiT] || [string match BOTH $OmiT] } { set fT 1 }
   if { [string match MAX $OmiT] || [string match BOTH $OmiT] } { set lT 1 }

   set WnXMin $WinInfo($wN,pp0)
   set WnXMax $WinInfo($wN,pp3)

   if [string match YES $Num ] {
      set nA MANUAL
  }  else { set nA NONE }

   set FlY  [GPHtextLen 000000 X PIXELS]
   set FlM  [GPHtextLen 00000 X PIXELS]
   set FloM [GPHtextLen 000 X PIXELS]

   set BegYr [lindex $PltInfo($pN,bT) 0] 
   set EndYr [expr [lindex $PltInfo($pN,eT) 0] + 1]
   set Base 0

# DETERMINE the number of pixels between two year ticks.
 
   set T1 [list $BegYr 1 0 0 0 0 ]
   set Xa [TUtimeConv $PltInfo($pN,bT) $T1 0 Base]
   set T1 [list [expr $BegYr + 1] 1 0 0 0 0 ]
   set Xb [TUtimeConv $PltInfo($pN,bT) $T1 0 Base]

# DETERMINE the number of labels we can put up.
 
   set dX [expr $Xb - $Xa]
   set yrLen [lindex [GPHrealLen $dX $Xa PIXEL] 0]
   set MjTpY [expr int(($yrLen - $FlY) / $FlM)]  

# THIS list is the possible skips to use when putting up the month labels. 
 
   set Skips [list 100 5 3 2 2 1 1 1 1 1 1 0]

# Determine the skip to use.  This depends on the number of pixels between
#    the year tick marks as well at the month label sizes. 
 
   if { $MjTpY == 0 } {
      set Mo [list DUM J F M A M J J A S O N D]
      set MjTpY [expr int(($yrLen - $FlY) / $FloM)]  
   } else { set Mo [list DUM JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC] }

# PUT up the tick marks and labels on those tick marks which require them
 
   set S [expr [lindex $Skips $MjTpY] + 1]
   for { set I $BegYr } { $I <= $EndYr } { incr I } {
      for { set J 2 ; set K 1 } { $J <= 12 } { incr J ; incr K } { 
         set Dy [lindex [TUdateConv YDM $I 1 $J] 1]
         set T1 [list $I $Dy 0 0 0 0 ]
         set Px [expr [TUtimeConv $PltInfo($pN,bT) $T1 0 Base] + $WnXMin]
         if { ($Px >= $WnXMin) && ($Px <= $WnXMax) } { 
            set LaB [lindex $Mo $J]
            if { [expr $K % $S] == 0 } { 
	       if [string match MANUAL $nA] { 
                   set lFmt MANUAL 
               } else { set lFmt NONE }
	       PLTinfoChg $pN $Axis TICKS MNLENGTH $ltLen
            } else { set lFmt NONE }
            PLTaxisRec $pN $Axis ONEMINOR $lFmt $NLevel $Px center $LaB
	    PLTinfoChg $pN $Axis TICKS MNLENGTH $otLen
         }
      }
      set T1 [list $I 1 0 0 0 0 ]
      set Px [expr [TUtimeConv $PltInfo($pN,bT) $T1 0 Base] + $WnXMin]
      if { ($Px >= $WnXMin) && ($Px <= $WnXMax) } { 
         PLTaxisRec $pN $Axis ONEMAJOR $nA $NLevel $Px center $I
      }
   }
}
