package provide TclPLT 1.0

proc PLTaxisDraw { pN { 3D 0 } } {

   global PltInfo WinInfo GphInfo

   set wN $PltInfo($pN,wN)
   set Oldc $GphInfo(lColor)
   set Oldf $GphInfo(fColor)
   set OldcS $GphInfo(CoSyS)
   set OldcI $GphInfo(CsOps)

# EVERYTHING is done in cartesian coordinates in this routine
 
   SetCorSys CARTESIAN

   PlotColor HOLD [lindex $PltInfo($pN,aI) 1] OFF

   set X1 $WinInfo($wN,p0)
   set Y1 $WinInfo($wN,p1)
   set X2 $WinInfo($wN,p3)
   set Y2 $WinInfo($wN,p4)
   if $3D {
      set Z1 $WinInfo($wN,p2)
      set Z2 $WinInfo($wN,p5)
   }


   switch -exact -- [lindex $PltInfo($pN,aI) 0] {
      BOX  { 
         if $3D {
	     Box $wN $X1 $Y1 $Z1 $X2 $Y2 $Z1 
	     Box $wN $X1 $Y1 $Z1 $X2 $Y1 $Z2 
	     Box $wN $X1 $Y1 $Z1 $X1 $Y2 $Z2 
	 } else { Box $wN $X1 $Y1 0.0 $X2 $Y2 0.0 }
       }
      CROSSHAIR {
         set Xc [lindex $PltInfo($pN,aI) 2] 
         set Yc [lindex $PltInfo($pN,aI) 3] 
	 Line $wN $X1 $Yc 0.0 $X2 $Yc 0.0
	 Line $wN $Xc $Y1 0.0 $Xc $Y2 0.0
      }
      POLAR  { 
         set R [expr abs($X1)]
         Arc $wN 0.0 0.0 0.0 $R 0.0 360.0 1 0 1.0 
      }
      MAP  { 
         switch -exact -- $OldcS {
	    ORTHOGRAPHIC { Arc $wN 0.0 0.0 0.0 1.0 0.0 360.0 1 0 1.0 }
	    EQUIRECTANGULAR - 
	    CYLINDRICAL_EQUIDISTANT -
	    CYLINDRICAL_EQUAL_AREA -
	    LAMBERT_CYLINDRICAL -
	    BEHRMANN_CYLINDRICAL -
	    TRISTAN_EDWARDS -
	    PETERS -
	    GALL_ORTHOGRAPHIC -
	    BALTHASART -
	    MILLER37 -
	    MILLER43 -
	    MILLER50 -
	    MERCATOR { Box $wN $X1 $Y1 0.0 $X2 $Y2 0.0 }
         }
      }
   }
   PlotColor HOLD $Oldc Oldf
   SetCorSys $OldcS $OldcI
}
