package provide TclPLT 1.0

#INPUTS  
#   
#  Grid     The grid being filled
#  gInfo    The grid information array used to build array    
#  pInfo    Information used to set up plot
#     Element  0:  Label to use for X axis    
#     Element  1:  Label to use for Y axis    
#     Element  2:  Label to use for the ColorBar axis    
#     Element  3:  Scaling to apply to the X axis
#     Element  4:  Scaling to apply to the Y axis
#     Element  5:  Scaling to apply to the ColorBar axis
#     Element  6:  Minimum ColorBar scaling
#     Element  7:  Maximum ColorBar scaling


proc GridPlotPopUp { Grid gInfo pInfo} {
   global PltInfo WinInfo GphInfo

   upvar $Grid G
   upvar $gInfo gI
   upvar $pInfo pI

# Need to find an unused window and plot number.  To keep it simple we
# will keep the  plot and window numbers the same and begin searching
# at number 75.

   set pwN 75
   while { [info exists PltInfo($pwN,$pwN)] } { incr pwN }

# Now locate an unused window - again begin looking a 75 to try and
# say away from any windows the user may use.

   set scR 75
   set wIn .pLoT$scR
   while { [winfo exists $wIn] } { incr scR ; set wIn .pLoT$scR }

   set LastScr $GphInfo(CurScr)
   SetScreen ($scR);

   GenWindow $pwN 0.2 0.2 0.0 0.8 0.8 0.0 $gI(0) $gI(2) 0. $gI(1) $gI(3) 0. 

   set cW [ColorBar $pwN 1.07 0.0 0.0 1.15 1.0 0.0 $pI(6) $pI(7) $pI(5) \
                                           [list VERTICAL 0 0 0] cI ]
   DefinePlot $cW $cW
   set PltInfo($cW,tIyb) [list AUTO INSIDE INSIDE .15 .07 10 5 255 255]
   PlotOutlines $cW [list "" 1 "" 1 "" 1 $pI(2) 4] [list NONE TOP NONE BOTH]


   DefinePlot $pwN $pwN
   Plot3D $pwN Xb Yb Dummy Dummy G AUTO gI cI
   PlotOutlines $pwN [list "$pI(0)" 2.5 $pI(1) 5] 

   SetScreen ($LastScr);
}
