package provide TclPLT 1.0

# THIS procedure contours a grid
#
# INPUTS: pN       - the plot number in which the contours are to be output
#         Grid:    - the grid being contoured
#         gInfo:   - the grid information array
#         LevInfo: - the contour level information array
#             CFMT:  - MONOCHROMATIC COLOR
#             CLAB:  - LABELED/UNLABELED
#             CLEV:  - AUTO/MANUAL
#             NLEV:  - number of contour levels 
#             L1:    - level 1 contour if manual level enabled
#              .    
#              .    
#             L$NLEV - last contour level if manual level enabled
#             LMIN   - minimum level if auto-level enabled
#             LMAX   - maximum level if auto-level enabled
#             LSCA   - scaling (LINEAR/LOG)
#             CCOL   - color to output contours is MONOCHROMATIC
#             CMIN   - minimum value for color if COLOR
#             CMAX   - maximum value for color if COLOR
#             IGNB   - don't include values <= to this value in contours
#             LSIZE  - label size if contours are labeled
#             LCOL   - label color if contours are labeled (-1 means use the
#                         contour color
#             DFMT   - RECTANGULAR, POLAR

proc Contour { pN Grid gInfo LevInfo } {
   global PltInfo WinInfo GphInfo

   upvar $Grid    G
   upvar $gInfo   gI
   upvar $LevInfo cL

   set wN $PltInfo($pN,wN) 
   set GphInfo(curWin) $wN
   set SaveClip WinInfo($wN,Clip)

   WinClip $wN 1

   if ![info exists cL(CFMT)] { set cL(CFMT) MONOCHROMATIC } 
   if ![info exists cL(CLAB)] { set cL(CLAB) UNLABELED } 
   if ![info exists cL(CLEV)] { set cL(CLEV) AUTO } 
   if ![info exists cL(NLEV)] { set cL(NLEV) 1 } 
   if ![info exists cL(LMIN)] { set cL(LMIN) 0.0 } 
   if ![info exists cL(LMAX)] { set cL(LMAX) 1.0 } 
   if ![info exists cL(LSCA)] { set cL(LSCA) LINEAR } 
   if ![info exists cL(IGNB)] { set cL(IGNB) -1.0e31 } 
   if ![info exists cL(DFMT)] { set cL(DFMT) RECTANGULAR } 

   if [string match LINEAR $cL(LSCA)] { set sC 0 } else { set sC 1 }

   if [string match POLAR $cL(DFMT)] {
      set dType 1
   } else { set dType 0 }

# COMPUTE a center X,Y value for each cell in the data grid.  This is stored
#   in a pair of grids identical to the parent grid.  At the same time
#   initialize the contour cell status array
                                                                                
   set IncX [expr ($gI(1) - $gI(0)) / double($gI(4))]
   set IncY [expr ($gI(3) - $gI(2)) / double($gI(5))]
                                                                                
   set I 0
   if [string match ROW $gI(8)] {
      for { set R 0 } { $R < $gI(5) } { incr R } {
         set Yv [expr ($R + .5) * $IncY + $gI(2)]
         for { set C 0 } { $C < $gI(4) } { incr C } {
            set cX($I) [expr ($C + .5) * $IncX + $gI(0)]
            set cY($I) $Yv
            set cStat($I) 0
            incr I
         }
      }
   } else {
      set rM 1 ; set cM [expr int($gI(5))]
      set I 0
      for { set C 0 } { $C < $gI(4) } { incr C } {
         set Xv [expr ($C + .5) * $IncX + $gI(0)]
         for { set R 0 } { $R < $gI(5) } { incr R } {
            set cX($I) $Xv
            set cY($I) [expr ($R + .5) * $IncY + $gI(2)]
            set cStat($I) 0
            incr I
         }
      }
   }

   if [string match AUTO $cL(CLEV)] {
      if { $sC == 0 } {
         set InC [expr ($cL(LMAX) - $cL(LMIN))/($cL(NLEV) - 1.0)]
         for { set I 0 } { $I < $cL(NLEV)} { incr I } {
            set lV($I) [expr $cL(LMIN) + $I * $InC]
         }
      } else {
         set InC [expr log10($cL(LMAX) /$cL(LMIN))/($cL(NLEV) - 1.0)]
         set BasE log10($cL(LMIN))
         for { set I 0 } { $I < $cL(NLEV)} { incr I } {
            set T [expr $BasE + $I * $InC]
            set lV($I) [expr pow(10.0,$T)]
         }
      }
   } else {
      set J 0
      for { set I 1 } { $I <= $cL(NLEV)} { incr I } {
         set lV($J) $cL(L$I)
         incr J
      }
   }

   if [string match COLOR $cL(CFMT)] {
      PLTcolorMap $cL(CMIN) $cL(CMAX) $cL(LSCA) NO cI
   } else {
      set cI(0) 0.0
      set cI(1) $cL(CCOL)
      set cI(2) 0
      set cI(3) [expr $cL(CCOL) + 1]
      set cI(4) $sC
   }

   set MisC(0) $cL(IGNB)
   set MisC(1) $cM
   set MisC(2) $rM
   if [string match YES $gI(15)] {
      set MisC(3) $gI(4)
   } else { set MisC(3) [expr $gI(4) - 1] }
                                                                                
   if [string match YES $gI(16)] {
      set MisC(4) $gI(5)
   } else { set MisC(4) [expr $gI(5) - 1] }
                                                                                
   for { set I 0 } { $I < $cL(NLEV)} { incr I } {
      if { $cI(4) == 1 } {
         if {$lV($I) > 0.0 } {
            set C [expr int($cI(0) * log10($lV($I)) + $cI(1))]
         } else { set C -1 }
      } else { set C [expr int($cI(0) * $lV($I) + $cI(1))] }
      if { $C > $cI(3) } { set C $cI(3) }

# SET the color of the contour and draw it

      PlotColor HOLD $C $C
      PLTcontourLevel $wN G cX cY gI cStat $lV($I) $dType MisC
   }

   WinClip $wN $SaveClip
}
