package provide TclPLT 1.0

#INPUTS  
#   
#  pN       Plot Number 
#  Axis     
#  Data     The data array
#  nP       The number of points in the data array
#  Opts     Option List (OFF is default for any value)
#           Index 0:  Ignore any data below this value when autoscaling
#           Index 1:  Ignore any data above this value when autoscaling
#           Index 2:  Fix the minimum at this value if greater than it
#           Index 3:  Fix the maximum at this value if less than it
#           Index 4:  Shift the autoscaling so minimum is at this value
#           Index 5:  Shift the autoscaling so maximum is at this value
#           Index 6:  User supplied base interval
#           Index 7:  Fit Log axis as linear (min and max not set to 10 * X) 
#           Index 8:  Begin here in array

proc AutoScale { pN Axis Data nP { Opts "" } } {
   global PltInfo WinInfo GphInfo

   upvar $Data V

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

   set wN $PltInfo($pN,wN) 
   set GphInfo(curWin) $wN

#  Set Defaults 

   set Op(0) -1.0e33 
   set Op(1) 1.0e33 
   set Op(2) OFF
   set Op(3) OFF
   set Op(4) OFF
   set Op(5) OFF
   set Op(6) -1.0
   set Op(7) OFF
   set Op(8) 0

#  Process the Option list

   set OpLen [llength $Opts]
   for { set I 0 } { $I < $OpLen } { incr I } {
      if { $OpLen > $I } { 
        set Val [lindex $Opts $I]
        if ![string match OFF $Val] { set Op($I) $Val }
      }
   }

   PLTinfoCur $pN $Axis nI tI
   set MjT [lindex $tI 4 ]
   switch -exact -- $Axis {
      Xb  { set Sca $WinInfo($wN,pa0)    } 
      Xt  { set Sca $WinInfo($wN,sa0)    } 
      Yb  { set Sca $WinInfo($wN,pa1)    } 
      Yt  { set Sca $WinInfo($wN,sa1)    } 
      Zb  { set Sca $WinInfo($wN,pa2)    } 
      Zt  { set Sca $WinInfo($wN,sa2)    } 
   }

#
#   Find the maximum and minimum data value.  Need to check if the
#   axis against which the data is being plotted if 1D or if the
#   colorbar for 2D data is log scaled.  In this case the minimum
#   value must be >= 0.0.
#
 
   set ReT [TUdataMxMn V $nP <> $Op(0) $Op(1) 1 $Op(8) ]
   set Mn $V([lindex $ReT 0])
   set Mx $V([lindex $ReT 1])

   if ![string match OFF $Op(2) ] {
      if { $Mn > $Op(2) } { set Mn $Op(2) }
   }

   if ![string match OFF $Op(3) ] {
      if { $Mx < $Op(3) } { set Mx $Op(3) }
   }

   if { [string match ON $Op(7)] && $Sca == 1 } {
      set Mx [expr log10($Mx) ] 
      set Mn [expr log10($Mn) ] 
      set TSca 0
   } else { set TSca $Sca } 

   set ReT [PLTautoScale $Mn $Mx $TSca $MjT $Op(6)]
   set Min [lindex $ReT 0 ]
   set Max [lindex $ReT 1 ]
   if { [string match ON $Op(7)] && $Sca == 1 } {
      set Min [expr pow(10.0, $Min)]
      set Max [expr pow(10.0, $Max)]
   }

   if ![string match OFF $Op(4)] {
      set dV [expr $Op(4) - $Min]
      set Min [expr $Min + $dV]
      set Max [expr $Max + $dV]
   }

   if ![string match OFF $Op(5)] {
      set dV [expr $Op(5) - $Max]
      set Min [expr $Min + $dV]
      set Max [expr $Max + $dV]
   }

   switch -exact -- $Axis {
      Xb  {  set WinInfo($wN,pp0) $Min
             set WinInfo($wN,pp3) $Max
             GPHwinScale $wN Xb $WinInfo($wN,Y) $WinInfo($wN,Z) 0
          }
      Xt  {  set WinInfo($wN,sp0) $Min
             set WinInfo($wN,sp3) $Max
             GPHwinScale $wN Xt $WinInfo($wN,Y) $WinInfo($wN,Z) 0
          }
      Yb  {  set WinInfo($wN,pp1) $Min
             set WinInfo($wN,pp4) $Max
             GPHwinScale $wN $WinInfo($wN,X) Yb $WinInfo($wN,Z) 0
          }
      Yt  {  set WinInfo($wN,sp1) $Min
             set WinInfo($wN,sp4) $Max
             GPHwinScale $wN $WinInfo($wN,X) Yt $WinInfo($wN,Z) 0
          }
      Zb  {  set WinInfo($wN,pp2) $Min
             set WinInfo($wN,pp5) $Max
             GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) Zb 0
          }
      Zt  {  set WinInfo($wN,sp2) $Min
             set WinInfo($wN,sp5) $Max
             GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) Zt 0
          }
   }
}
