package provide TclPLT 1.0

# INPUTS  pN     - plot number
#         Labs
#         Nums   - Axis numerical label list
#                  Index 0:  DEFAULT - label Xb Yb only, tick mark all axes
#                            NONE    - no x-axis labels  
#                            BOTH    - labels on both X axes  
#                            BOT     - labels only on Xb axis  
#                            TOP     - labels only on Xt axis  
#                  Index 1:  NONE    - no y-axis labels  
#                            BOTH    - labels on both Y axes  
#                            BOT     - labels only on Yb axis  
#                            TOP     - labels only on Yt axis  
#                  Index 2:  NONE    - no x-axis major tick marks  
#                            BOTH    - tick marks on both X axes  
#                            BOT     - tick marks only on Xb axis  
#                            TOP     - tick marks only on Xt axis  
#                  Index 3:  NONE    - no y-axis major tick marks  
#                            BOTH    - tick marks on both Y axes  
#                            BOT     - tick marks only on Yb axis  
#                            TOP     - tick marks only on Yt axis  

proc PlotOutlines { pN  { Labs "" } { Nums "" } { nOff "" } { OutLine 1 } } {
   global PltInfo WinInfo GphInfo

# ESTABLIST the window number of the plot and turn off clipping in it
#    saving the current setting of course so it can be re-established.

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN
   set CurClip $WinInfo($wN,Clip)
   set WinInfo($wN,Clip) 0
   set CoSyS [lindex $PltInfo($pN,aI) 0] 

#  CHECK for RIGHT and LEFT definitions in the Nums list for Y and change
#    them to what the routine expects.

   set Len [llength $Nums]
   if { $Len >= 2 } {
      set V [lindex $Nums 1 ] 
      if [string match LEFT $V] { 
         set Nums [lreplace $Nums 1 1 BOT]
      } elseif [string match RIGHT $V] { set Nums [lreplace $Nums 1 1 TOP] }
   }
   if { $Len >= 4 } {
      set V [lindex $Nums 3 ] 
      if [string match LEFT $V] { 
         set Nums [lreplace $Nums 3 3 BOT]
      } elseif [string match RIGHT $V] { set Nums [lreplace $Nums 3 3 TOP] }
   }

#  SETUP a loopable axis indicator array

   set A(0) Xb ; set A(1) Yb
   set A(2) Xt ; set A(3) Yt

#  IF we need to add extra level offsets do it here

   set nOL [llength $nOff]
   set Lev(0) 0.5 ; set Lev(1) 0.5 ; set Lev(2) 0.5 ; set Lev(3) 0.5
   if { $nOL > 0 } { 
      for { set I 0 } { $I < 4 } { incr I } { set Off($I) [lindex $nOff $I] }
      if { [string length $Off(1)] == 0 } { set Off(1) $Off(0) }
      if { [string length $Off(2)] == 0 } { set Off(2) $Off(0) }
      if { [string length $Off(3)] == 0 } { set Off(3) $Off(1) }
      for { set I 0 } { $I < 4 } { incr I } { 
          set Lev($I) [expr $Lev($I) + $Off($I)]
      }
   }

#  DETERMINE which axes have numerical labels being output and what if any
#    tick marks are to be output

   set nAct(0) AUTO ; set nAct(1) AUTO 
   set nAct(2) NONE ; set nAct(3) NONE 
   set tAct(0) BOTH ; set tAct(1) BOTH 
   set tAct(2) BOTH ; set tAct(3) BOTH 

   for { set I 0 } { $I < $Len } { incr I } {
      set J [expr $I % 2]
      set K [expr $J + 2]
      switch -exact -- [lindex $Nums $I ] {
         NONE  {  
            if { $I < 2 } { 
               set nAct($J) NONE ; set nAct($K) NONE
            } else { set tAct($J) NONE ; set tAct($K) NONE }
         }
         BOTH  {  
            if { $I < 2 } {
               set nAct($J) AUTO ; set nAct($K) AUTO
            } else { set tAct($J) BOTH ; set tAct($K) BOTH }
         }
         BOT  {  
            if { $I < 2 } {
               set nAct($J) AUTO ; set nAct($K) NONE
            } else { set tAct($J) BOTH ; set tAct($K) NONE }
         }
         TOP  {  
            if {$I < 2 } {
               set nAct($J) NONE ; set nAct($K) AUTO 
            } else { set tAct($J) NONE ; set tAct($K) BOTH }
         }
      }
   }

#  DISABLE any axis which is a time based axis 

   set TmA(0) 0 ; set TmA(1) 0
   set TmA(2) 0 ; set TmA(3) 0
   switch -exact -- $PltInfo($pN,tAxis) {
      X   {  set TmA(0) 1 ; set TmA(2) 1;  }
      Xb  {  set TmA(0) 1                  }
      Xt  {  set TmA(2) 1                  }
      Y   {  set TmA(1) 1 ; set TmA(3) 1;  }
      Yb  {  set TmA(1) 1                  }
      Yt  {  set TmA(3) 1                  }
   }

   set J 0
   set K 1
   for { set I 0 } { $I < 4 } { incr I ; incr J 2 ; incr K 2 }  { 
      if { [string length [lindex $Labs $J] ] == 0 } {
         set Tm($I) NO 
      } else { set Tm($I) YES }
      set tT($I) [lindex $Labs $J]
      if { [string length [lindex $Labs $K] ] == 0 } {
         set tL($I) 0.0 
      } else { set tL($I) [lindex $Labs $K] }
   }

   switch -exact -- $CoSyS {
      BOX  {  
         for { set I 0 ; set J 0 ; set K 1 } { $I < 4 } { incr I }  { 
            if { $TmA($I) } {
               if {[string match NONE $nAct($I)] } {
                  set NuM NO
               } else { set NuM YES }
               PLTaxisTime $pN $A($I) $NuM $Tm($I) $Lev($I) $tL($I) 
            } else {
               PLTaxisRec $pN $A($I) $tAct($I) $nAct($I) $Lev($I)
               PLTaxisRec $pN $A($I) NONE AXIS [lindex $Labs $K] \
                                           CENTER center [lindex $Labs $J]
            }
            incr J 2
            incr K 2
         }
      }
      CROSSHAIR {
         PLTaxisCross $pN Xb $tAct(0) $nAct(0) $Lev(0)
         PLTaxisCross $pN Yb $tAct(1) $nAct(1) $Lev(1)
         PLTaxisCross $pN Xb NONE AXIS [lindex $Labs 1] \
                                           CENTER center [lindex $Labs 0]
         PLTaxisCross $pN Yb NONE AXIS [lindex $Labs 3] \
                                           CENTER center [lindex $Labs 2]
      }
      POLAR {  
         PLTaxisPolar $pN Xb $tAct(0) $nAct(0) $Lev(0)
         PLTaxisPolar $pN Yb $tAct(1) $nAct(1) $Lev(0)
         PLTaxisPolar $pN Xb NONE AXIS [lindex $Labs 1] \
                                           CENTER center [lindex $Labs 0]
         PLTaxisPolar $pN Yb NONE AXIS [lindex $Labs 3] \
                                           CENTER center [lindex $Labs 2]
      }
      MAP {  
         if ![string match NONE $tAct(0)] { set tAct(0) ALLMAJOR }
         if ![string match NONE $tAct(1)] { set tAct(1) ALLMAJOR }
         PLTaxisMap $pN Xb $tAct(0) $nAct(0) $Lev(0)
         PLTaxisMap $pN Yb $tAct(1) $nAct(1) $Lev(1)
         PLTaxisMap $pN Xb NONE AXIS $tL(0) CENTER center $tT(0)
         PLTaxisMap $pN Yb NONE AXIS $tL(1) CENTER center $tT(1)
         PLTaxisMap $pN Xt NONE AXIS $tL(2) CENTER center $tT(2)
         PLTaxisMap $pN Yt NONE AXIS $tL(3) CENTER center $tT(3)
      }
   }

#  OUTPUT the plot axes if requested

   if { $OutLine } { PLTaxisDraw $pN }

# RESET clipping

   set WinInfo($wN,Clip) $CurClip
}
