# OUTPUT ticl marks against the various axes
#
# AXIS designations.  An axis is designated first by what plane it is
#   in and second by whether it is perpendicular to the parallel
#   axis at its minimum (B) or maximum (T) position.  The parallel
#   axis all are set to run from 0 to 1 so minimum refers to the 0
#   position and maximum to the 1 position.

package provide TclPLT 1.0

proc PLTticks3D {pN Plane Axis sAxis } {
   global PltInfo WinInfo GphInfo 

   set AddMinors 1

# GET the plot window number

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# SAVE some things which will be changed and need to be reset

   set OrigX1 $WinInfo($wN,p0) ; set OrigX2 $WinInfo($wN,p3)
   set OrigY1 $WinInfo($wN,p1) ; set OrigY2 $WinInfo($wN,p4)
   set OrigZ1 $WinInfo($wN,p2) ; set OrigZ2 $WinInfo($wN,p5)
   set OrigXs $WinInfo($wN,a0) ; set OrigYs $WinInfo($wN,a1)
   set OrigZs $WinInfo($wN,a2)

# SET up some information which is based on the base axis

   switch -exact -- $Axis {
      X {
         set Hi $WinInfo($wN,p3) ; set Low $WinInfo($wN,p0)
	 if { $WinInfo($wN,a0) == 0 } { set SgN + } else { set SgN * } 
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a1) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN,a0
      }
      Y {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set Hi $WinInfo($wN,p4) ; set Low $WinInfo($wN,p1)
	 if { $WinInfo($wN,a1) == 0 } { set SgN + } else { set SgN * } 
         set WinInfo($wN,p5) 1.0 ; set WinInfo($wN,p2) 0.0
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a2) 0
	 set Sca $wN,a1
      }
      Z {
         set WinInfo($wN,p3) 1.0 ; set WinInfo($wN,p0) 0.0
         set WinInfo($wN,p4) 1.0 ; set WinInfo($wN,p1) 0.0
         set Hi $WinInfo($wN,p5) ; set Low $WinInfo($wN,p2)
	 if { $WinInfo($wN,a2) == 0 } { set SgN + } else { set SgN * } 
         set WinInfo($wN,a0) 0   ; set WinInfo($wN,a1) 0
	 set Sca $wN,a2
      }
   }

   if { $Low > $Hi } { TUdataSwap Low Hi }

# RESCALE all the axes.  Only the base axes being ticked are left

   GPHwinScale $wN Xc Yc Zc 0

   set nDef [llength $sAxis]
   for { set I 0 } { $I < $nDef } { incr I } {
      set tLoc [lindex $sAxis $I]
      if [string match MIN $tLoc] {
         set Ax ${Axis}b 
	 set Va 0.0 ; set Wa 0.0
	 set aF 1.0
      } else { 
         set Ax ${Axis}t 
	 set Va 1.0 ; set Wa 1.0
	 set aF -1.0
      }

      set tI $PltInfo($wN,tI$Ax) 

# GET the distance between the major and minor tick marks

   if [string match + $SgN] {
      set dMj [expr ($Hi - $Low)/ double([lindex $tI 4])]
   } else { set dMj 10.0 }

   set dMn [expr $dMj / double([lindex $tI 5])]

# SET the tick colors

    set MjC [lindex $tI 6]
    if { [string length $MjC] == 0 } { set MjC $GphInfo(White) }
    set MnC [lindex $tI 7]
    if { [string length $MnC] == 0 } { set MnC $GphInfo(White) }

# SET up the major tick mark ends

      set tLen [lindex $tI 2]
      switch -exact -- [lindex $tI 0] {
         SPAN     { set Va 0.0 ; set Vb 1.0 }
	 INSIDE   { set Vb [expr $Va + $aF * $tLen] } 
	 OUTSIDE  { set Vb [expr $Va - $aF * $tLen] } 
	 STRADDLE { 
	    set Vb [expr $Va + $tLen / 2.0]
	    set Va [expr $Va - $tLen / 2.0]
         }
      } 

# SAME for the minor tick marks

      set tLen [lindex $tI 3]
      switch -exact -- [lindex $tI 1] {
         SPAN     { set Wa 0.0 ; set Wb 1.0 }
	 INSIDE   { set Wb [expr $Wa + $aF * $tLen] } 
	 OUTSIDE  { set Wb [expr $Wa - $aF * $tLen] } 
	 STRADDLE { 
	    set Wb [expr $Wa + $tLen / 2.0]
	    set Wa [expr $Wa - $tLen / 2.0]
         }
      } 


      switch -exact -- $Plane {
         XYB -
         XYT {
            if [string match XYB $Plane] { set Vc 0.0 } else { set Vc 1.0 }
	    set Wc $Vc
            if [string match X $Axis] {
	       set lMj { Line $wN $V $Va $Vc $V $Vb $Vc } 
	       set lMn { Line $wN $W $Wa $Wc $W $Wb $Wc } 
	    } else {
	       set lMj { Line $wN $Va $V $Vc $Vb $V $Vc } 
	       set lMn { Line $wN $Wa $W $Wc $Wb $W $Wc } 
	    }
         }
         XZB -
         XZT {
            if [string match XZB $Plane] { set Vc 0.0 } else { set Vc 1.0 }
	    set Wc $Vc
            if [string match X $Axis] {
	       set lMj { Line $wN $V $Vc $Va $V $Vc $Vb } 
	       set lMn { Line $wN $W $Wc $Wa $W $Wc $Wb } 
	    } else {
	       set lMj { Line $wN $Va $Vc $V $Vb $Vc $V } 
	       set lMn { Line $wN $Wa $Wc $W $Wb $Wc $W } 
	    }
         }
         YZB -
         YZT {
            if [string match YZB $Plane] { set Vc 0.0 } else { set Vc 1.0 }
	    set Wc $Vc
            if [string match Y $Axis] {
	       set lMj { Line $wN $Vc $V $Va $Vc $V $Vb } 
	       set lMn { Line $wN $Wc $W $Wa $Wc $W $Wb } 
	    } else {
	       set lMj { Line $wN $Vc $Va $V $Vc $Vb $V } 
	       set lMn { Line $wN $Wc $Wa $W $Wc $Wb $W } 
	    }
         }
      }

      set GphInfo(lColor) $MjC
      set V $Low
      while { $V <= $Hi } {
         eval $lMj

         if $AddMinors {
            if { $WinInfo($Sca) == 1 } {
	       set dMn [ expr $V * $dMn ]
	       set W $dMn
            } else { set W [expr $V + $dMn] }
	    set GphInfo(lColor) $MnC
            set NextMj [expr $V $SgN $dMj]
            while { ($W < $NextMj) && ($W <= $Hi) } {
                eval $lMn
                set W [expr $W + $dMn]
            }
         }

         set V [expr $V $SgN $dMj]
      }

      PLTaxisLims $pN ${Plane}$Ax TICK $Va $Vb 
      PLTaxisLims $pN ${Plane}$Ax TICK $Wa $Wb 
      PLTaxisLims $pN ${Plane}$Ax NUMBER $Va $Vb 
      PLTaxisLims $pN ${Plane}$Ax NUMBER $Wa $Wb 
   }

# RESTORE original settings

   set WinInfo($wN,p0) $OrigX1 ; set WinInfo($wN,p3) $OrigX2
   set WinInfo($wN,p1) $OrigY1 ; set WinInfo($wN,p4) $OrigY2
   set WinInfo($wN,p2) $OrigZ1 ; set WinInfo($wN,p5) $OrigZ2
   set WinInfo($wN,a0) $OrigXs ; set WinInfo($wN,a1) $OrigYs
   set WinInfo($wN,a2) $OrigZs

   GPHwinScale $wN Xc Yc Zc 0
}
