package provide TclPLT 1.0

# INPUTS
#  
#  pN     -  Plot Number
#  Xs     -  Array of X values
#  Ys     -  Array of Y values
#  Zs     -  Array of Z values
#  Vs     -  Array of intensity values
#  Beg     -  Starting point in arrays
#  End     -  Ending point in arrays
#  Ops List
#    Index 0 : Plot Format  (2D, 3D, 2DC, 3DC)
#    Index 1 : Point Color
#    Index 2 : Scatter Font
#    Index 3 : Scatter Font Size
#    Index 4 : Scatter Value
#  cV - color conversion array
#  ExC List
#    Index 0 : X Data Exclusion : NONE < > >= <= ==  
#    Index 1 : X Data Exclusoin Value
#    Index 2 : Y Data Exclusion : NONE < > >= <= ==  
#    Index 3 : Y Data Exclusoin Value
#    Index 4 : Z Data Exclusion : NONE < > >= <= ==  
#    Index 5 : Z Data Exclusoin Value
#    Index 6 : V Data Exclusion : NONE < > >= <= ==  
#    Index 7 : V Data Exclusoin Value
                
proc PLTscatterPlot { wN xA yA Xs Ys Zs Vs Beg End Ops cV { ExC "" } } {
   global WinInfo PltInfo GphInfo 

#  There are 4 different format of scatter plot.  All need at least X
#    and Y so get those arrays set here

   upvar $Xs X
   upvar $Ys Y

   if { [string match Yl $yA] } { set yA Yb }
   if { [string match Yr $yA] } { set yA Yt }

# Save some values which might get changed and need to be reset

   set oF $GphInfo(tFont)
   set oS $GphInfo(tSize)
   set lC $GphInfo(lColor)
   set fC $GphInfo(fColor)
   set OldX $WinInfo($wN,X)
   set OldY $WinInfo($wN,Y)
   set OldClip $WinInfo($wN,Clip)

# GET the correct set of axis scaled

   if { [string match Xb $xA] } { set aX Xp } else { set aX Xs }
   if { [string match Yb $yA] } { set aY Yp } else { set aY Ys }
   GPHwinScale $wN $aX $aY Zc 0

# Set up the X and Y exclusion commands.

   set eL [llength $ExC]

   if { $eL > 0 } { set Cond [lindex $ExC 0] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdx { if { $X($I) == [lindex $ExC 1] } { set OKx 0 } } }
      >    { set Cmdx { if { $X($I) > [lindex $ExC 1] }  { set OKx 0 } } }
      <    { set Cmdx { if { $X($I) < [lindex $ExC 1] }  { set OKx 0 } } }
      >=   { set Cmdx { if { $X($I) >= [lindex $ExC 1] } { set OKx 0 } } }
      <=   { set Cmdx { if { $X($I) <= [lindex $ExC 1] } { set OKx 0 } } }
      default { set Cmdx {set OKx 1 } }
   }

   if { $eL > 2 } { set Cond [lindex $ExC 2] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdy { if { $Y($I) == [lindex $ExC 3] } { set OKy 0 } } }
      >    { set Cmdy { if { $Y($I) > [lindex $ExC 3] }  { set OKy 0 } } }
      <    { set Cmdy { if { $Y($I) < [lindex $ExC 3] }  { set OKy 0 } } }
      >=   { set Cmdy { if { $Y($I) >= [lindex $ExC 3] } { set OKy 0 } } }
      <=   { set Cmdy { if { $Y($I) <= [lindex $ExC 3] } { set OKy 0 } } }
      default { set Cmdy {set OKy 1 } }
   }

   if { $eL > 4 } { set Cond [lindex $ExC 4] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdz { if { $Z($I) == [lindex $ExC 5] } { set OKz 0 } } }
      >    { set Cmdz { if { $Z($I) > [lindex $ExC 5] }  { set OKz 0 } } }
      <    { set Cmdz { if { $Z($I) < [lindex $ExC 5] }  { set OKz 0 } } }
      >=   { set Cmdz { if { $Z($I) >= [lindex $ExC 5] } { set OKz 0 } } }
      <=   { set Cmdz { if { $Z($I) <= [lindex $ExC 5] } { set OKz 0 } } }
      default { set Cmdz {set OKz 1 } }
   }

   if { $eL > 6 } { set Cond [lindex $ExC 6] } else { set Cond NONE }
   switch -exact -- $Cond {
      ==   { set Cmdv { if { $V($I) == [lindex $ExC 7] } { set OKv 0 } } }
      >    { set Cmdv { if { $V($I) > [lindex $ExC 7] }  { set OKv 0 } } }
      <    { set Cmdv { if { $V($I) < [lindex $ExC 7] }  { set OKv 0 } } }
      >=   { set Cmdv { if { $V($I) >= [lindex $ExC 7] } { set OKv 0 } } }
      <=   { set Cmdv { if { $V($I) <= [lindex $ExC 7] } { set OKv 0 } } }
      default { set Cmdv {set OKv 1 } }
   }

# THE scatter elements can be output as either bitmaps or as characters.
#   Determine which is being used and set up the output commands for
#   each

   set oL [llength $Ops]
   if { $oL > 1 } { set cC [lindex $Ops 1] } else { set cC 255 }
   if { $oL > 2 } { set cF [lindex $Ops 2] } else { set cF HOLD }
   if { $oL > 3 } { set cS [lindex $Ops 3] } else { set cS 10 }
   if { $oL > 4 } { set cH [lindex $Ops 4] } else { set cH "+" }

   if { [string compare SyM $cF] == 0 } {
      set pCmd { Symbol $wN $X($I) $Y($I) $Zv center $cH $cC }
   } else {
      TextProp $cS $cF
      set pCmd { TexT $wN $X($I) $Y($I) $Zv center $cH $cC }
   }

# SWITCH between the different scatter plot formats.  These are
#    2D  - just X and Y
#    3D  - X, Y and Z
#    2DC - X and Y and V is color
#    3DC - X, Y and Z and V is color

  set OKx 1 ; set OKy 1 ;  set OKz 1 ; set OKv 1
   switch -exact -- [lindex $Ops 0] {
      2D {
         set WinInfo($wN,Clip) 2
         set Zv 0.0
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy
            if {$OKx && $OKy} {
               eval $pCmd
            } else { set OKx 1 ; set OKy 1 }
         } 
      }
      2DC {
         set WinInfo($wN,Clip) 2
         set Zv 0.0
         upvar $Vs V
         upvar $cV cI
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy ; eval $Cmdv
            if {$OKx && $OKy && $OKv} {
	       set cC [PLTvalueColor $V($I) cI]
               eval $pCmd
            } else { set OKx 1 ; set OKy 1 ; set OKv 1 }
         } 
      }
      3D {
         upvar $Zs Z
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy ; eval $Cmdz
            if {$OKx && $OKy && $OKz} {
	       set Zv $Z($I)
               eval $pCmd
            } else { set OKx 1 ; set OKy 1 ; set OKz 1 }
         } 
      }
      3DC {
         upvar $cV cI
         upvar $Zs Z
         upvar $Vs V
         for { set I $Beg } { $I <= $End } { incr I } { 
            eval $Cmdx ; eval $Cmdy ; eval $Cmdz ; eval $Cmdv
            if {$OKx && $OKy && $OKz && $OKv} {
	       set Zv $Z($I)
	       set cC [PLTvalueColor $V($I) cI]
               eval $pCmd
            } else { set OKx 1 ; set OKy 1 ; set OKz 1 ; set OKv 1 }
         } 
      }
   }

   TextProp $oS $oF
   PlotColor HOLD $lC $fC
   GPHwinScale $wN $OldX $OldY Zc 0
   set WinInfo($wN,Clip) $OldClip
}
