# THIS procedure returns the Offsets and justifications for either axis 
#  number or axis labels.  For 3D plots it also returns the text orientation
#
#  Pos will be either INSIDE or OUTSIDE

package provide TclPLT 1.0

proc PLTnumPos { pN Axis Pos } {
   global PltInfo WinInfo

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# 2 and 3D plots are handled differently

   if { $PltInfo($pN,Dimen) == 2 } {

# SET a pointer to the correct offset 

      switch -exact -- $Axis {
         Xb { if [string match $Pos INSIDE] { set P 5 } else { set P 1  } }
         Yb { if [string match $Pos INSIDE] { set P 6 } else { set P 2  } }
         Xt { if [string match $Pos INSIDE] { set P 7 } else { set P 3  } }
         Yt { if [string match $Pos INSIDE] { set P 8 } else { set P 4  } }
         Xc { if [string match $Pos INSIDE] { set P 9 } else { set P 10 } }
      }

# PICK apart the axis

      set Ax [string index $Axis 0]
      set Ap [string index $Axis 1]

# THIS is where to start the number or label. 

      set sP [lindex $PltInfo($pN,tO) $P ]

# DETERMINE the justification

      if [string match X $Ax] {
         set Jf center
      } else {
         if [string match INSIDE $Pos] { 
            if [string match t $Ap] { set Jf left } else { set Jf right }
         } else {
            if [string match t $Ap] { set Jf right } else { set Jf left }
         }
      }

# NO rotation for numbers in 2D plots 

      set RoT 0.0

# GET the sign to use when adding offsets to the base position

      set bL [expr ($P - 1) / 2]
      if { ($bL == 0) || ($bL == 3) || ($bL == 4) } { 
         set SgN - 
      } else { set SgN + }
     
      set rV [list $Jf $sP $SgN $RoT]

   } else {

# 3D annotation is always set to be level with axis plane being annotated.
#   Since each axis belongs to two places it can have two differet annotation
#   orientations.
#
#  The varaibles sX, sY, and sZ proscribe shifts in the starting position of
#     the text so that after rotations the text is in the correct location.

# SET a pointer to the correct offset 

      switch -exact -- $Axis {
         XYBXb { if [string match $Pos INSIDE] { set P 5  } else { set P 1  } }
         XYBYb { if [string match $Pos INSIDE] { set P 6  } else { set P 2  } }
         XYBXt { if [string match $Pos INSIDE] { set P 7  } else { set P 3  } }
         XYBYt { if [string match $Pos INSIDE] { set P 8  } else { set P 4  } }
         XYTXb { if [string match $Pos INSIDE] { set P 13 } else { set P 9  } }
         XYTYb { if [string match $Pos INSIDE] { set P 14 } else { set P 10 } }
         XYTXt { if [string match $Pos INSIDE] { set P 15 } else { set P 11 } }
         XYTYt { if [string match $Pos INSIDE] { set P 16 } else { set P 12 } }
         XZBXb { if [string match $Pos INSIDE] { set P 21 } else { set P 17 } }
         XZBZb { if [string match $Pos INSIDE] { set P 22 } else { set P 18 } }
         XZBXt { if [string match $Pos INSIDE] { set P 23 } else { set P 19 } }
         XZBZt { if [string match $Pos INSIDE] { set P 24 } else { set P 20 } }
         XZTXb { if [string match $Pos INSIDE] { set P 29 } else { set P 25 } }
         XZTZb { if [string match $Pos INSIDE] { set P 30 } else { set P 26 } }
         XZTXt { if [string match $Pos INSIDE] { set P 31 } else { set P 27 } }
         XZTZt { if [string match $Pos INSIDE] { set P 32 } else { set P 28 } }
         YZBYb { if [string match $Pos INSIDE] { set P 37 } else { set P 33 } }
         YZBZb { if [string match $Pos INSIDE] { set P 38 } else { set P 34 } }
         YZBYt { if [string match $Pos INSIDE] { set P 39 } else { set P 35 } }
         YZBZt { if [string match $Pos INSIDE] { set P 40 } else { set P 36 } }
         YZTYb { if [string match $Pos INSIDE] { set P 45 } else { set P 41 } }
         YZTZb { if [string match $Pos INSIDE] { set P 46 } else { set P 42 } }
         YZTYt { if [string match $Pos INSIDE] { set P 47 } else { set P 43 } }
         YZTZt { if [string match $Pos INSIDE] { set P 48 } else { set P 44 } }
      }

# PICK apart the axis

      set Plane [string range $Axis 0 2]
      set Ax [string index $Axis 3]
      set Ap [string index $Axis 4]

# THIS is where to start the label

      set sP [lindex $PltInfo($pN,tO) $P ]

# SET up some factors used to determine the direction to move the start 
#    position when adding levels

      set bL [expr ($P - 1) / 8]
      set tP [expr $P - 1 - $bL * 8]
      set sL [ expr $tP / 2 ]
      if { ($sL == 0) || ($sL == 3) } { set SgN - } else { set SgN + }

# DETERMINE the justification and rotaton for the numerical annotation.

      set sX "+ 0.0" ; set sY "+ 0.0" ; set sZ "+ 0.0" ; set sV "+ 0.0"
      switch -exact -- $Plane {
         XYB -
         XYT {
            set Rx 0.0 ; set Ry 0.0 ; set Rz 0.0
            if [string match X $Ax] {
               if [string match INSIDE $Pos] { 
                  if [string match t $Ap] { set Jf left } else { set Jf right }
               } else {
                  if [string match t $Ap] { set Jf right } else { set Jf left }
               }
            } else { set Jf center }
         }
	 XZB {
            set Rx 0.0 ; set Ry 90.0 ; set Rz 0.0
            if [string match X $Ax] {
               set Jf right
	       set Ry 270.0
               set sV { - 0.5 * $nC } 
            } else {
               set sV { - 0.5 } 
               if [string match INSIDE $Pos] { 
                  set Ry 270.0
	          set Jf right 
                  if [string match t $Ap] { 
	             set sX { - $nC } 
	          } else  { set sX { - 1 } } 
               } else {
	          set Ry 270.0
	          set Jf right 
                  if [string match b $Ap] { set sX { - $nC } } 
               }
            }
         }
	 XZT {
            set Rx 0.0 ; set Ry 90.0 ; set Rz 0.0
            if [string match X $Ax] {
               set Jf right
               set sV { + 0.5 * $nC } 
               set sZ { - 0.5 } 
            } else {
               set sV { - 0.5 } 
               if [string match INSIDE $Pos] { 
	          set Jf left 
                  if [string match b $Ap] { set sX { + ($nC - 1) } }
               } else {
	          set Jf right 
                  if [string match t $Ap] { set sX { + ($nC - 1.0) } } 
               }
            }
         }
         YZB -
         YZT {
            set Rx 0.0 ; set Ry 0.0 ; set Rz 0.0
            if [string match Y $Ax] {
               set sZ { - 0.5 } 
               set Jf center
            } else {
               set sV { - 0.5 } 
               if [string match INSIDE $Pos] { 
                  if [string match t $Ap] { 
                     set Jf left 
	          } else { set Jf right }
               } else {
                  if [string match t $Ap] { 
	             set Jf right 
	          } else { set Jf left }
               }
            }
         }
      }

      set rV [list $Jf $sP $SgN $sX $sY $sZ $sV $Rx $Ry $Rz]
   }

# TEXT / NUMBER rotation

   return $rV
}
