package provide TclPLT 1.0

# INPUTS
#    pN      Plot number
#    Axis    :  Xb, Xt, Yb, or Yt  
#    Num     : produce numbers: YES NO
#    Text    : produce text labels: YES NO
#    Nlevel  : Number Level 
#    Tlevel  : Text Level 

proc PLTaxisTime { pN Axis Num Text NLevel TLevel } {

   global PltInfo WinInfo

# Update axis variable in case its using old setting
 
   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

#  GET the curent window number and the tick mark and number information
#    for the axis being worked on

   set wN $PltInfo($pN,wN)
   set Info  $PltInfo($pN,TmI)
   PLTinfoCur $pN $Axis nI tI

# Time axis labels using Year and Month are handled by a separate routine.
#    If required call it now and then leave.
 
   if { [lindex $Info 0] == 0 } { 
      PLTaxisTmYrMo $pN $Axis $Num $Text $NLevel $TLevel
      return
   }

#  This is the numerical annotation omit flag for this axis

   set OmiT [lindex $nI 5]
   PLTinfoChg $pN $Axis NUMBERS NENDS NONE

   set fT 0
   set lT 0
   if { [string match MIN $OmiT] || [string match BOTH $OmiT] } { set fT 1 }
   if { [string match MAX $OmiT] || [string match BOTH $OmiT] } { set lT 1 }


# PUTTING up time ticks along an axis is done with the axis scaled 
#    according to the pixels across it.  Set the scaling to that here
#    in case its been scaled otherwise.

   set pBx $WinInfo($wN,pp0) ; set sBx $WinInfo($wN,sp0)
   set pBy $WinInfo($wN,pp1) ; set sBy $WinInfo($wN,sp1)
   set pTx $WinInfo($wN,pp3) ; set sTx $WinInfo($wN,sp3)
   set pTy $WinInfo($wN,pp4) ; set sTy $WinInfo($wN,sp4)
   set pSx $WinInfo($wN,pa0) ; set sSx $WinInfo($wN,sa0)
   set pSy $WinInfo($wN,pa1) ; set sSy $WinInfo($wN,sa1)

   set dX [expr [lindex $WinInfo($wN,b) 2] - [lindex $WinInfo($wN,b) 0]]
   set dY [expr [lindex $WinInfo($wN,b) 3] - [lindex $WinInfo($wN,b) 1]]

   SetAxis $wN SECONDARY 0.0 0.0 HOLD $dX $dY HOLD 0 0 HOLD 1
   SetAxis $wN PRIMARY 0.0 0.0 HOLD $dX $dY HOLD 0 0 HOLD 1

   if [string match YES $Num ] {
      set nA MANUAL
  }  else { set nA NONE }

   set tPos  [lindex $Info 0]
   set Base  [lindex $Info 1]
   set bTm   [lindex $Info 2]
   set eTm   [lindex $Info 3]
   set sTm   [lindex $Info 4]
   set nPix  [lindex $Info 5]
   set TpP   [lindex $Info 6]
   set TpL   [lindex $Info 7]
   set Mjs   [lindex $Info 8]
   set tNext [expr $tPos + 1]

   set nTm 1
   switch -exact -- $tPos {
      1  {  set TLen [GPHtextLen 00000]
            set MjT [expr int($nPix / $TLen)] 
            set L1 [list 24 12 8 6 6 4 4 3 3 3 3 2]
            set L2 [list  4  4 2 2 2 2 2 1 1 1 1 1]
	    set lLen [expr [llength $L1] - 1] 
            if { $Mjs >= $MjT } {
               set FmT %03d
               set TimeLab Day
            } else {
               set TLen [GPHtextLen 000:00000]
               set FmT %03d:%02d
               set TimeLab Day:Hour
               set MjT [expr int($nPix / $TLen)] 
               set nTm 2
            }
            if {$Base == 0 } {
               set DelTa 1.0
            } elseif {$Base == 1 } {
               set DelTa 86400.0
            } else { set DelTa 8.64e13 }
 
            set MnT [expr int(($DelTa / $TpP - $TLen) / $TLen)] 
            if { $MnT > $lLen } { set MnT $lLen }
            set MnB [lindex $L1 $MnT ]
            set MnL  [lindex $L2 $MnT ]
         }
      2  {  set TLen [GPHtextLen 0000]
            set MjT [expr int($nPix / $TLen)] 
            set L1 [list 60 30 20 15 12 10  5]
            set L2 [list  5 10  5  3  2  2  1]
	    set lLen [expr [llength $L1] - 1] 
            if { $Mjs >= $MjT } {
               set FmT %02d
               set TimeLab Hr
            } else {
               set TLen [GPHtextLen 00:00000]
               set MjT [expr int($nPix / $TLen)] 
               set FmT %02d:%02d
               set TimeLab Hr:Min
               set nTm 2
            }
            if {$Base == 0 } {
               set DelTa [expr 1.0/24.0]
            } elseif {$Base == 1 } {
               set DelTa 3600.0
            } else { set DelTa 3.6e12 }
 
            set MnT [expr int(($DelTa / $TpP - $TLen) / $TLen)] 
            if { $MnT > $lLen } { set MnT $lLen }
            set MnB [lindex $L1 $MnT ]
            set MnL  [lindex $L2 $MnT ]
         }
      3  {  set TLen [GPHtextLen 0000]
            set MjT [expr int($nPix / $TLen)] 
            set L1 [list 60 30 20 15 12 10  5]
            set L2 [list  5 10  5  3  2  2  1]
	    set lLen [expr [llength $L1] - 1] 
            if { $Mjs >= $MjT } {
               set FmT %02d
               set TimeLab Min
            } else {
               set TLen [GPHtextLen 00:00000]
               set MjT [expr int($nPix / $TLen)] 
               set FmT %02d:%02d
               set TimeLab Min:Sec
               set nTm 2
            }
            if {$Base == 0 } {
               set DelTa [expr 1.0/1440.0]
            } elseif {$Base == 1 } {
               set DelTa 60.0
            } else { set DelTa 6.0e10 }
 
            set MnT [expr int(($DelTa / $TpP - $TLen) / $TLen)] 
            if { $MnT > $lLen } { set MnT $lLen }
            set MnB [lindex $L1 $MnT ]
            set MnL  [lindex $L2 $MnT ]
         }
      4  {  set TLen [GPHtextLen 0000]
            set MjT [expr int($nPix / $TLen)] 
            set L1 [list 1000 500 500 250 200]
            set L2 [list  100 100 100  50  25]
	    set lLen [expr [llength $L1] - 1] 
            if { $Mjs >= $MjT } {
               set FmT %02d
            } else {
               set TLen [GPHtextLen 00.00000]
               set MjT [expr int($nPix / $TLen)] 
               set FmT %02d.%03d
               set nTm 2
            }
            if {$Base == 0 } {
               set DelTa [expr 1.0/86400.0]
            } elseif {$Base == 1 } {
               set DelTa 1.0
            } else { set DelTa 1.0e9 }
 
            set TimeLab Sec
            set MnT [expr int(($DelTa / $TpP - $TLen) / $TLen)] 
            if { $MnT > $lLen } { set MnT $lLen }
            set MnB [lindex $L1 $MnT ]
            set MnL  [lindex $L2 $MnT ]
         }
      5  {  set TLen [GPHtextLen 000.00000]
            set FmT %03d.%03d
            set TimeLab uSec
            set MjT [expr int($nPix / $TLen)] 
            set MnT [expr int((1.0 / $TpP - $TLen) / $TLen)] 
            set nTm 2
         }
      6  {  set TLen [GPHtextLen 000.00000]
            set FmT %03d.%03d
            set TimeLab nSec
            set MjT [expr int($nPix / $TLen)] 
            set MnT [expr int((1.0 / $TpP - $TLen) / $TLen)] 
            set nTm 2
         }
      7  {  set TLen [GPHtextLen 00000]
            set FmT %03d
            set TimeLab nSec
            set MjT [expr int((1.0 / $TpP - $TLen) / $TLen)] 
            set MnT 0
         }
   }

   if { $nTm == 1 } {
      set T1 [TUtimeConv $PltInfo($pN,bT) 0.0 3 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]
      set dTm [expr int($Mjs / $MjT) ] 
      if { [expr $Mjs % $MjT ] } { incr dTm }  

      set OK 0

# QUICK check to find the location of the first and last major tick marks 
#   in the plot.

      set fMj -1
      set lMj 0
      set tTm $sTm ; set Ta $T1 ; set Tb $T2

      for { set I 0 } { $I < $Mjs } { incr I } {
         set Pos [expr $tTm / $TpP ]
         set MjTicK [lindex $Tb $tPos]
         if { [expr $I % $dTm ] == 0 } {
	    set lMj $I
	    if { $fMj < 0 } { set fMj $I }
         } 

         set Tb [lreplace $Tb $tPos $tPos [expr $MjTicK + 1]]
         set tTm [TUtimeConv $Ta $Tb 0 Base]
         set Tb [TUtimeConv $Ta $tTm 3 Base]
      }

# NOW do the tick and label output

      for { set I 0 } { $I < $Mjs } { incr I } {

         if { (($I == $fMj) && $fT) || (($I == $lMj) && $lT) } {
	    set lStat NONE
         } else { set lStat $nA }

         set Pos [expr $sTm / $TpP ]
         set MjTicK [lindex $T2 $tPos]
         if { [expr $I % $dTm ] == 0 } {
	    set Lab [format "$FmT" $MjTicK]
            PLTaxisRec $pN $Axis ONEMAJOR $lStat $NLevel $Pos center $Lab
         } else { PLTaxisRec $pN $Axis ONEMINOR NONE $NLevel $Pos }

         set T2 [lreplace $T2 $tPos $tPos [expr $MjTicK + 1]]
         set sTm [TUtimeConv $T1 $T2 0 Base]
         set T2 [TUtimeConv $T1 $sTm 3 Base]
      }
   } else {
      set T1 [TUtimeConv $PltInfo($pN,bT) 0.0 3 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]

# COUNT the number of labels.  Like to see at least 5 labeled ticks if
#   we can squeeze them in.  Also need minimum and maximum label along
#   the axis in case we need to drop one or both.

      set nLab 0
      set T3 $T2
      set Pos [expr $sTm / $TpP ]
      set MjVal [lindex $T2 $tPos]
      set MnVal [lindex $T2 $tNext]
      incr nLab
      set T2 [lreplace $T2 $tNext $tNext [expr $MnVal + $MnL]]
      set sTm [TUtimeConv $T1 $T2 0 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]
      while { $sTm <= $eTm } {
          set Pos [expr $sTm / $TpP ]
          set cMjVal [lindex $T2 $tPos]
          set MnVal [lindex $T2 $tNext]
          if { $cMjVal != $MjVal } {
             set MjVal $cMjVal 
	     incr nLab
          } else {
             if { [expr $MnVal % $MnB] == 0 } { incr nLab }
          }
          set T2 [lreplace $T2 $tNext $tNext [expr $MnVal + $MnL]]
          set sTm [TUtimeConv $T1 $T2 0 Base]
          set T2 [TUtimeConv $T1 $sTm 3 Base]
      }

      set MnVal [lindex $T3 $tNext]
      set T2 [lreplace $T3 $tNext $tNext [expr $MnVal - $MnL]]
      set sTm [TUtimeConv $T1 $T2 0 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]
      while { $sTm >= $bTm } {
          set Pos [expr $sTm / $TpP ]
          set MjVal [lindex $T2 $tPos]
          set MnVal [lindex $T2 $tNext]
          if { [expr $MnVal % $MnB] == 0 } { incr nLab }
          set T2 [lreplace $T2 $tNext $tNext [expr $MnVal - $MnL]]
          set sTm [TUtimeConv $T1 $T2 0 Base]
          set T2 [TUtimeConv $T1 $sTm 3 Base]
      }

      if { $nLab < 5 } {
         if { $MjT > 5 } { set nT 5 } else { set nT $MjT } 
         if { ( $nT > 1 ) && ( $nT > $nLab ) } { 
            set MnB [expr  $nLab * $MnB / $nT] 
	    set MnB [expr int( $MnB / $MnL) * $MnL]
            if { $MnB == 0 } { set MnB 1 }
         }
      }

# THE first major tick mark is at the first significant time boundary.
#   E.g., Hr if Hr:Mn, Mn if Mn:Sec, etc.


      set sTm   [lindex $Info 4]
      set T1 [TUtimeConv $PltInfo($pN,bT) 0.0 3 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]

# DETERMINE the label for this tick mark and where to output.

      set T3 $T2
      set T4 $T2
      set Pos [expr $sTm / $TpP ]
      set MjVal [lindex $T2 $tPos]
      set MnVal [lindex $T2 $tNext]
      set Lab [format "$FmT" $MjVal $MnVal ]

# SET the location of the next labeled tick mark

      set cTm $sTm

      set T2 [lreplace $T2 $tNext $tNext [expr $MnVal + $MnL]]
      set T4 [lreplace $T4 $tNext $tNext [expr $MnVal + $MnB]]
      set sTm [TUtimeConv $T1 $T2 0 Base]
      set sTm4 [TUtimeConv $T1 $T4 0 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]
      set T4 [TUtimeConv $T1 $sTm4 3 Base]
      set NMj [lindex $T4 $tPos] 
      set NMn [lindex $T4 $tNext]

      set pMj [expr 2 * $cTm - $sTm4]
      set dMj [expr $sTm4 - $cTm]

      if { (($pMj < $bTm) && $fT) || (($sTm4 > $eTm) && $lT) } {
         set lStat NONE
      } else { set lStat $nA }

# OUTPUT this labeled tick mark

      PLTaxisRec $pN $Axis ONEMAJOR $lStat $NLevel $Pos center $Lab

      while { $sTm <= $eTm } {
         set Pos [expr $sTm / $TpP ]
         set cMjVal [lindex $T2 $tPos]
         set MnVal [lindex $T2 $tNext]
	 if { $tNext == 5 } {
            set uS [lindex $T2 6]
	    if { $uS > 900 } { 
	       incr MnVal 
               set T2 [lreplace $T2 6 6 0]
            }
	 }
         if { ($cMjVal == $NMj) && ($MnVal == $NMn) } {
            set MjVal $cMjVal 
            set Lab [format "$FmT" $MjVal $MnVal ]

            set T4 [lreplace $T4 $tNext $tNext [expr $MnVal + $MnB]]
            set sTm4 [TUtimeConv $T1 $T4 0 Base]
            set T4 [TUtimeConv $T1 $sTm4 3 Base]
            set NMj [lindex $T4 $tPos] 
            set NMn [lindex $T4 $tNext]

            if { ($sTm4 > $eTm) && $lT } {
	       set lStat NONE
            } else { set lStat $nA }
            PLTaxisRec $pN $Axis ONEMAJOR $lStat $NLevel $Pos center $Lab

         } else { PLTaxisRec $pN $Axis ONEMINOR NONE $NLevel $Pos }
         set T2 [lreplace $T2 $tNext $tNext [expr $MnVal + $MnL]]
         set sTm [TUtimeConv $T1 $T2 0 Base]
         set T2 [TUtimeConv $T1 $sTm 3 Base]
      }

      set MnVal [lindex $T3 $tNext]
      set T2 [lreplace $T3 $tNext $tNext [expr $MnVal - $MnL]]
      set sTm [TUtimeConv $T1 $T2 0 Base]
      set T2 [TUtimeConv $T1 $sTm 3 Base]
      set dT $MnL
      while { $sTm >= $bTm } {
          set Pos [expr $sTm / $TpP ]
          set MjVal [lindex $T2 $tPos]
          set MnVal [lindex $T2 $tNext]
          if { [expr $dT % $MnB] == 0 } {
              set Lab [format "$FmT" $MjVal $MnVal ]
	      set pMj [expr $sTm - $dMj]
              if { ($pMj < $bTm) && $fT } {
                 set lStat NONE
              } else { set lStat $nA }

              PLTaxisRec $pN $Axis ONEMAJOR $lStat $NLevel $Pos center $Lab
          } else {
              PLTaxisRec $pN $Axis ONEMINOR NONE $NLevel $Pos
          }
	  incr dT $MnL
          set T2 [lreplace $T2 $tNext $tNext [expr $MnVal - $MnL]]
          set sTm [TUtimeConv $T1 $T2 0 Base]
          set T2 [TUtimeConv $T1 $sTm 3 Base]
      }
   }

# OUTPUT the axis label

   if [string match YES $Text] {
      PLTaxisRec $pN $Axis NONE AXIS $TLevel CENTER center "Time ($TimeLab)"
   }

# PUT THINGS BACK

   SetAxis $wN SECONDARY $sBx $sBy HOLD $sTx $sTy HOLD $sSx $sSy HOLD 1
   SetAxis $wN PRIMARY $pBx $pBy HOLD $pTx $pTy HOLD $pSx $pSy HOLD 1
   PLTinfoChg $pN $Axis NUMBERS NENDS $OmiT
}
