package provide TclPLT 1.0

# SYNOPSIS : Depending on the set actions, this routine will produce
#            one or more labeled or unlabled tick marks against Axis
#            or will produce axis text labels.
#
# INPUTS
#  Axis    :  Xb, Xt, Yb, or Yt
#  TMode :  ALLMAJOR, ALLMINOR, ONEMAJOR, ONEMINOR, BOTH, NONE
#  LMode :  MANUAL, AUTO, AXIS, NONE
#  Level   :  Level of annotation
#  Pos     :  Location to place LABEL
#  TJust   :  Text justification when LMode is AXIS
#  Label   :  Label when LMode is AXIS


proc PLTaxisRec {pN Axis TMode LMode Level \
                             { Pos 0.0 } { TJust center} { Label "" } } {

   global PltInfo WinInfo GphInfo tcl_version

# CORRECT for old stule LMODE AUTO 
 
   if [string match AUTO $LMode] { set LMode AUTOMJ }
 
# LETS get all of the idiot checks done first

   set LabLen [string length $Label]
   if { [string match NONE $LMode] && [string match NONE $TMode] } { return }
   if { [string match AXIS $LMode] && ($LabLen == 0) } { return }

# RESET Y axis designation if called with Yr of Yl 

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# SET up the screen designation
 
   set sC Scr$GphInfo(CurScr)

#  GET the curent window number and the current Axis labeling and tick mark
#     information

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN
   PLTinfoCur $pN $Axis nI tI

#  SAVE the current color and text settings so they can be put back later
  
   set OldlC $GphInfo(lColor)
   set OldtC $GphInfo(tColor)
   set OldtS $GphInfo(tSize)
   set OldtB $GphInfo(tBold)

# CHECK to see what we are outputting

   set AxisPrint 0
   set DoMjPrint 0 
   set DoMnPrint 0
   set ManPrint 0
   if {[ string match *MAJ* $TMode ] || [ string match BOTH $TMode ] } {
      set DoMajor 1
   } else { set DoMajor 0 }
   if {[ string match *MIN* $TMode ] || [ string match BOTH $TMode ]} {
      set DoMinor 1
   } else { set DoMinor 0 }
   if [string match AUTOALL $LMode] { set DoMjPrint 1 ; set DoMnPrint 1 }
   if [string match AUTOMJ $LMode]  { set DoMjPrint 1 }
   if [string match AUTOMN $LMode]  { set DoMnPrint 1 }
   if [string match MANUAL $LMode] {
     if { $DoMajor } { set DoMjPrint 1 }
     if { $DoMinor } { set DoMnPrint 1 }
     set ManPrint 1
   } 

# UPDATE some output conditions based on the actual tick information.  Don't
#   output major or minor tick marks if there arn't any of them

   if { [lindex $tI 4] == 0 } { set DoMajor 0 }
   if { [lindex $tI 5] == 0 } { set DoMinor 0 }

#  NOW set up some preliminary variables used for both tick mark and/or 
#    label placement .. in particular we need to rescale the axis 
#    perpendicular to the axis being operated on to be LINEAR from 0 to 1.

   if [ string match X* $Axis ] {
      set bAxis X
      set Dir 1
      set WinInfo($wN,a1) 0
      set WinInfo($wN,p1) 0.0
      set WinInfo($wN,p4) 1.0
      set Sq SqX
      if [ string match Xb $Axis ] { set aX Xp } else { set aX Xs }
      set aY Yc
   } else {
      set bAxis Y
      set Dir 0
      set WinInfo($wN,a0) 0
      set WinInfo($wN,p0) 0.0
      set WinInfo($wN,p3) 1.0
      set Sq SqY
      if [ string match Yb $Axis ] { set aY Yp } else { set aY Ys }
      set aX Xc
   }

# RESCALE the axis perpendicular to the axis being operated

   GPHwinScale $wN $aX $aY Zc 0

# IF we are outputting labels then do some preliminary setup here

   if ![string match NONE* $LMode] { 

# OFFSET the level by a little more than half a character so that the top
#   of the text is at the output location.

      if { $Level < 0.0 } { set LSgN - } else { set LSgN + } 
#     set Level [expr $Level $LSgN 0.6]

# NOW get the character size and the offset for labeling.

   set tS [GPHtextLen "5" XY]
   set Off [expr ($Level $LSgN 0.5 * $Dir) * [lindex $tS $Dir]]

# SET the text characteristics for this axis.  This depends on what type of
#    text we will be outputting axis labels or axis numerical labels.

      if [string match AXIS $LMode] {
         TextProp [lindex $nI 7] HOLD [lindex $nI 8]
         set Place [lindex $nI 9]
         set Color [lindex $nI 6]
         set Ang [lindex $nI 10]
         set Just $TJust
         set Pos [PLTlabPos $pN $Axis $Pos]
         set aBase nO
	 set AxisPrint 1
      } else { 
         TextProp [lindex $nI 3] HOLD [lindex $nI 4]
         set Place [lindex $nI 0]
         set Color [lindex $nI 2]
         set Ang "0.0 0.0 0.0"
         if [ string match X* $Axis] { 
            set Just center
         } elseif { [string match Yt $Axis ] } { 
            if { [ string match INSIDE $Place ] } { 
               set Just left 
            } else { set Just right }
         } else { 
            if { [ string match INSIDE $Place ] } { 
               set Just right 
            } else { set Just left }
         }
         if {[string match MANUAL $LMode] && ($LabLen == 0)} {
             set Label $Pos 
         }
         set aBase tO
      }

      if [string match Xb $Axis ] { 
         set aO 1  
      } elseif [string match Xt $Axis ] { 
         set aO 3 
      } elseif [string match Yb $Axis ] { 
         set aO 2  
      } else { set aO 4 } 

#  SET up label INSIDE/OUTSIDE information.  This essentially sets ths the
#    sign used when shifting the label off the axis and identifies the axis
#    as a primary or secondary window axis 

      if [ string match INSIDE $Place ] {
         if [ string match *t $Axis ] { set LSgn - } else { set LSgn + } 
         incr aO 4
      } else { 
         if [ string match *t $Axis ] { set LSgn + } else { set LSgn - } 
      }
   } 

# IF invoked to output an AXIS label then that's all there is to do.  There
#   is not tick mark output with label so we can ignore it action setting.

   if $AxisPrint {

# NEED to set up the offsets according to the axis which the label is being
#   output against.  This gives where the text is to be output.

      set S $Label
      if [string match AXIS $LMode] {
         if {$bAxis == "X" } {
            set Y [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
            set X $Pos
         } else {
            set X [expr [lindex $PltInfo($wN,$aBase) $aO ] $LSgn $Off]
            set Y $Pos
	    set vN [lindex [split $tcl_version "."] 1]
	    if { $vN < 6 } { set S [PLTverLab $Label] }
         }
      }
      TexT $wN $X $Y 0.0 $Just $S $Color $Ang
    
# REPLACE all that we changed

      TextProp $OldtS HOLD $OldtB
      set GphInfo(lColor) $OldlC
      set GphInfo(tColor) $OldtC
      GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) $WinInfo($wN,Z) 0
      return;
   }

# WELL if we're here then we are outputting tick marks and/or numerical
#    labels along the axis.  The tick marks can be either one by one or
#    auto but if only labels are being output then this must be auto. 

# ESTABLISH some preminimary settings

   set LabSz 0
   switch -exact -- $bAxis {
      X  {  
         if { $WinInfo($wN,p3) > $WinInfo($wN,p0) } { 
            set Low $wN,p0 ; set Hi  $wN,p3 ; set FwD 1
         } else { set Low $wN,p3 ; set Hi  $wN,p0 ; set FwD 0 }
         set Sca  $wN,a0
         if { [ string match Xt $Axis ] } {
            set Index 1
            set Base $wN,p4
            set OSgn +
            set ISgn -
         } else {
            set Index 0
            set OSgn -
            set ISgn +
            set Base $wN,p1
         }
      }
      Y  {  
         if { $WinInfo($wN,p4) > $WinInfo($wN,p1) } { 
            set Low $wN,p1 ; set Hi  $wN,p4 ; set FwD 1
         } else { set Low $wN,p4 ; set Hi  $wN,p1 ; set FwD 0 }
         set Sca  $wN,a1
         if { [ string match Yt $Axis ] } {
            set Index 3
            set Base $wN,p3
            set OSgn +
            set ISgn -
         } else {
            set Index 2
            set OSgn -
            set ISgn +
            set Base $wN,p0
         }
      }
   }

#  GET the incrementation settings in case we are doing AUTO

   set Start  $WinInfo($Low)
   set eMj  $WinInfo($Hi)

   if { [string length [lindex $tI 8]] > 0 } {
      set sMj [lindex $tI 8]
      set dMj [lindex $tI 9]
   } else {
      set sMj $WinInfo($Low)
      set dMj [expr ($eMj - $sMj) / double([lindex $tI 4]) ] 
   }
   set nPix [lindex $PltInfo($pN,Pix) 0]
   set absE [expr $eMj + ($eMj - $sMj) / double($nPix)]

# SET some default tick mark settings.  These are modded later if necessary.

   set StartMj $WinInfo($Base) 
   set StartMn $WinInfo($Base) 
   set EndMj   $WinInfo($Base) 
   set EndMn   $WinInfo($Base) 
   set dLMj 0.0
   set dLMn 0.0

# ARE major tick marks included?  If they are then get their characteristics.

   if $DoMajor {

# MAJOR tick mark color

      set MjC [lindex $tI 6]
      if { [string length $MjC] == 0 } { set MjC $GphInfo(White) }

# GET their length which depends on their format.

      if { [string match SPAN [lindex $tI 0]] } {
         set dLMj 1.0
      } else { set dLMj [expr [lindex $tI 2] / $WinInfo($wN.$Sq)] }

      if { [string match STRADDLE [lindex $tI 0]] } {
          set StartMj [expr $StartMj $OSgn $dLMj / 2.0]
      } 

      if { [string match OUTSIDE [lindex $tI 0]] } {
          set MjSgN $OSgn 
      } else { set MjSgN $ISgn }

      set EndMj  [expr $StartMj $MjSgN $dLMj ]
   } 

# WHAT about minor tick marks?  Need their length too if we are to output 
#    them.

   if $DoMinor {

# MINOR tick mark color

      set MnC [lindex $tI 7]
      if { [string length $MnC] == 0 } { set MnC $GphInfo(White) }

# GET their length which depends on their format.

      if { [string match SPAN [lindex $tI 1]] } {
         set dLMn 1.0
      } else { set dLMn [expr [lindex $tI 3] / $WinInfo($wN.$Sq)] }

      if { [string match STRADDLE [lindex $tI 1]] } {
          set StartMn [expr $StartMn $OSgn $dLMn / 2.0]
      } 

      if { [string match OUTSIDE [lindex $tI 1]] } {
          set MnSgN $OSgn 
      } else { set MnSgN $ISgn }

      set EndMn  [expr $StartMn $MnSgN $dLMn ]
   }

# SET up some basic variables which are primarily used when we are AUTO
#    generating labels which means we are labeling an entire axis.

   if { $WinInfo($Sca) == 1 } {
       set TmPu [expr ceil(log10($sMj)) ]
       set TmPd [expr floor(log10($sMj)) ]
       set sMj [expr pow(10.0, $TmPu)]
       set bMj [expr pow(10.0, $TmPd)]
       set IncSgn *
       set dMj 10.0
   } else { set IncSgn + }

   set dMn [expr $dMj / double([lindex $tI 5]) ] 

   if {$WinInfo($Sca) == 1 } {
      if { [lindex $tI 5] == 2 }  {
         set MnInc 5
      } elseif { [lindex $tI 5] < 6 }  {
          set MnInc 2
      } else { set MnInc 1 }
   }

   if $DoMajor { 
       PLTaxisLims $pN $Axis TICK $StartMj $EndMj 
       PLTaxisLims $pN $Axis NUMBER $StartMj $EndMj 
   } 
   if $DoMinor { 
       PLTaxisLims $pN $Axis TICK $StartMn $EndMn 
       PLTaxisLims $pN $Axis NUMBER $StartMn $EndMn 
   }

   if { $DoMjPrint || $DoMnPrint } {
      set InFo [PLTgetSkip $pN $bAxis $sMj $eMj $dMj $IncSgn [lindex $nI 1]]
      lappend InFo [lindex $nI 5]
      lappend InFo $FwD
      if { $bAxis == "X" } {
         set Y [expr [lindex $PltInfo($wN,tO) $aO ] $LSgn $Off]
      } else {
         set X [expr [lindex $PltInfo($wN,tO) $aO ] $LSgn $Off]
      }
   }  else { set X .01; set Y .01 }

   if { $bAxis == "X" } {
      set LMjCmd  { Line $wN $W1 $V1 0.0 $W1 $V2 0.0 } 
      set LMnCmd  { Line $wN $W2 $V3 0.0 $W2 $V4 0.0 } 
      set PrCmd   { PLTdoLab $pN $W1 $Y $Just $Label $Color $InFo $TickNum } 
      set PrMnCmd { PLTdoLab $pN $W2 $Y $Just $Label $Color $InFo $TickNum } 
   } else {
      set LMjCmd  { Line $wN $V1 $W1 0.0 $V2 $W1 0.0 } 
      set LMnCmd  { Line $wN $V3 $W2 0.0 $V4 $W2 0.0 } 
      set PrCmd   { PLTdoLab $pN $X $W1 $Just $Label $Color $InFo $TickNum } 
      set PrMnCmd { PLTdoLab $pN $X $W2 $Just $Label $Color $InFo $TickNum } 
   }
   set V1 $StartMj 
   set V2 $EndMj
   set V3 $StartMn
   set V4 $EndMn

   set TickNum 0
   if [string match ONEMAJOR $TMode] {
      set W1 $Pos
      if { $W1 < $absE } {
         set GphInfo(lColor) $MjC
         eval $LMjCmd
         if $DoMjPrint {
            if { [string length $Label] == 0 } { 
               set Label [PLTnumFmt $Pos [lindex $nI 1 ] ]
            }
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
      }
   } elseif { [ string match ONEMINOR $TMode ] } {
      set W2 $Pos
      set GphInfo(lColor) $MnC
      if { $W2 <= $eMj } { 
         eval $LMnCmd 
         if $DoMnPrint {
            set W1 $W2
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
      }
   } else {

      if { $WinInfo($Sca) == 0 } { set eMj  [expr $eMj + .001 * $dMj] }
      set W1 $sMj
      while { $W1 <= $eMj } {
         if $DoMajor { 
            set GphInfo(lColor) $MjC
            eval $LMjCmd
         }
         if $DoMjPrint {
            set Label [PLTnumFmt $W1 [lindex $nI 1 ] ]
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
         
         if $DoMinor {
            if {$WinInfo($Sca) == 1 } { 
               set dMn [ expr $W1 * $MnInc ] 
               set W2 $dMn 
            } else { set W2 [expr $W1 + $dMn] }
            set GphInfo(lColor) $MnC
            set NextMj [expr $W1 $IncSgn $dMj]
            while { ($W2 < $NextMj) && ($W2 <= $eMj) } {
               eval $LMnCmd
               if $DoMnPrint {
                  set Label [PLTnumFmt $W2 [lindex $nI 1 ] ]
                  eval $PrMnCmd
                  set lS [string length $Label]
                  if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
               }
               set W2 [expr $W2 + $dMn]
            }
         }

         set W1 [expr $W1 $IncSgn $dMj]
         incr TickNum 
      }

      if { ($sMj > $WinInfo($Low)) && $DoMinor } {
         if {$WinInfo($Sca) == 1 } { set dMn [ expr $bMj * $MnInc ] } 
         set GphInfo(lColor) $MnC
         set W2 [expr $sMj - $dMn]
         while { $W2 >= $Start } {
             eval $LMnCmd
             set W2 [expr $W2 - $dMn]
          }
      }
   } 

   if { $DoMjPrint || $DoMnPrint } {
      if { $bAxis == "Y" } {
          set X [expr $X $LSgn [GPHtextLen $TheLab X]]
          PLTaxisLims $pN $Axis NUMBER $X $X 
      } else { 
          set Y [expr $Y $LSgn [GPHtextLen "5" Y]]
          PLTaxisLims $pN $Axis NUMBER $Y $Y 
      } 
   }

   TextProp $OldtS HOLD $OldtB
   set GphInfo(lColor) $OldlC
   set GphInfo(tColor) $OldtC
   GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) $WinInfo($wN,Z) 0                            
} 
