package provide TclPLT 1.0

# SYNOPSIS : Depending on the set actions, this routine will produce
#            one or more labeled or unlabled lick marks against Axis
#            or will produce axis text labels.
#
# INPUTS
#  Axis   :  Xb, Yb
#  TMode  :  ALLMAJOR, ALLMINOR, ONEMAJOR, ONEMINOR, BOTH, NONE
#  LMode  :  MANUAL, AUTO, AXIS, NONE
#  Level  :  Level of annotation
#  Pos    :  Location to place LABEL
#  LJust  :  Text justification when LMode is TEXT
#  Label  :  Label when LMode is TEXT

#  PUTTING up the axis and labeling around a polar plot is not as straight
#    forward as around a rectangular plot.  Generally to set offsets you
#    need to draw the tick marks on all axis prior to putting up labels.
#    Because of this there is really very little pre-setup that should be
#    omitted due ticks not being drawn.

proc PLTaxisPolar {pN Axis TMode LMode Level { Pos 0.0 } \
                     { LJust center} { Label "" } } {

   global PltInfo WinInfo GphInfo DevInfo RtoD tcl_version

# MINOR VERSION NUMBER - only 6 or greater can rotate
 
   set vN [lindex [split $tcl_version "."] 1]

# BREAK apart Pos which is a list of Radius, Phi 

   set pLen [llength $Pos]
   if { $pLen >= 2 } {
      set R [lindex $Pos 0] ; set P [lindex $Pos 1]
   } else { set R $Pos ; set P 0.0 }
   if { [string length $R] == 0 } { set R 1.0 }
   if { [string length $P] == 0 } { set P 0.0 }
                                                                                
   if { [string match NONE $LMode] && [string match NONE $TMode] } { return }

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# SAVE current text settings so we can reset them later and turn off fill
#   in case its on

   set OldlC $GphInfo(lColor)
   set OldtC $GphInfo(tColor)
   set OldtS $GphInfo(tSize)
   set OldtB $GphInfo(tBold)
   set OldcS $GphInfo(CoSyS)
   set OldcI $GphInfo(CsOps)
   PlotColor HOLD HOLD OFF

# EVERYTHING in this routine is done assuming Cartesian 
 
   SetCorSys CARTESIAN
                                                                                
# GET the screen designation and the window in which we are outputting

   set sC Scr$GphInfo(CurScr)
   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# GET the current X and Y tick and label inforamtion settings.  Need both. 

   PLTinfoCur $pN Xb nIX tIX
   PLTinfoCur $pN Yb nIY tIY

# GET the tick and number limits initialized.  Both are set to the window
#   extents

   PLTaxisLims $pN $Axis INITIALIZE 

#  NEED the distance across the plot so that we can normalize tick mark
#    lengths.  Lengths are given between 0 and 1 and 1 looks like it runs
#    from the origin to the outer extent of the plot.

   set yL  [expr abs($WinInfo($pN,p4) - $WinInfo($pN,p1))]

#  GET the start and stop values of the X (radius) and Y (phi).  For now
#    make the tacit assumption that polar plots run 0 to 360 degrees in Y. 
#    The inner radial edge won't run closer than the first major tick mark 
#    if there is no specified inner edge.  

   set StopX  $WinInfo($pN,p3)
   if { [string length [lindex $tIX 8]] > 0 } {
      set StartX [lindex $tIX 8]
   } else { set StartX [expr $StopX / [lindex $tIX 4] ] }

   set StopY  360.0
   if { [string length [lindex $tIY 8]] > 0 } {
      set StartY [lindex $tIY 8]
   } else { set StartY 0.0 }

# COMPUTE the step size between major and minor tick marks

   set dMjX [expr $StopX / [lindex $tIX 4] ]
   set dMjY [expr $StopY / [lindex $tIY 4] ]
   set dMnX [expr $dMjX  / [lindex $tIX 5] ]
   set dMnY [expr $dMjY  / [lindex $tIY 5] ]

# CHECK to see what we are ouputting

   set AxisPrint 0
   if {[ string match *MAJ* $TMode ] || [ string match BOTH $TMode ] } {
       set DoMajor 1
   } else { set DoMajor 0 }
   if {[ string match *MIN* $TMode ] || [ string match BOTH $TMode ]} {
         set DoMinor 1
   } else { set DoMinor 0 }
   if [string match AUTO $LMode] {
       set DoPrint 1
   } else { set DoPrint 0 }
   if [string match MANUAL $LMode] { 
      set ManPrint 1 ; set DoPrint 1
   } else { set ManPrint 0 }


# IF there are labels to be output set up the text properties now

   if ![string match NONE $LMode] {

# GET the basic XY text lengths 

      set TmP [ GPHtextLen "5" XY]
      set tS(0) [lindex $TmP 0]
      set tS(1) [lindex $TmP 1]

      if { $Level < 0.0 } { set LSgN - } else { set LSgN + } 
      set Level [expr $Level $LSgN 0.6]

      if [string match Xb $Axis] { set nI $nIX } else { set nI $nIY }

      if [ string match AXIS $LMode ] {
         TextProp [lindex $nI 7 ] HOLD [lindex $nI 8 ]
         set Place [lindex $nI 9 ]
         set lCol [lindex $nI 6]
         set R [PLTlabPos $pN $Axis $R]

	 if [string match Xb $Axis ] {
	    set aO 1
	 } elseif [string match Xt $Axis ] {
            set aO 3
         } elseif [string match Yb $Axis ] {
            set aO 2
         } else { set aO 4 }

	 set AxisPrint 1
      } else {
         TextProp [lindex $nI 3 ] HOLD [lindex $nI 4 ]
         set Place [lindex $nI 0 ]
         set Just center
         set lCol [lindex $nI 2]
      }

      if [ string match INSIDE $Place ] {
         if [ string match *t $Axis ] { set SgN - } else { set SgN + }
         incr aO 4
      } else {
         if [ string match *t $Axis ] { set SgN + } else { set SgN - }
      }
   }

# DO the tick mark and label output in one grand loop 

   if ![string match NONE $TMode] {

# SET the position of the first radial and phi major tick mark 

      set Phase $StartY
      if { $StartX == 0.0 } {
         set Radius [expr $StartX + $dMjX]
      } else { set Radius $StartX }

# OK - output anything that has to do with the X or radial axes. REMEMBER
#    X tick marks point in the Y direction which means that they are output 
#    arcs segments.  There are three cases ONEMAJOR, ONEMINOR and AUTO

      if [string match Xb $Axis] {
         set tLMj [expr $StopX * [lindex $tIX 2]]
         set SpaN(0) 0
         switch -exact -- [lindex $tIX 0] {
            INSIDE   {  set VaMj 0.0 ; set VbMj 1.0                 }
            OUTSIDE  {  set VaMj 1.0 ; set VbMj 0.0                 }
            STRADDLE {  set VaMj 0.5 ; set VbMj 0.5                 }
            SPAN     {  set VaMj 0.0 ; set VbMj 1.0 ; set SpaN(0) 1 }
         }

         set tLMn [expr $StopX * [lindex $tIX 3]]
         set SpaN(1) 0
         switch -exact -- [lindex $tIX 1] {
            INSIDE   {  set VaMn 0.0 ; set VbMn 1.0                 }
            OUTSIDE  {  set VaMn 1.0 ; set VbMn 0.0                 }
            STRADDLE {  set VaMn 0.5 ; set VbMn 0.5                 }
            SPAN     {  set VaMn 0.0 ; set VbMn 1.0 ; set SpaN(1) 1 }
         }

# ESTABLISH the tick limits.

         if { $DoMajor && !$SpaN(0) } { 
	     set DeG [expr atan2($tLMj, $StopX)] 
	     set Xa [expr $tLMj * sin(-$VaMj * $DeG)] 
	     set Xb [expr $tLMj * sin($VbMj * $DeG)] 
             PLTaxisLims $pN Xc TICK $Xa $Xb
             PLTaxisLims $pN Xc NUMBER $Xa $Xb
         }
         if { $DoMinor && !$SpaN(1) } { 
	     set DeG [expr atan2($tLMn, $StopX)] 
	     set Xa [expr $tLMn * sin(-$VaMn * $DeG)] 
	     set Xb [expr $tLMn * sin($VbMn * $DeG)] 
             PLTaxisLims $pN Xc TICK $Xa $Xb
             PLTaxisLims $pN Xc NUMBER $Xa $Xb
         }

	 if $DoPrint {
            set Off [expr ($Level $LSgN 0.5) * $tS(1)]
            switch -exact -- [lindex $nI 0] {
               INSIDE  { set Y [expr [lindex $PltInfo($pN,tO) 9 ] + $Off] }
               OUTSIDE { set Y [expr [lindex $PltInfo($pN,tO) 10 ] - $Off] }
            }
	 }

         if [string match ONEMAJOR $TMode] {
             set GphInfo(lColor) [lindex $tIX 6]
	     set DeG [expr atan2($tLMj, $R) * $RtoD] 
	     set Va [expr $P - $VaMj * $DeG] 
	     if $SpaN(0) { 
	        set Vb 360.0 
             } else { set Vb [expr $P + $VbMj * $DeG] } 
             Arc $wN 0.0 0.0 0.0 $R $Va $Vb 1 0 -1.0
	     if $DoPrint {
	        if $ManPrint { 
		   set LaB $Label
		} else { set LaB [PLTnumFmt $R [lindex $nI 1 ] ] }
                PLTdoLab $pN $R $Y center $LaB $lCol [list 1 0 NONE]
                set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
                PLTaxisLims $pN Xc NUMBER $Yo $Yo
             }
         } elseif { [string match ONEMINOR $TMode] } {
             set GphInfo(lColor) [lindex $tIX 7]
	     set DeG [expr atan2($tLMn, $R) * $RtoD] 
	     set Va [expr $P - $VaMn * $DeG] 
	     if $SpaN(1) { 
	        set Vb 360.0 
             } else { set Vb [expr $P + $VbMn * $DeG] } 
             Arc $wN 0.0 0.0 0.0 $R $Va $Vb 1 0 -1.0
	     if $DoPrint {
	        if $ManPrint { 
		   set LaB $Label 
		} else { set LaB [PLTnumFmt $R [lindex $nI 1 ] ] }
                PLTdoLab $pN $R $Y center $LaB $lCol [list 1 0 NONE]
                set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
                PLTaxisLims $pN Xc NUMBER $Yo $Yo
             }
         } else {
            while { $Radius <= $StopX } {
               if $DoMajor {
                  set Phi $StartY
                  set tR $Radius
                  set GphInfo(lColor) [lindex $tIX 6]
                  while { $Phi <= $StopY } {
	             set DeG [expr atan2($tLMj, $tR) * $RtoD] 
	             set Va [expr $Phi - $VaMj * $DeG] 
	             if $SpaN(0) { 
	                set Vb 360.0 
                     } else { set Vb [expr $Phi + $VbMj * $DeG] } 
                     Arc $wN 0.0 0.0 0.0 $Radius $Va $Vb 1 0 -1.0
                     set Phi [expr $Phi + $dMjY]
                     if $SpaN(0) { break }
                  }
               }

	       if $DoPrint {
		  set aL [PLTnumFmt $tR [lindex $nI 1 ] ]
                  PLTdoLab $pN $tR $Y center $aL $lCol [list 1 0 NONE]
                  set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
                  PLTaxisLims $pN Xc NUMBER $Y $Y
               }
   
# DRAW the associated minor tick mark(s) if they are being output.  The
#   first minor tick mark begins at the current major tick mark location 
#   offset by the minor tick mark step size.  Minor tick marks run up to 
#   the next major tick mark but need to make sure that the next major 
#   tick mark is within the plot  boundary!

               if $DoMinor {
                  set tM 1
                  set GphInfo(lColor) [lindex $tIX 7]
   
                  set RadMnX [expr $Radius + $dMnX]
                  set NextMj [expr $Radius + $dMjX]
                  if { $NextMj > $StopX } { set NextMj $StopX }

# LOOP over the minor tick marks

                  while { $RadMnX < $NextMj } {
                     if { $pLen == 2 } {
	                set Phi $P
	                set StopY $P
                     } else { set Phi $StartY }
                     set tR $RadMnX
   
# LOOP over the positions of each major Phi tick mark

                     while { $Phi <= $StopY } {
	                set DeG [expr atan2($tLMn, $tR) * $RtoD] 
	                set Va [expr $Phi - $VaMn * $DeG] 
	                if $SpaN(1) { 
	                   set Vb 360.0 
                        } else { set Vb [expr $Phi + $VbMn * $DeG] } 
                        Arc $wN 0.0 0.0 0.0 $RadMnX $Va $Vb 1 0 -1.0
                        set Phi [expr $Phi + $dMjY]
                        if $SpaN(1) { break }
                     }
                     set RadMnX [expr $RadMnX + $dMnX]
                  }
               }
               set Radius [expr $Radius + $dMjX]
            }
         }
      } else {

# THIS is the Y or PHI arm of the polar tick mark and label axis output. 
# LOOP over the phi major tick marks. 

         set tLMj [expr $yL * [lindex $tIY 2]]
         set SpaN(0) 0
         switch -exact -- [lindex $tIY 0] {
            INSIDE   {  set VaMj 1.0 ; set VbMj 0.0                  }
            OUTSIDE  {  set VaMj 0.0 ; set VbMj 1.0                  }
            STRADDLE {  set VaMj 0.5 ; set VbMj 0.5                  }
            SPAN     {  set VaMj 0.0  ; set VbMj 1.0 ; set SpaN(0) 1 }
         }

         set tLMn [expr $yL * [lindex $tIY 3]]
         set SpaN(1) 0
         switch -exact -- [lindex $tIY 1] {
            INSIDE   {  set VaMn 1.0 ; set VbMn 0.0                  }
            OUTSIDE  {  set VaMn 0.0 ; set VbMn 1.0                  }
            STRADDLE {  set VaMn 0.5 ; set VbMn 0.5                  }
            SPAN     {  set VaMn 0.0  ; set VbMn 1.0 ; set SpaN(1) 1 }
         }

         if { $DoMajor && !$SpaN(0) } { 
            set Xa [expr $StopX - $VaMj * $tLMj] 
	    set Xb [expr $StopX + $VbMj * $tLMj]
            PLTaxisLims $pN Xb TICK [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Xb NUMBER [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Xt TICK $Xa $Xb
            PLTaxisLims $pN Xt NUMBER $Xa $Xb
            PLTaxisLims $pN Yb TICK [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Yb NUMBER [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Yt TICK $Xa $Xb
            PLTaxisLims $pN Yt NUMBER $Xa $Xb
         }
         if { $DoMinor && !$SpaN(1) } { 
            set Xa [expr $StopX - $VaMn * $tLMn] 
	    set Xb [expr $StopX + $VbMn * $tLMn]
            PLTaxisLims $pN Xb TICK [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Xb NUMBER [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Xt TICK $Xa $Xb
            PLTaxisLims $pN Xt NUMBER $Xa $Xb
            PLTaxisLims $pN Yb TICK [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Yb NUMBER [expr -$Xb] [expr -$Xa]
            PLTaxisLims $pN Yt TICK $Xa $Xb
            PLTaxisLims $pN Yt NUMBER $Xa $Xb
         }

	 if $DoPrint { 
	    set Off [expr ($Level $LSgN 0.5) * $tS(1)]
            switch -exact -- [lindex $nI 0] {
               INSIDE  { set lR [expr [lindex $PltInfo($pN,tO) 8 ] - $Off] }
               OUTSIDE { set lR [expr [lindex $PltInfo($pN,tO) 4 ] + $Off] }
            }
         }

         if [string match ONEMAJOR $TMode] {
            set Phi [expr $P / $RtoD]
	    if $SpaN(0) {
	       set Xa 0.0 ; set Ya 0.0
               set Xb [expr $StopX * cos ($Phi)]   
               set Yb [expr $StopX * sin ($Phi)]
            } else {
               set Xa [expr ($R + $VaMj * $tLMj) * cos ($Phi)]   
               set Ya [expr ($R + $VaMj * $tLMj) * sin ($Phi)]
               set Xb [expr ($R + $VbMj * $tLMj) * cos ($Phi)]   
               set Yb [expr ($R + $VbMj * $tLMj) * sin ($Phi)]
            }
            Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
	    if $DoPrint {
	       if $ManPrint { 
	          set LaB $Label 
		  set AnG "0. 0. 0."
	       } else { 
		  set AnG "$P 0. 0."
	          set LaB [PLTnumFmt $P [lindex $nI 1] ]
               }
	       set X  [expr $lR * cos($Phi)]
	       set Y  [expr $lR * sin($Phi)]
	       PLTdoLab $pN $X $Y $LJust $LaB $lCol [list 1 0 NONE] 0 $AnG
	       set Xo [expr $X $SgN [GPHtextLen $LaB X]]
               set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
	       PLTaxisLims $pN Yb NUMBER $Xo $Xo
	       PLTaxisLims $pN Yt NUMBER $Xo $Xo
	       PLTaxisLims $pN Xb NUMBER $Yo $Yo
	       PLTaxisLims $pN Xt NUMBER $Yo $Yo
            }
         } elseif { [string match ONEMINOR $TMode] } {
            set Phi [expr $P / $RtoD]
	    if $SpaN(1) {
	       set Xa 0.0 ; set Ya 0.0
               set Xb [expr $StopX * cos ($Phi)]   
               set Yb [expr $StopX * sin ($Phi)]
            } else {
               set Xa [expr ($R + $VaMn * $tLMn) * cos ($Phi)]   
               set Ya [expr ($R + $VaMn * $tLMn) * sin ($Phi)]
               set Xb [expr ($R + $VbMn * $tLMn) * cos ($Phi)]   
               set Yb [expr ($R + $VbMn * $tLMn) * sin ($Phi)]
            }
            Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
	    if $DoPrint {
	       if $ManPrint { 
	          set LaB $Label 
		  set AnG "0. 0. 0."
	       } else { 
		  set AnG "$P 0. 0."
	          set LaB [PLTnumFmt $P [lindex $nI 1] ]
               }
	       set X  [expr $lR * cos($Phi)]
	       set Y  [expr $lR * sin($Phi)]
	       set LaB [PLTnumFmt $Phi [lindex $nI 1] ]
	       PLTdoLab $pN $X $Y $LJust $LaB $lCol [list 1 0 NONE] 0 $AnG
	       set Xo [expr $X $SgN [GPHtextLen $LaB X]]
               set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
	       PLTaxisLims $pN Yb NUMBER $Xo $Xo
	       PLTaxisLims $pN Yt NUMBER $Xo $Xo
	       PLTaxisLims $pN Xb NUMBER $Yo $Yo
	       PLTaxisLims $pN Xt NUMBER $Yo $Yo
            }
	  } else {
             if { $StartY > 0.0 } {
	        set StopP $StopY
             } else { set StopP [expr $StopY - .01] }
             while { $Phase <= $StopP } {
                if $DoMajor {
                   set Base $Radius
                   set tM 0
                   set GphInfo(lColor) [lindex $tIY 6]
                   set Phi [expr $Phase / $RtoD]
                   while { $Base <= $StopX } {
		      if $SpaN(0) {
		         set Xa 0.0 ; set Ya 0.0
                         set Xb [expr $StopX * cos ($Phi)]   
                         set Yb [expr $StopX * sin ($Phi)]
                      } else {
                         set Xa [expr ($Base - $VaMj * $tLMn) * cos ($Phi)]
                         set Ya [expr ($Base - $VaMj * $tLMn) * sin ($Phi)]
                         set Xb [expr ($Base + $VbMj * $tLMn) * cos ($Phi)]
                         set Yb [expr ($Base + $VbMj * $tLMn) * sin ($Phi)]
                      }
                      Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
                      set Base [expr $Base + $dMjX]
                      if $SpaN(0) { break; }
                   }
                }

		if $DoPrint {
		  set X  [expr $lR * cos($Phi)]
		  set Y  [expr $lR * sin($Phi)]
		  set Phi [expr $Phi * $RtoD]
	          set LaB [PLTnumFmt $Phi [lindex $nI 1] ]

                  if { $vN >= 6 } {
                     if { $Phi > 180.0 } {
		        set AnG "[expr 90.0 + $Phi] 0. 0."
                     } else { set AnG "[expr -90.0 + $Phi] 0. 0." }
		     set Just center
                   } else {
                     if { ($Phi < 80.0) || ($Phi > 280.0) } {
 	               set Just right
 	            } elseif { ($Phi > 110.0) && ($Phi < 250.0) } {
 	               set Just left
 	            } else { set Just center }
                  }
 
		   PLTdoLab $pN $X $Y $Just $LaB $lCol [list 1 0 NONE] 0 $AnG
		   set Xo [expr $X $SgN [GPHtextLen $LaB X]]
                   set Yo [expr $Y $SgN 0.5 * [GPHtextLen "5" Y]]
		   PLTaxisLims $pN Yb NUMBER $Xo $Xo
		   PLTaxisLims $pN Yt NUMBER $Xo $Xo
		   PLTaxisLims $pN Xb NUMBER $Yo $Yo
		   PLTaxisLims $pN Xt NUMBER $Yo $Yo
		}

                if $DoMinor {
                   set tM 1
                   set GphInfo(lColor) [lindex $tIY 7]
                   set AnGMn  [expr $Phase + $dMnY]
                   set NextMj [expr $Phase + $dMjY]

                   while { $AnGMn < $NextMj } {
	             if { $pLen == 2 } {
	                set Base $R
		        set StopX $R
                     } else { set Base $Radius }
                      set Phi [expr $AnGMn / $RtoD]
                      while { $Base <= $StopX } {
		         if $SpaN(1) {
		            set Xa 0.0 ; set Ya 0.0
                            set Xb [expr $StopX * cos ($Phi)]   
                            set Yb [expr $StopX * sin ($Phi)]
                         } else {
                            set Xa [expr ($Base - $VaMn * $tLMn) * cos ($Phi)]
                            set Ya [expr ($Base - $VaMn * $tLMn) * sin ($Phi)]
                            set Xb [expr ($Base + $VbMn * $tLMn) * cos ($Phi)]
                            set Yb [expr ($Base + $VbMn * $tLMn) * sin ($Phi)]
                         }
                         Line $wN $Xa $Ya 0.0 $Xb $Yb 0.0
                         set Base [expr $Base + $dMjX]
                         if $SpaN(1) { break; }
                      }
                      set AnGMn [expr $AnGMn + $dMnY]
                   }
                }
                set Phase [expr $Phase + $dMjY]
             }
         }
      }
   }

   if $AxisPrint  {
      if { [string length $Label] > 0 } { 
         if { [string match Yb $Axis] ||[string match Yt $Axis] } {
            set Off [expr ($Level $LSgN 0.5) * $tS(0)]
	    set X [expr [lindex $PltInfo($wN,nO) $aO ] $SgN $Off]
	    set Y $R
            set LaB ""
	    set sLen [expr [string length $Label] - 1]
	    for {set I 0 } { $I <= $sLen } { incr I } {
	       if { $I != $sLen } {
	          append LaB [string index $Label $I]\n
	       } else { append LaB [string index $Label $I] }
	    }
         } else { 
            set Off [expr ($Level $LSgN 0.5) * $tS(1)]
	    set Y [expr [lindex $PltInfo($wN,nO) $aO ] $SgN $Off]
	    set X $R
	    set LaB $Label
	 }
      }
      PLTdoLab $pN $X $Y $LJust $LaB $lCol [list 1 0 NONE]
   }


   TextProp $OldtS $OldtB
   set GphInfo(lColor) $OldlC
   set GphInfo(tColor) $OldtC
   SetCorSys $OldcS $OldcI
}
