package provide TclPLT 1.0

# SYNOPSIS : Depending on the set actions, this routine will produce
#            one or more labeled or unlabled tick marks against Axis
#            or will produce axis text labels.
#
# INPUTS
#  Axis  :  Xb or Yb
#  TMode  :  ALLMAJOR, ALLMINOR, ONEMAJOR, ONEMINOR, BOTH, NONE
#  LMode  :  MANUAL, AUTO, AXIS, NONE
#  Level :  Level of annotation
#  Pos   :  Location to place LABEL
#  LJust :  Text justification when LModeion is AXIS
#  Label :  Label when LModeion is AXIS


proc PLTaxisCross {pN Axis TMode LMode Level \
                             { Pos 0.0 } { LJust center} { Label "" } } {

   global PltInfo WinInfo GphInfo

# LETS get all of the idiot checks done first

   set LabLen [string length $Label]
   if { [string match NONE $LMode] && [string match NONE $TMode] } { return }
   if { [string match AXIS $LMode] && ($LabLen == 0) } { return }

# RESET Y axis designation if called with Yr of Yl

   if { [string match Yl $Axis] } { set Axis Yb }
   if { [string match Yr $Axis] } { set Axis Yt }

# THE axis origin and how to output labels and numbers along the axes

   set xO [lindex $PltInfo($pN,aI) 2]
   set yO [lindex $PltInfo($pN,aI) 3]
   set LAxisX [lindex $PltInfo($pN,aI) 4]
   set LAxisY [lindex $PltInfo($pN,aI) 5]

# SET up the screen designation
 
   set sC Scr$GphInfo(CurScr)

#  GET the curent window number and the current Axis labeling and tick mark
#     information

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN
   PLTinfoCur $pN $Axis nI tI

#  SAVE the current color and text settings so they can be put back later
  
   set OldlC $GphInfo(lColor)
   set OldtC $GphInfo(tColor)
   set OldtS $GphInfo(tSize)
   set OldtB $GphInfo(tBold)
   set OldtF $GphInfo(tFont)

# CHECK to see what we are outputting

   set AxisPrint 0
   if {[ string match *MAJ* $TMode ] || [ string match BOTH $TMode ] } {
      set DoMajor 1
   } else { set DoMajor 0 }
   if {[ string match *MIN* $TMode ] || [ string match BOTH $TMode ]} {
      set DoMinor 1
   } else { set DoMinor 0 }
   if [string match AUTO $LMode] {
     set DoPrint 1
   } else { set DoPrint 0 }
   if [string match MANUAL $LMode] {
     set ManPrint 1 ; set DoPrint 1
   } else { set ManPrint 0 }

#  NOW set up some preliminary variables used for both tick mark and/or 
#    label placement .. in particular we need to rescale the axis 
#    perpendicular to the axis being operated on to be LINEAR from 0 to 1.
#    Also need to know where the axis is in that new scaling.

   if [ string match X* $Axis ] {
      set bAxis X
      set Dir 1

      if { $WinInfo($wN,a1) == 1 } {
         set Ce [expr log($yO)]
         set dL [expr log($WinInfo($wN,p4) / $WinInfo($wN,p1))]
         set tB [expr log($yO / $WinInfo($wN,p1)) / $dL]
      } else {
         set Ce $yO
         set dL [expr $WinInfo($wN,p4) - $WinInfo($wN,p1)]
         set tB [expr ($yO - $WinInfo($wN,p1)) / $dL]
      }

      set WinInfo($wN,a1) 0
      set WinInfo($wN,p1) 0.0
      set WinInfo($wN,p4) 1.0
      set Sq SqX
      set aX Xp
      set aY Yc
   } else {
      set bAxis Y
      set Dir 0

      if { $WinInfo($wN,a0) == 1 } {
         set Ce [expr log($xO)]
         set dL [expr log($WinInfo($wN,p3) / $WinInfo($wN,p0))]
         set tB [expr log($xO / $WinInfo($wN,p0)) / $dL]
      } else {
         set Ce $xO
         set dL [expr $WinInfo($wN,p3) - $WinInfo($wN,p0)]
         set tB [expr ($xO - $WinInfo($wN,p0)) / $dL]
      }

      set WinInfo($wN,a0) 0
      set WinInfo($wN,p0) 0.0
      set WinInfo($wN,p3) 1.0
      set Sq SqY
      set aY Yp
      set aX Xc
   }
   set lB $tB

# RESCALE the axis perpendicular to the axis being operated

   GPHwinScale $wN $aX $aY Zc 0

# IF we are outputting labels then do some preliminary setup here

   if ![string match NONE* $LMode] { 

# OFFSET the level by a little more than half a character so that the top
#   of the text is at the output location.

      if { $Level < 0.0 } { set LSgN - } else { set LSgN + } 
      set Level [expr $Level $LSgN 0.6]

# NOW get the character size and the offset for labeling.

      set tS [GPHtextLen "5" XY]
      set Off [expr ($Level $LSgN 0.5 * $Dir) * [lindex $tS $Dir]]
 
# SET the text characteristics for this axis.  This depends on what type of
#    text we are outputting; axis labels or numerical labels.

      if [string match AXIS $LMode] {
         TextProp [lindex $nI 7] HOLD [lindex $nI 8]
         set Place [lindex $nI 9]
         set Color [lindex $nI 6]
         set Just $LJust
         set Pos [PLTlabPos $pN $Axis $Pos]
         set aBase nO
	 set AxisPrint 1
      } else { 
         TextProp [lindex $nI 3] HOLD [lindex $nI 4]
            set Place [lindex $nI 0]
         set Color [lindex $nI 2]
         if [ string match X* $Axis] { 
            set Just center
         } else { 
            if { [ string match INSIDE $Place ] } { 
               set Just right 
            } else { set Just left }
         }
         if {[string match MANUAL $LMode] && ($LabLen == 0)} {
             set Label $Pos 
         }
         set aBase tO
      }

# ONE of the complications with CROSS axis is the label outputs. This can
#   either be CROSS or BBOX. CROSS based labels are anchored to the drawn 
#   axes and BBOX labels are anchored to the bounding box.

      if [string match Xb $Axis ] { 
         if [string match CROSS $LAxisX] { 
	     set aO 0 
	 } else { set aO 2 ; set lB 0.0 }  
      } else {
         if [string match CROSS $LAxisY] { 
	    set aO 1 
	 } else { set aO 3 ; set lB 0.0 }  
      }

#  SET up label INSIDE/OUTSIDE information.  This essentially sets ths the
#    sign used when shifting the label off the axis and identifies the axis
#    as a primary or secondary window axis 

      if [ string match INSIDE $Place ] {
         if [ string match *t $Axis ] { set LSgn - } else { set LSgn + }
	 if { $aO < 2 } { incr aO 4 }
      } else {
         if [ string match *t $Axis ] { set LSgn + } else { set LSgn - }
	 if { $aO > 1 } { incr aO 4 }
      }
   }

# IF invoked to output an AXIS label then that's all there is to do.  There
#   is no tick mark output with label so we can ignore its action setting.

   if $AxisPrint {

# NEED to set up the offsets according to the axis which the label is being
#   output against.  This gives where the text is to be output.

      set S $Label
      if { $bAxis == "X" } {
         if [string match Xb $Axis] { 
            set bY [expr [lindex $PltInfo($wN,$aBase) $aO] + $lB] 
            set Y [expr $bY $LSgn $Off]
         } else { set Y [expr 1.0 $LSgn $Off] }
         set X $Pos
      } else {
         if [string match Yb $Axis] { 
            set bX [expr [lindex $PltInfo($wN,$aBase) $aO] + $lB] 
            set X [expr $bX $LSgn $Off]
         } else { set X [expr 1.0 $LSgn $Off] }
         set Y $Pos
         set S [PLTverLab $Label]
      }
      TexT $wN $X $Y 0.0 $Just $S $Color
    
# REPLACE all that we changed

      TextProp $OldtS HOLD $OldtF
      set GphInfo(lColor) $OldlC
      set GphInfo(tColor) $OldtC
      GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) $WinInfo($wN,Z) 0
      return;
   } 

# WELL if we're here then we are outputting tick marks and/or numerical
#    labels along the axis.  The tick marks can be either one by one or
#    auto but if only labels are being output then this must be auto. 

# ESTABLISH some preminimary settings

   set LabSz 0
   switch -exact -- $bAxis {
      X  {  
         if { $WinInfo($wN,p3) > $WinInfo($wN,p0) } { 
            set Low $wN,p0 ; set Hi  $wN,p3
         } else { set Low $wN,p3 ; set Hi  $wN,p0 }
         set Sca  $wN,a0
         set Index 0
         set OSgn -
         set ISgn +
      }
      Y  {  
         if { $WinInfo($wN,p4) > $WinInfo($wN,p1) } { 
            set Low $wN,p1 ; set Hi  $wN,p4
         } else {
            set Low $wN,p4 ; set Hi  $wN,p1
         }
         set Sca  $wN,a1
         set Index 2
         set OSgn -
         set ISgn +
      }
   }

#  GET the incrementation settings in case we are doing AUTO

   set Start  $WinInfo($Low)
   set eMj  $WinInfo($Hi)
   if { [string length [lindex $tI 8]] > 0 } {
      set sMj [lindex $tI 8]
      set dMj [lindex $tI 9]
   } else {
      set sMj $WinInfo($Low)
      set dMj [expr ($eMj - $sMj) / double([lindex $tI 4]) ] 
   }

# SET some default tick mark settings.  These are modded later if necessary.

   set StartMj 0.0
   set StartMn 0.0
   set EndMj   0.0
   set EndMn   0.0
   set dLMj    0.0
   set dLMn    0.0

# ARE major tick marks included?  If they are then get their characteristics.

   if $DoMajor {

# MAJOR tick mark color

      set MjC [lindex $tI 6]
      if { [string length $MjC] == 0 } { set MjC $GphInfo(White) }

# GET their length which depends on their format.

      if { [string match SPAN [lindex $tI 0]] } {
         set dLMj 1.0
      } else { set dLMj [expr [lindex $tI 2] / $WinInfo($wN.$Sq)] }

      if { [string match STRADDLE [lindex $tI 0]] } {
          set StartMj [expr $StartMj $OSgn $dLMj / 2.0]
      } 

      if { [string match OUTSIDE [lindex $tI 0]] } {
          set MjSgN $OSgn 
      } else { set MjSgN $ISgn }

      set EndMj  [expr $StartMj $MjSgN $dLMj ]
   }

# WHAT about minor tick marks?  Need their length too if we are to output 
#    them.

   if $DoMinor {

# MINOR tick mark color

      set MnC [lindex $tI 7]
      if { [string length $MnC] == 0 } { set MnC $GphInfo(White) }

# GET their length which depends on their format.

      if { [string match SPAN [lindex $tI 1]] } {
         set dLMn 1.0
      } else { set dLMn [expr [lindex $tI 3] / $WinInfo($wN.$Sq)] }

      if { [string match STRADDLE [lindex $tI 1]] } {
          set StartMn [expr $StartMn $OSgn $dLMn / 2.0]
      } 

      if { [string match OUTSIDE [lindex $tI 1]] } {
          set MnSgN $OSgn 
      } else { set MnSgN $ISgn }

      set EndMn  [expr $StartMn $MnSgN $dLMn ]
   }

# SET up some basic variables which are primarily used when we are AUTO
#    generating labels which means we are labeling an entire axis.

   if { $WinInfo($Sca) == 1 } {
       set TmPu [expr ceil(log10($sMj)) ]
       set TmPd [expr floor(log10($sMj)) ]
       set sMj [expr pow(10.0, $TmPu)]
       set bMj [expr pow(10.0, $TmPd)]
       set IncSgn *
       set dMj 10.0
   } else { set IncSgn + }


   set dMn [expr $dMj / double([lindex $tI 5]) ] 

   if {$WinInfo($Sca) == 1 } {
      if { [lindex $tI 5] == 2 }  {
         set MnInc 5
      } elseif { [lindex $tI 5] < 6 }  {
          set MnInc 2
      } else { set MnInc 1 }
   }

   if $DoMajor { 
      PLTaxisLims $pN $Axis TICK $StartMj $EndMj
      PLTaxisLims $pN $Axis NUMBER $StartMj $EndMj
   }
   if $DoMinor { 
      PLTaxisLims $pN $Axis TICK $StartMn $EndMn 
      PLTaxisLims $pN $Axis NUMBER $StartMn $EndMn 
   }

   if { $DoPrint } { 
      set InFo [PLTgetSkip $pN $bAxis $sMj $eMj $dMj $IncSgn [lindex $nI 1]]
      lappend InFo [lindex $nI 5]
      if { $bAxis == "X" } {
         set bY [expr [lindex $PltInfo($wN,$aBase) $aO] + $lB] 
         set Y [expr $bY $LSgn $Off]
         set bP [expr [lindex $PltInfo($wN,$aBase) $aO] $LSgn $Off] 
      } else {
         set bX [expr [lindex $PltInfo($wN,$aBase) $aO] + $lB] 
         set X [expr $bX $LSgn $Off]
         set bP [expr [lindex $PltInfo($wN,$aBase) $aO] $LSgn $Off] 
      }
   }  else { set X .01; set Y .01 }

   if { $bAxis == "X" } {
      set LMjCmd { Line $wN $W1 $V1 0.0 $W1 $V2 0.0 } 
      set LMnCmd { Line $wN $W2 $V3 0.0 $W2 $V4 0.0 } 
      set PrCmd  { PLTdoLab $pN $W1 $Y $Just $Label $Color $InFo $TickNum } 
   } else {
      set LMjCmd { Line $wN $V1 $W1 0.0 $V2 $W1 0.0 } 
      set LMnCmd { Line $wN $V3 $W2 0.0 $V4 $W2 0.0 } 
      set PrCmd  { PLTdoLab $pN $X $W1 $Just $Label $Color $InFo $TickNum } 
   }
   set V1 [expr $StartMj + $tB] 
   set V2 [expr $EndMj + $tB]
   set V3 [expr $StartMn + $tB]
   set V4 [expr $EndMn + $tB]

   set TickNum 0
   if [ string match ONEMAJOR $TMode ] {
      set W1 $Pos
      if { $W1 <= $eMj } {
         set GphInfo(lColor) $MjC
         eval $LMjCmd
         if { $DoPrint } {
            if { [string length $Label] == 0 } { 
               set Label [PLTnumFmt $Pos [lindex $nI 1 ] ]
            }
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
      }
   } elseif [ string match ONEMINOR $TMode ] {
      set W2 $Pos
      set GphInfo(lColor) $MnC
      if { $W2 <= $eMj } { 
         eval $LMnCmd 
         if { $DoPrint } {
            set W1 $W2
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
      }
   } else {
      if { $WinInfo($Sca) == 0 } { set eMj  [expr $eMj + .001 * $dMj] }
      set W1 $sMj
      while { $W1 <= $eMj } {
         if { $DoMajor == 1 } { 
            set GphInfo(lColor) $MjC
            eval $LMjCmd
         }
         if $DoPrint {
            set Label [PLTnumFmt $W1 [lindex $nI 1 ] ]
            eval $PrCmd
            set lS [string length $Label]
            if { $lS > $LabSz } { set LabSz $lS ; set TheLab $Label }
         }
         
         if $DoMinor {
            if {$WinInfo($Sca) == 1 } { 
               set dMn [ expr $W1 * $MnInc ] 
               set W2 $dMn 
            } else { set W2 [expr $W1 + $dMn] }
            set GphInfo(lColor) $MnC
            set NextMj [expr $W1 $IncSgn $dMj]
            while { ($W2 < $NextMj) && ($W2 <= $eMj) } {
               eval $LMnCmd
               set W2 [expr $W2 + $dMn]
            }
         }

         set W1 [expr $W1 $IncSgn $dMj]
         incr TickNum 
      }

      if { ($sMj > $WinInfo($Low)) && ($DoMinor == 1) } {
         if {$WinInfo($Sca) == 1 } { set dMn [ expr $bMj * $MnInc ] } 
         set GphInfo(lColor) $MnC
         set W2 [expr $sMj - $dMn]
         while { $W2 >= $Start } {
             eval $LMnCmd
             set W2 [expr $W2 - $dMn]
          }
      }
   } 

   if $DoPrint {
      if { $bAxis == "Y" } {
          set X [expr $bP $LSgn [GPHtextLen $TheLab X]]
	  if [string match CROSS $LAxisX] { 
              PLTaxisLims $pN Yb NUMBER $X $X 
          } else { PLTaxisLims $pN Yt NUMBER $X $X } 
      } else { 
          set Y [expr $bP $LSgn [GPHtextLen "5" Y]]
	  if [string match CROSS $LAxisY] { 
             PLTaxisLims $pN Xb NUMBER $Y $Y 
          } else { PLTaxisLims $pN Xt NUMBER $Y $Y } 
      } 
   }

   TextProp $OldtS HOLD $OldtF
   set GphInfo(lColor) $OldlC
   set GphInfo(tColor) $OldtC
   GPHwinScale $wN $WinInfo($wN,X) $WinInfo($wN,Y) $WinInfo($wN,Z) 0                            
} 
