package provide TclPLT 1.0

#INPUTS
 
# pN       Plot Number
# wN       Corresponding Window Number
# TmAxis   Is there a time based axis? (NONE, X, Y)
# TmB      Beginning time of axis
# TmE      Ending time of axis

# TICK, NUMBER, and AXIS definitions in list
 
# TICKS: (NOT MAPPING)
#   Index 0 : How to draw major tick marks (SPAN INSIDE OUTSIDE)
#   Index 1 : How to draw minor tick marks (SPAN INSIDE OUTSIDE)
#   Index 2 : Length of major tick mark (0 to 1 with 1 == SPAN)
#   Index 3 : Length of minor tick mark (0 to 1 with 1 == SPAN)
#   Index 4 : Number of major tick marks 
#   Index 5 : Number of minor tick marks
#   Index 6 : Color of major tick marks
#   Index 7 : Color of minor tick marks
#   Index 8 : Start position for major tick marks ("" = not set)
#   Index 9 : Step size to next major tick mark ("" = not set)
#
# TICKS: (MAPPING)
#   Index 0 : Minimum Value to use
#   Index 1 : Maximum Value to use
#   Index 2 : Unused
#   Index 3 : Unused
#   Index 4 : North-South latitude terminator
#   Index 5 : Unused
#   Index 6 : Color of major tick marks
#   Index 7 : Unused
#   Index 8 : Unused
#   Index 9 : Step size to next major tick mark ("" = not set)
#
# NUMBER:
#   Index 0  : Position of major tick number labels (INSIDE OUTSIDE)
#   Index 1  : Format of numerical axis labels
#   Index 2  : Color of numerical labels
#   Index 3  : Size of numerical labels
#   Index 4  : Bold numerical labels [OFF ON]
#   Index 5  : First and last label action (NONE MAX MIN BOTH ALL)
#   Index 6  : Axis text label color
#   Index 7  : Size of axis text labels
#   Index 8  : Bold axis text [OFF ON]
#   Index 9  : Output position of axis text labels
#   Index 10 : Phi Angle of axis text labels
#   Index 11 : Theta Angle of axis text labels
#   Index 12 : Rotation Angle of axis text labels

# AXIS
#   Index 0 : The plot type (BOX, CROSSHAIR, POLAR, MAP, BOX3D)
#   Index 1 : Color of the Axis
#   Index 2 : X Origin Point (for CROSSHAIR axis) 
#   Index 3 : Y Origin Point (for CROSSHAIR axis) 
#   Index 4 : X Label Position (for CROSSHAIR axis) (CROSS BBOX) 
#   Index 5 : Y Label Position (for CROSSHAIR axis)  (CROSS BBOX)

proc DefinePlot { pN wN {TmAxis NONE} {TmB 0} {TmE 0} } {
    global WinInfo PltInfo 

#  SET the parent window number of the plot

    set PltInfo($pN,wN) $wN

#  DETERMINE the number if pixels across the plot in both the X and Y
#     diretions.  These form a list in PltInfo

    set xPix [expr [lindex $WinInfo($wN,b) 2] - [lindex $WinInfo($wN,b) 0] ]
    set yPix [expr [lindex $WinInfo($wN,b) 3] - [lindex $WinInfo($wN,b) 1] ]
    set PltInfo($pN,Pix) [list $xPix $yPix]

#  IF one of the axis is time based flag that axis and get its base time,
#      that's the time base to use in all time conversions

    set PltInfo($pN,tAxis) $TmAxis
    if {[string match N* $TmAxis] == 0 } {
       PLTtimeBase $pN $TmAxis $TmB $TmE 
       set PltInfo($pN,bT) $TmB
       set PltInfo($pN,eT) $TmE
    } 
   
#  LASTLY set up some reaonable defaults for the axis, the axis tick mark 
#     and the number labeling parameters.  These only get set if they
#     don't already exist.  Different defaults are set up for cartesian
#     and polar plots.  If the plot type hasn't been set already then
#     its defaulted to cartesian.
# 
#  The recognized plot types are
#    BOX  
#    CROSSHAIR
#    POLAR
#    MAP
#    BOX3D

# DEFAULTS for a BOX plot - only the first two options are used in this
#   class of plots.  If no definition exists for this plot just copy the
#   default - otherwise check what's there are replace any field which
#   has been set to X

    set Defs [list BOX 255 0.0 0.0 BBOX BBOX]
    set nE [llength $Defs]
    if [info exists PltInfo($pN,aI)] { 
       set nL "" 
       for { set J 0 } { $J < $nE } { incr J } {
         set cE [lindex $PltInfo($pN,aI) $J]  
         if [string match X $cE] {
	    lappend nL [lindex $Defs $J]  
         } else { lappend nL $cE }
       }
       set PltInfo($pN,aI) $nL
    } else { set PltInfo($pN,aI) $Defs }

    if { $WinInfo($wN,pa0) == 1 } { set xbF expon } else { set xbF "%.1f" }
    if { $WinInfo($wN,sa0) == 1 } { set xtF expon } else { set xtF "%.1f" }
    if { $WinInfo($wN,pa1) == 1 } { set ybF expon } else { set ybF "%.1f" }
    if { $WinInfo($wN,sa1) == 1 } { set ytF expon } else { set ytF "%.1f" }
    if { $WinInfo($wN,pa2) == 1 } { set zbF expon } else { set zbF "%.1f" }
    if { $WinInfo($wN,sa2) == 1 } { set ztF expon } else { set ztF "%.1f" }

# NOW set up the default information for each of various plot types.  3D
#   plots have information about the Z axes added to them.
#
# BOX3D has 12 axes hence the increase in elements in tO and nO lists.
#   It however, only supports a primary and secondary axis and not 4
#   combinations as is possible.

    set pDimen 2
    set aD "0.0 0.0 0.0"

    switch -exact -- [lindex $PltInfo($pN,aI) 0] {
       BOX { 
          set tD(0) [list INSIDE INSIDE .05 .015 10 5 255 255 "" ""]
          set nD(0) [list OUTSIDE $xbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(1) [list OUTSIDE $xtF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(2) [list OUTSIDE $ybF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(3) [list OUTSIDE $ytF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set PltInfo($pN,tO) [list 0 0. 0. 1. 1. 0. 0. 1. 1.]
          set PltInfo($pN,nO) [list 0 0. 0. 1. 1. 0. 0. 1. 1.] 
       }
       BOX3D { 
          set pDimen 3
          set tD(0) [list INSIDE INSIDE .05 .015 10 5 255 255 "" ""]
          set nD(0) [list OUTSIDE $xbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(1) [list OUTSIDE $xtF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(2) [list OUTSIDE $ybF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(3) [list OUTSIDE $ytF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(4) [list OUTSIDE $zbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(5) [list OUTSIDE $ztF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set PltInfo($pN,tO) [list 0 0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. ]
          set PltInfo($pN,nO) [list 0 0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. \
                                      0. 0. 1. 1. 0. 0. 1. 1. ]
       }
       CROSSHAIR {
          set tD(0) [list STRADDLE STRADDLE .05 .015 10 5 255 255 "" ""]
          set nD(0) [list OUTSIDE $xbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(2) [list OUTSIDE $ybF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set PltInfo($pN,tO) [list 0 0. 0. 0. 0. 0. 0. 0. 0.]
          set PltInfo($pN,nO) [list 0 0. 0. 0. 0. 0. 0. 0. 0.] 
       }
       POLAR { 
          set tD(0) [list SPAN INSIDE 0.05 0.015 5 5 255 255 "" ""]
          set tD(2) [list SPAN INSIDE 0.05 0.015 8 5 255 255 "" ""]
          set nD(0) [list OUTSIDE $xbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(2) [list OUTSIDE $ybF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set PltInfo($pN,tO) [list 0 0. 0. 0. 0. 0. 0. 0. 0. 0. 0.]
          set PltInfo($pN,nO) [list 0 0. 0. 0. 0. 0. 0. 0. 0. 0. 0.] 
       }
       MAP { 
          set tD(0) [list -180.0 180.0 -90.0 90.0 90.0  "" 255 255 "" 15.0]
          set tD(2) [list -180.0 180.0 -90.0 90.0 180.0 "" 255 255 "" 30.0]
          set nD(0) [list OUTSIDE $xbF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set nD(2) [list OUTSIDE $ybF 255 15 HOLD NONE 255 15 HOLD OUTSIDE $aD]
          set PltInfo($pN,tO) [list 1 0. 0. 1. 1. 0. 0. 1. 1.]
          set PltInfo($pN,nO) [list 1 0. 0. 1. 1. 0. 0. 1. 1.] 
       }
    }

    set PltInfo($pN,Dimen) $pDimen

    if { $pDimen == 3 } { set nA 6 } else { set nA 4 }

    set aX(0) $pN,tIXb
    set aX(1) $pN,tIXt
    set aX(2) $pN,tIYb
    set aX(3) $pN,tIYt
    set aX(4) $pN,tIZb
    set aX(5) $pN,tIZt
    for { set I 0 } { $I < $nA } { incr I } {
       if ![info exists tD($I)] {
          set J [expr 2 * ($I / 2)]
          if [info exists tD($J)] { set K $J } else { set K 0 }
       } else { set K $I }

       if [info exists PltInfo($aX($I))] { 
          set nE [llength $tD($K)]
	  set nL ""
          for { set J 0 } { $J < $nE } { incr J } {
	     set cE [lindex $PltInfo($aX($I)) $J]  
             if [string match X $cE] {
	        lappend nL [lindex $tD($K)) $J]  
             } else { lappend nL $cE }
          }
          set PltInfo($aX($I)) $nL
       } else { set PltInfo($aX($I)) $tD($K) }
    }

    set aX(0) $pN,nIXb
    set aX(1) $pN,nIXt
    set aX(2) $pN,nIYb
    set aX(3) $pN,nIYt
    set aX(4) $pN,nIZb
    set aX(5) $pN,nIZt
    for { set I 0 } { $I < $nA } { incr I } {
       if ![info exists nD($I)] {
          set J [expr 2 * ($I / 2)]
          if [info exists nD($J)] { set K $J } else { set K 0 }
       } else { set K $I }

       if [info exists PltInfo($aX($I))] { 
          set nE [expr [llength $nD($K)] - 1]
	  set nL ""
          for { set J 0 } { $J <= $nE } { incr J } {
	     set cE [lindex $PltInfo($aX($I)) $J]  
	     if { ($J == $nE) && ([string length $cE] == 0) } { set cE X }
             if [string match X $cE] {
	        lappend nL [lindex $nD($K) $J]  
             } else { lappend nL $cE }
          }
          set PltInfo($aX($I)) $nL
       } else { set PltInfo($aX($I)) $nD($K) }
    }
}
