# THIS procedure combines the velocity image with the reduced distribution
#   function image.  The distribution function image has already had phi
#   integrated out and now just as dimensions energy x sensor.
#
# INPUT:  vImG  : velocity ImG
#         dfImG : reduced distribution ImG
#         Back  : the returned ImG

package provide MOments_C 1.0

proc MOveldfImG { vImG dfImG Back } {
   global mANS

   upvar $vImG  vE
   upvar $dfImG dF
   upvar $Back  rI

# THIS is the number of energy steps and sensors in the images. The dF 
#   has been reduced to nE, nS while the velocity array is laid down as nE.

   set nE $mANS(nE)
   set nS $mANS(0,NSEN)

   set N 0
   for { set J 0 } { $J < $nS } { incr J } {
      for { set I 0 } { $I < $nE } { incr I ; incr N } {
        set rI($N) [expr $vE($I) * $dF($N)]
      }
   } 
}
