#  THIS procedure resyncs the spin to begin at the phase which the first
#    acquired spin began.

package provide MOments 1.0

proc MOsyncSpin { } {
   global SInfo mANS ExDa ExPhi0

   set sN [lindex $mANS(MOMENTS) 0]

   set NoSync 1
   set SyncStat 1

# SYNC to start of a spin

   while { $NoSync } {

# ACQUIRE data for any sensor - this will have the phi data we need

      set S [split [ReadUDF $mANS($sN,KeY) 0 0 -1 0 0 0] "|"]
      if { [lindex $S 0] == -1 } { return -1 }

# First and last phase angles in the sweep

      set PhiA $ExPhi0(0)
      set PhiB $ExPhi0([expr $ExDa(0,NSMP) - 1])

# CHECK to see if the phase we want to start the spin on is included in this
#   sweep

      if { $PhiA > $PhiB } { set PhiB [expr $PhiB + 360.0] }
      if { ( $mANS(BegPhi) >= $PhiA ) && ( $mANS(BegPhi) <= $PhiB ) } {
         set NoSync 0
      } else { set SInfo($mANS($sN,KeY),0,RSTATUS) 1 }
   }

   puts stderr "Dectected Gap in Data ... Spin ReSynced"

   return $SyncStat
}
