# THIS procedure reads a moments file created by the moments program

package provide MOments 1.0

proc MOreadDmp { CoSyS } {
   global iMOM 

   if [catch {open $iMOM(MoMFile) r} fd] {
      puts stderr "UNABLE TO OPEN MENUFILE: $iMOM(MoMFile)"
      return
   }

#  READ in the file header.  This goes on until the line BEGIN.  We also
#    need to get the project from the SOURCE line.

   set iMOM(mInfo) ""
   set StoP 0
   while { !$StoP } {
      gets $fd LiNe
      set LiNe [string trim $LiNe]
      set Fields [split $LiNe ":"]
      if { [llength $Fields] > 1 } {
         if [string match SOURCE [string trim [lindex $Fields 0]]] {
            set PMEIV [split [lindex $Fields 1] "."]
	    set ProJ [string trim [lindex $PMEIV 0]]
	 }
      }
      set StoP [string match BEGIN $LiNe]
      if !$StoP { lappend iMOM(mInfo) $LiNe }
   }

   MOtransMatrix rM $CoSyS $PMEIV

#  puts stderr "$rM(0) $rM(1) $rM(2)"
#  puts stderr "$rM(3) $rM(4) $rM(5)"
#  puts stderr "$rM(6) $rM(7) $rM(8)"

#  set V(0) -5.24e5
#  set V(1) -6.70e4
#  set V(2) 5.0e4
#  TUmatrixMath rM * V V1 3 3 3 1
#  puts stderr "$V1(0) $V1(1) $V1(2)"
#  set V(0) -5.9e5
#  set V(1) -5.79e4
#  set V(2) 4.51e4
#  TUmatrixMath rM * V V1 3 3 3 1
#  puts stderr "$V1(0) $V1(1) $V1(2)"
#  exit

   set FmT "%d %d %s %d %d %s %e %e %e %e %e %e %e %e %e %e %e %e \
            %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e %e" 
   
   set mAns(mData) ""
   while { [gets $fd LiNe] > 0 } {
      scan $LiNe $FmT bY bD bT eY eD eT D V(0) V(1) V(2) \
                      V2(0) V2(1) V2(2) V2(3) V2(4) V2(5) \
		      V3(0) V3(1) V3(2) V3(3) V3(4) \
		      V3(5) V3(6) V3(7) V3(8) V3(9) \
	              F(0) F(1) F(2) F(3) F(4) \
	              F(5) F(6) F(7) F(8) F(9) 

      set tM [split $bT ":"]
      set H [string trimleft [lindex $tM 0] "0"]
      if { [string length $H] == 0 } { set H 0 }
      set M [string trimleft [lindex $tM 1] "0"]
      if { [string length $M] == 0 } { set M 0 }
      set S [string trimleft [lindex $tM 2] "0"]
      set bM [expr int($H * 3600000 + $M * 60000 + $S * 1000)]

      set tM [split $eT ":"]
      set H [string trimleft [lindex $tM 0] "0"]
      if { [string length $H] == 0 } { set H 0 }
      set M [string trimleft [lindex $tM 1] "0"]
      if { [string length $M] == 0 } { set M 0 }
      set S [string trimleft [lindex $tM 2] "0"]
      set eM [expr int($H * 3600000 + $M * 60000 + $S * 1000)]

# GET the velocity into the right coordinate system.

      TUmatrixMath rM * V V1 3 3 3 1

# SET the beginning and ending X, Y and Z locations in rotation matrix

      set b(X) 0 ; set e(X) 3
      set b(Y) 3 ; set e(Y) 6
      set b(Z) 6 ; set e(Z) 9

# GET the v(i)v(j) velocities into the right coordinate system.

      set Vm(0) $V2(0);  set Vm(1) $V2(1);  set Vm(2) $V2(2)  
      set Vm(3) $V2(1);  set Vm(4) $V2(3);  set Vm(5) $V2(4)  
      set Vm(6) $V2(2);  set Vm(7) $V2(4);  set Vm(8) $V2(5)  

      set Vs [ list XX XY XZ YY YZ ZZ]

      for { set I 0 } { $I < 6 } { incr I } {
         set L 0
         set V2($I) 0.0
	 set cA [string index [lindex $Vs $I] 0]
	 set cB [string index [lindex $Vs $I] 1]
         for { set J $b($cA) } { $J < $e($cA) } { incr J } {
            for { set K $b($cB) } { $K < $e($cB) } { incr K ; incr L } {
               set V2($I) [expr $V2($I) + $Vm($L) * $rM($J) * $rM($K)]
            }
         }
      }

# GET the v(i)v(j)v(k) velocities into the right coordinate system.

      set Vm(0) $V3(0);   set Vm(1) $V3(1);   set Vm(2) $V3(2)  
      set Vm(3) $V3(1);   set Vm(4) $V3(3);   set Vm(5) $V3(4)  
      set Vm(6) $V3(2);   set Vm(7) $V3(4);   set Vm(8) $V3(5)  
      set Vm(9) $V3(1);   set Vm(10) $V3(3);  set Vm(11) $V3(4)  
      set Vm(12) $V3(3);  set Vm(13) $V3(6);  set Vm(14) $V3(7)  
      set Vm(15) $V3(4);  set Vm(16) $V3(7);  set Vm(17) $V3(8)  
      set Vm(18) $V3(2);  set Vm(19) $V3(4);  set Vm(20) $V3(5)  
      set Vm(21) $V3(4);  set Vm(22) $V3(7);  set Vm(23) $V3(8)  
      set Vm(24) $V3(5);  set Vm(25) $V3(8);  set Vm(26) $V3(9)  

      set Vs [ list XXX XXY XXZ XYY XYZ XZZ YYY YYZ YZZ ZZZ]

      for { set I 0 } { $I < 10 } { incr I } {
         set N 0
         set V3($I) 0.0
	 set cA [string index [lindex $Vs $I] 0]
	 set cB [string index [lindex $Vs $I] 1]
	 set cC [string index [lindex $Vs $I] 2]
         for { set J $b($cA) } { $J < $e($cA) } { incr J } {
            for { set K $b($cB) } { $K < $e($cB) } { incr K } {
               for { set L $b($cC) } { $L < $e($cC) } { incr L ; incr N } {
                  set V3($I) [expr $V3($I) + $Vm($N) * $rM($J) * $rM($K) * $rM($L)]
               }
            }
         }
      }

      lappend iMOM(vMOM) [list $bY $bD $bM $eY $eD $eM $D \
        $V1(0) $V1(1) $V1(2) \
        $V2(0) $V2(1) $V2(2) $V2(3) $V2(4) $V2(5) \
        $V3(0) $V3(1) $V3(2) $V3(3) $V3(4) $V3(5) $V3(6) $V3(7) $V3(8) $V3(9) \
	$F(0) $F(1) $F(2) $F(3) $F(4) $F(5) $F(6) $F(7) $F(8) $F(9) ]
   }
}
