#  THIS procedure processes the moments request

package provide MOments 1.0

proc MOprocessReq { } {
   global SInfo mANS


# PRE computations

   MOpreComps
   MOsetSBase

# OPEN all data sources.

   MOgetSrcs
   MOopenSrcs
       
# PRINT out the moments output header

   MOmomentsPr NEW

# GET the sensor elevation data

   MOacqTheta

# FORM the moments

   set TmChk 1
   set SyncStat 1
   set mANS(eMs) [expr ($mANS(hRe)*3600 + $mANS(mNe)*60 + $mANS(sCe)) * 1000]
   while { $TmChk > 0 } {
       set SpinStat [MOacqSpin]
       if { $SpinStat >= 0 } {
          set TmChk [TUtimeCmp 0 $mANS(yRe) $mANS(dYe) $mANS(eMs) \
                                 $mANS(eY) $mANS(eD) $mANS(eM) ]
       }
       if { $SpinStat == 1 } {

	  MOgetAnc  
	  MOvelComps [lindex $mANS(MOMENTS) 0] 0

# IF parts of the distribution function are being clipped do it here

	  MOclipData

# FINALIZE the phi image

          MOfinalizePhi

# IF parts of the distribution function are being masked do it here

	  MOmaskData

# BUILD the moments

	  if { $mANS(cFmT) == 1 } {
	     MOlinearElements
	     MOmomentsLinear
	  } else { MOmomentsBuild } 

# PRINT out the results

          MOmomentsPr ADD
       } elseif { $SpinStat == 0 } { set SyncStat [MOsyncSpin] }

       if { ($SpinStat < 0) || ($SyncStat < 0) } { set TmChk 0 }
   }
   MOmomentsPr END
}
