#  Pre computations.  Read in the correction file data if there is any.

package provide MOments 1.0

proc MOpreComps { } {
   global mANS corM

   if [string match Electron $mANS(Species) ] {
      set mANS(Mass) $mANS(eMass)
      set mANS(pVSgn) -
   } else { 
      set mANS(Mass) [expr $mANS(pMass) * $mANS(sAMU)] 
      set mANS(pVSgn) +
   }

   set mANS(toV) [expr 2.0 * $mANS(Q) / $mANS(Mass)]

   set mANS(DoCor) 0
   if { [string length $mANS(cFile)] > 0 } {
      if [catch { open $mANS(cFile) r } fd  ] {
         puts stderr "Can't Open Correction File $mANS(cFile)"
         exit
      }

      set mANS(DoCor) 1

# READ the Header line. The second element is the number of values per line,
#   not including the line number

      gets $fd LiNe
      scan $LiNe "%s %d" T nV

# SKIP over any remaining header informatio

      set StoP 0
      while { !$StoP } {
         gets $fd LiNe
	 set LiNe [string trim $LiNe]
	 set fS [expr [string first " " $LiNe] - 1]
	 if { $fS >= 0 } { set LiNe [string range $LiNe 0 $fS] }
	 set StoP [string match BEGIN $LiNe]
      }

# CREATE the line format entry and variable list

      set FmT "%d "
      set Var "C "
      for { set I 0 } { $I < $nV } { incr I } { 
         append FmT " %f" 
         append Var " V($I)" 
      }

# SCAN command

      set sCmd "scan \$LiNe \$FmT "
      append sCmd $Var

# PICK up the data 

      set E 0
      while  { [gets $fd LiNe] >= 0 } {
         set cH [string index [string trim $LiNe] 0]
	 if ![string match "#" $cH] {
            eval $sCmd
            for { set I 0 } { $I < $nV } { incr I } { 
	       set corM($I,$E) $V($I)
            }
	    incr E
         }
      }

      close $fd
   }
}
