package provide MOments 1.0

proc MOmomentsLinear { } {
   global mANS phImG vBImG vEImG thBImG thEImG dfImG TwoPI PI slImG inImG 

# DO all of the initial velocity integrations or order 2 through 5 which
#    will take us from density through heat-flux.

   MOmassintVel vBImG vEImG v0ImG 0
   MOmassintVel vBImG vEImG v1ImG 1
   MOmassintVel vBImG vEImG v2ImG 2
   MOmassintVel vBImG vEImG v3ImG 3

# DO all of the theta (elevation) integrations over the various trig functions
#    which will be needed in the computations

   MOmassintTh thBImG thEImG thSImG SIN
   MOmassintTh thBImG thEImG thS2ImG SIN2
   MOmassintTh thBImG thEImG thSCImG SINCOS
   MOmassintTh thBImG thEImG thS3ImG SIN3
   MOmassintTh thBImG thEImG thS2CImG SIN2COS
   MOmassintTh thBImG thEImG thC2SImG COS2SIN
   MOmassintTh thBImG thEImG thS4ImG SIN4
   MOmassintTh thBImG thEImG thC3SImG COS3SIN
   MOmassintTh thBImG thEImG thS3CImG SIN3COS
   MOmassintTh thBImG thEImG thS2C2ImG SIN2COS2

# FOR efficiency, compute all the moments which require only d(phi) 
#   integration to begin with.  These are density, vz, vz2, vz3

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo NONE
   MOintPhi Combo IntP 

# DENSITY

   MOveldfImG v0ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thSImG IntV Combo

   set mANS(Density) [MOintTheta Combo]
   if { $mANS(Density) <= 0.0 } { MOsetBad ; return }

# VZ

   MOveldfImG v1ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thSCImG IntV Combo
   set mANS(Vz) [expr [MOintTheta Combo] / $mANS(Density)]

# VZ2

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thC2SImG IntV Combo
   set mANS(Vz2) [expr [MOintTheta Combo] / $mANS(Density)]

# VZ3

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thC3SImG IntV Combo
   set mANS(Vz3) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)d(phi) integration. 
#    These are vx, vxvz, vz2vx

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo COS
   MOintPhi Combo IntP 

# VX

   MOveldfImG v1ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2ImG IntV Combo
   set mANS(Vx) [expr [MOintTheta Combo] / $mANS(Density)]

# VXVZ

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2CImG IntV Combo
   set mANS(VxVz) [expr [MOintTheta Combo] / $mANS(Density)]

# VXVZ2

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2C2ImG IntV Combo
   set mANS(VxVz2) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only sin(phi)d(phi) integration. 
#    These are vy, vyvz, vz2vy

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo SIN
   MOintPhi Combo IntP 

# VY

   MOveldfImG v1ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2ImG IntV Combo
   set mANS(Vy) [expr [MOintTheta Combo] / $mANS(Density)]

# VYVZ

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2CImG IntV Combo
   set mANS(VyVz) [expr [MOintTheta Combo] / $mANS(Density)]

# VYVZ2

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS2C2ImG IntV Combo
   set mANS(VyVz2) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)**2d(phi) integration. 
#    These are vx2, vx2vz

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo COS2
   MOintPhi Combo IntP 

# VX2

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3ImG IntV Combo
   set mANS(Vx2) [expr [MOintTheta Combo] / $mANS(Density)]

# VX2VZ

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3CImG IntV Combo
   set mANS(Vx2Vz) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only sin(phi)**2d(phi) integration. 
#    These are vy2, vy2vz

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo SIN2
   MOintPhi Combo IntP 

# VY2

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3ImG IntV Combo
   set mANS(Vy2) [expr [MOintTheta Combo] / $mANS(Density)]

# VY2VZ

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3CImG IntV Combo
   set mANS(Vy2Vz) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)sin(phi)**2d(phi) 
#    integration.  These are vxvy and vxvyvz.

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo SINCOS
   MOintPhi Combo IntP 

# VXVY

   MOveldfImG v2ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3ImG IntV Combo
   set mANS(VxVy) [expr [MOintTheta Combo] / $mANS(Density)]

# VXVYVZ

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS3CImG IntV Combo
   set mANS(VxVyVz) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)**3d(phi) integration. 
#    These are vx3

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo COS3
   MOintPhi Combo IntP 

# VX3

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS4ImG IntV Combo
   set mANS(Vx3) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only sin(phi)**3d(phi) integration. 
#    These are vy3

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo SIN3
   MOintPhi Combo IntP 

# VY3

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS4ImG IntV Combo
   set mANS(Vy3) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)**2sin(phi)d(phi) 
#    integration.  These are vx2vy.

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo COS2SIN
   MOintPhi Combo IntP 

# VX2VY

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS4ImG IntV Combo
   set mANS(Vx2Vy) [expr [MOintTheta Combo] / $mANS(Density)]

# COMPUTE all the moments which require only cos(phi)sin(phi)**2d(phi) 
#    integration.  These are vx2vy.

# PERFORM the mass integration of phi. 

   MOlinearintPh phImG slImG inImG Combo SIN2COS
   MOintPhi Combo IntP 

# VXVY2

   MOveldfImG v3ImG IntP Combo
   MOintVel Combo IntV 
   MOthdfImG thS4ImG IntV Combo
   set mANS(VxVy2) [expr [MOintTheta Combo] / $mANS(Density)]
}
