# THIS procedure builds the integrate phi ImG 
#
# INPUT:  ImG  : the phase array ImG which is only the beginning angles
#         Back : the returned integrated array
#         Trig : the trig function being integrated

package provide MOments_C 1.0

proc MOlinearintPh { phImG slImG inImG Back Trig } {
   global mANS TwoPI

   upvar $phImG P
   upvar $slImG A
   upvar $inImG B
   upvar $Back  R

# The ImG array is set up to hold one sweeps worth of phase values per
#   sector.  All sensors from that sector use the same phase values.
#   tE is the number of phases per sector and ToT is the total length
#   of the ImG array

   set tE  $mANS(nE)
   set ToT [expr $tE * $mANS(Sector)]

# SET up the sign to use when doing the integration.  This depends on
#   whether we are integrating low to hi or hi to low.

   if { $mANS(SpiN) > 0 } { set SgN + } else { set SgN - }

   set nE $mANS(nE)
   set nS $mANS(Sector)
   set nT $mANS(0,NSEN)

   set N 0
   switch -exact -- $Trig {
      NONE {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP $P($J)
	       if { [expr ${SgN}($P($L) - $lP)] < 0.0 } {
	          set hP [expr $P($L) + $TwoPI]
               } else { set hP $P($L) }
	       set dB($I) [expr ${SgN}($hP - $lP)]
	       set dA($I) [expr ${SgN}($hP * $hP - $lP * $lP) / 2.0]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr $A($N) * $dA($I) + $B($N) * $dB($I)]
	       }
	    }
	 }
      }
      SIN {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP $P($J)
	       if { [expr ${SgN}($P($L) - $lP)] < 0.0 } {
	          set hP [expr $P($L) + $TwoPI]
               } else { set hP $P($L) }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set dA($I) [expr $sH - $hP * $cH - ($sL - $lP * $cL)]
	       set dB($I) [expr -$cH + $cL]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COS {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP $P($J)
	       if { [expr ${SgN}($P($L) - $lP)] < 0.0 } {
	          set hP [expr $P($L) + $TwoPI]
               } else { set hP $P($L) }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set dA($I) [expr $cH + $hP * $sH - ($cL + $lP * $sL)]
	       set dB($I) [expr $sH - $sL]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COS2 {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP [expr 2.0 * $P($J)]
	       if { [expr ${SgN}($P($L) - $P($J))] < 0.0 } {
	          set hP [expr 2.0 * ($P($L) + $TwoPI)]
               } else { set hP [expr 2.0 * $P($L)] }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set dA($I) [expr (($hP * $hP - $lP * $lP) / 2.0 + \
	               $hP * $sH - $lP * $sL + $cH - $cL) / 8.0]
	       set dB($I) [expr ($hP + $sH - $lP - $sL) / 4.0 ]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      SIN2 {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP [expr 2.0 * $P($J)]
	       if { [expr ${SgN}($P($L) - $P($J))] < 0.0 } {
	          set hP [expr 2.0 * ($P($L) + $TwoPI)]
               } else { set hP [expr 2.0 * $P($L)] }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set dA($I) [expr (($hP * $hP - $lP * $lP) / 2.0 - \
	               $hP * $sH + $lP * $sL - $cH + $cL) / 8.0]
	       set dB($I) [expr ($hP - $sH - $lP + $sL) / 4.0 ]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COSSIN -
      SINCOS {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP [expr $P($J)]
	       set l2P [expr 2.0 * $P($J)]
	       if { [expr ${SgN}($P($L) - $P($J))] < 0.0 } {
	          set hP  [expr $P($L) + $TwoPI]
	          set h2P [expr 2.0 * ($P($L) + $TwoPI)]
               } else { set hP $P($L) ; set h2P [expr 2.0 * $P($L)] }

               set sH  [expr sin($hP)]
               set s2H [expr sin($h2P)]
               set sL  [expr sin($lP)]
               set s2L [expr sin($l2P)]
	       set sH2 [expr $sH * $sH] 
	       set sL2 [expr $sL * $sL] 
	       set dA($I) [expr ($hP * $sH2 - $lP * $sL2) / 2.0 - \
	            ($h2P - $s2H - $l2P + $s2L) / 8.0] 
	       set dB($I) [expr ($sH2 - $sL2) / 2.0]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COS3 {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP [expr $P($J)]
	       set l3P [expr 3.0 * $P($J)]
	       if { [expr ${SgN}($P($L) - $P($J))] < 0.0 } {
	          set hP  [expr $P($L) + $TwoPI]
	          set h3P [expr 3.0 * ($P($L) + $TwoPI)]
               } else { set hP $P($L) ; set h3P [expr 3.0 * $P($L)] }

               set sH  [expr sin($hP)]
               set s3H [expr sin($h3P)]
               set cH  [expr cos($hP)]
               set c3H [expr cos($h3P)]
               set sL  [expr sin($lP)]
               set s3L [expr sin($l3P)]
               set cL  [expr cos($lP)]
               set c3L [expr cos($l3P)]

	       set dA($I) [expr ($h3P * $s3H + $c3H - $l3P * $s3L - $c3L)/36. \
                         + 3 * ($hP * $sH  + $cH - $lP * $sL - $cL) / 4.0]
	       set dB($I) [expr $sH - $sH * $sH * $sH/3.0 - \
	                        $sL + $sL * $sL * $sL/3.0 ]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      SIN3 {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP [expr $P($J)]
	       set l3P [expr 3.0 * $P($J)]
	       if { [expr ${SgN}($P($L) - $P($J))] < 0.0 } {
	          set hP  [expr $P($L) + $TwoPI]
	          set h3P [expr 3.0 * ($P($L) + $TwoPI)]
               } else { set hP $P($L) ; set h3P [expr 3.0 * $P($L)] }

               set sH  [expr sin($hP)]
               set s3H [expr sin($h3P)]
               set cH  [expr cos($hP)]
               set c3H [expr cos($h3P)]
               set sL  [expr sin($lP)]
               set s3L [expr sin($l3P)]
               set cL  [expr cos($lP)]
               set c3L [expr cos($l3P)]

	       set dA($I) [expr ($h3P * $c3H - $s3H - $l3P * $c3L + $s3L)/36. \
                         + 3 * ($sH - $hP * $cH - $sL  + $lP * $cL) / 4.0]
	       set dB($I) [expr $cH * $cH * $cH/3.0 - $cH - \
	                        $cL * $cL * $cL/3.0 + $cL ]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COSSIN2 -
      SIN2COS {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP $P($J)
	       if { [expr ${SgN}($P($L) - $lP)] < 0.0 } {
	          set hP [expr $P($L) + $TwoPI]
               } else { set hP $P($L) }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set sH3 [expr $sH * $sH * $sH]
	       set sL3 [expr $sL * $sL * $sL]
	       set dA($I) [expr ($hP * $sH3 - $cH * $cH * $cH/3.0 + $cH \
	                   - $lP * $sL3 + $cL * $cL * $cL/3.0 - $cL)/3.0 ]
	       set dB($I) [expr ($sH3 - $sL3)/3.0]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
      COS2SIN -
      SINCOS2 {
         set pB 0
	 for { set K 0 } { $K < $nS } { incr K ; incr pB $nE } {
	    set J $pB
	    set L [expr ($pB + $nE) % $ToT] 
	    for { set I 0 } { $I < $nE } { incr I ; incr J ; incr L } {
	       set lP $P($J)
	       if { [expr ${SgN}($P($L) - $lP)] < 0.0 } {
	          set hP [expr $P($L) + $TwoPI]
               } else { set hP $P($L) }
               set cH [expr cos($hP)]
               set cL [expr cos($lP)]
               set sH [expr sin($hP)]
               set sL [expr sin($lP)]
	       set cH3 [expr $cH * $cH * $cH]
	       set cL3 [expr $cL * $cL * $cL]
	       set sH3 [expr ($sH * $sH * $sH)/3.0]
	       set sL3 [expr ($sL * $sL * $sL)/3.0]
	       set dA($I) [expr (-$hP * $cH3 + $sH - $sH3 \
	                 + $lP * $cL3 - $sL + $sL3) / 3.0]
	       set dB($I) [expr -($cH3 - $cL3) / 3.0]
            }

	    for { set J 0 } { $J < $nT } { incr J } {
	       for { set I 0 } { $I < $nE } { incr I ; incr N } {
	          set R($N) [expr ${SgN}($A($N) * $dA($I) + $B($N) * $dB($I))]
	       }
	    }
	 }
      }
   }
}
