# THIS procedure forms the linear elements A (Slope) and B (intercept) which
#   allows a linear interpolation of the df in phase.  What is formed is
#
#              df = A * phi + B
#
#
# INPUT:  ImGA : phase ImG
#         ImGB : dF ImG
#         Back : the returned ImG

package provide MOments_C 1.0

proc MOlinearElements { } {
   global mANS phImG dfImG slImG inImG

# THIS is the number of energy steps, sectors, and sensors used to build
#   the arrays.  The dF array is laid down in the order nE, nS, nT while
#   the pH array is laid down nE, nT.

   set nE $mANS(nE)
   set nS $mANS(Sector)
   set nT $mANS(0,NSEN)

   set N 0
   set pB 0
   set pE $nE
   set sE [expr $nE * $nT]

   set pT [expr $nE * $nS]
   set dT [expr $nE * $nS * $nT]
   for { set K 0 } { $K < $nS } { incr K ; incr pB $nE ; incr pE $nE } {
      for { set J 0 } { $J < $nT } { incr J } {
         for { set I $pB } { $I < $pE } { incr I ; incr N } {
	    set iN [expr ($I + $nE) % $pT] 
	    set nN [expr ($N + $sE) % $dT] 
	    set slImG($N) [expr ($dfImG($N) - $dfImG($nN)) / ($phImG($I) - $phImG($iN))]
	    set inImG($N) [expr $dfImG($N) - $slImG($N) * $phImG($I)]
         }
      }
   }
}
