# THIS procedure performs the phi integration over a set of data.
#
# FIXED:  nE    : number of steps in the data set
#         LowX  : array of the lower edges of the velocity bin
#         HighX : array of the upper edges of the velocity bin
#         CoefY : array of lists.  Each list is the coefficients of a
#                 polynomial which gives intensity across the bin

package provide MOments 1.0

proc MOintTh { nE LowX HighX CoefY Class } {

   upvar $LowX  lX
   upvar $HighX hX
   upvar $CoefY Y

# INITIALIZE the upper an lower integration summations
                                                                                
   set SumH 0.0
   set SumL 0.0
                                                                                
# THIS is the number of polynomial coefficients defined in computing the
#   intensity across the bin.
                                                                                
   set nC [llength $Y(0)]

# SET up the signs in the final combination.
                                                                                
   if { $lX(0) < $hX(0) } {
      set SgNL - ; set SgNH +
   } else { set SgNL + ; set SgNH - }

   switch -exact -- $Class {
      SIN {
         for { set I 0 } { $I < $nE } { incr I } {
            set SumL [expr $SumL - $Y($I) * cos($lX($I))]
            set SumH [expr $SumH - $Y($I) * cos($hX($I))]
         }
      }
      SIN2 {
         for { set I 0 } { $I < $nE } { incr I } {
            set SumL [expr $SumL + \
                       $Y($I) * ($lX($I)/2.0 - sin(2.0 * $lX($I))/4.0)]
            set SumH [expr $SumH + \
                       $Y($I) * ($hX($I)/2.0 - sin(2.0 * $hX($I))/4.0)]
         }
      }
      SINCOS {
         for { set I 0 } { $I < $nE } { incr I } {
            set S2 [expr sin($lX($I))]
            set SumL [expr $SumL + $Y($I) * $S2 * $S2 / 2.0]
            set S2 [expr sin($hX($I))]
            set SumH [expr $SumH + $Y($I) * $S2 * $S2 / 2.0]
         }
      }
   }

   set rV [expr $SgNH$SumH $SgNL $SumL ]

   return $rV
}
