# THIS procedure determines the energy step - if it exists which contains
#    the potential energy.

package provide MOments 1.0

proc MOhiloEv { sN } {
   global mANS eBImG eEImG

# IF we are working with energy bin centers them compute the beginning
#  and ending bin edges

   switch -exact -- $mANS(aData) {
      C {
         set EnD [expr $mANS(nE) - 1]

         set E1 [expr log($eBImG(0))]
	 set K 1
         for { set I 0 } { $K < $mANS(nE) } { incr I ; incr K } {
            set E2 [expr log($eBImG($K))]
            set dE [expr ($E2 - $E1)/2.0]
            if { $I == 0 } { set eV($I) [expr exp($E1 - $dE)] }
            set eV($K) [expr exp($E1 + $dE)]
            if { $K == $EnD } { incr K ; set eV($K) [expr exp($E2 + $dE)] }
            set E1 $E2
         }

         set K 1
         for { set I 0 } { $I < $mANS(nE) } { incr I ; incr K } {
	    set eBImG($I) $eV($I)
	    set eEImG($I) $eV($K)
         }
      }
   }
}
