# THIS procedure contains the integration limit GUI
                                                                                
package provide MOments 1.0
                                                                                
proc MOguiLimits { } {
   global env mANS Prefs

   set W .moLim

    set bSize [expr $Prefs(FontSize) + 2]
    set LFonT [list "" "" bold]
    set BFonT [list "" $bSize bold]

   set LaB "LIMITS AND OFFSETS"
   if [GUIWindow $W $LaB] {

      MOallInits LIMITS

      set Wa $W.cmd
      set Wb $W.body

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb -1 grid|1|0|news
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"

      set RoW 0
      GUILabel $Wb.t$RoW "Integration Limits" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      incr RoW 
      GUILabel $Wb.l1 Start c grid|$RoW|1 0 -1 "" $LFonT
      GUILabel $Wb.l2 Stop  c grid|$RoW|2 0 -1 "" $LFonT

      incr RoW 
      set cOpts [list PRE-POT|0 POST-POT|1]
      GUILabel $Wb.t$RoW "Energy" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.minE grid|$RoW|1| 8 mANS(bEv)
      GUIboxEntry $Wb.maxE grid|$RoW|2| 8 mANS(eEv)
      set LaB [lindex [split [lindex $cOpts $mANS(appE)] "|"] 0]
      GUIbuttonToggle $Wb.aE $LaB  grid|$RoW|3|w $cOpts \
		"GUIoptsToggle $Wb.aE mANS(appE) ALT" 0
      GUILabel $Wb.et$RoW eV w grid|$RoW|4

      incr RoW 
      GUILabel $Wb.t$RoW "Phi" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.minP grid|$RoW|1| 8 mANS(bPh)
      GUIboxEntry $Wb.maxP grid|$RoW|2| 8 mANS(ePh)
      GUILabel $Wb.et$RoW deg w grid|$RoW|3

      incr RoW 
      GUILabel $Wb.t$RoW "Theta" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.minT grid|$RoW|1| 8 mANS(bTh)
      GUIboxEntry $Wb.maxT grid|$RoW|2| 8 mANS(eTh)
      GUILabel $Wb.et$RoW deg w grid|$RoW|3

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      incr RoW 
      GUILabel $Wb.t$RoW "Phi Integration Info" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      set cOpts [list FIXED|0 LINEAR|1]

      incr RoW 
      GUILabel $Wb.t$RoW "Format" w grid|$RoW|0|w 0 -1 "" $LFonT
      set LaB [lindex [split [lindex $cOpts $mANS(cFmT)] "|"] 0]
      GUIbuttonToggle $Wb.cFmT $LaB  grid|$RoW|1|w $cOpts \
		"GUIoptsToggle $Wb.cFmT mANS(cFmT) ALT" 0

      incr RoW 
      GUILabel $Wb.t$RoW "Offset" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.phoff grid|$RoW|1 8 mANS(pOff)
      GUILabel $Wb.et$RoW deg w grid|$RoW|2|w

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      incr RoW 
      GUILabel $Wb.t$RoW "S/C Potential Info" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      incr RoW 
      GUILabel $Wb.t$RoW "Offset" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.pvoff grid|$RoW|1 8 mANS(pVOff)
      GUILabel $Wb.et$RoW eV w grid|$RoW|2|w
      incr RoW 
      set cOpts [list NO|0 YES|1]
      GUILabel $Wb.t$RoW "Extend" w grid|$RoW|0|w 0 -1 "" $LFonT
      set LaB [lindex [split [lindex $cOpts $mANS(pVExt)] "|"] 0]
      GUIbuttonToggle $Wb.pvext $LaB  grid|$RoW|1|w $cOpts \
		"GUIoptsToggle $Wb.pvext mANS(pVExt) ALT" 0

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      incr RoW 
      GUILabel $Wb.t$RoW "Energy Info" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      set aOps [list CENTER|C LO-CENTER|LC LO-HI|LU CENTER-HI|CU]

      switch -exact -- $mANS(aData) {
         C  { set LaB CENTER }
         LC { set LaB LO-CENTER }
         LU { set LaB LO-HI }
         CU { set LaB CENTER-HI }
      }

      incr RoW 
      GUILabel $Wb.t$RoW "Bin Def" w grid|$RoW|0|w 2 -1 "" $LFonT
      GUIbuttonMenu $Wb.ad $LaB grid|$RoW|1|w||2 $aOps  \
               "GUIoptsProcess $Wb.ad mANS(aData) ALT " 6

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      incr RoW 
      GUILabel $Wb.t$RoW "Species Info" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      set dOpts [list Electron Ion]

      incr RoW
      GUILabel $Wb.t$RoW "Species" w grid|$RoW|0|w 2 -1 "" $LFonT
      GUIbuttonToggle $Wb.spec $mANS(Species)  grid|$RoW|1|w $dOpts \
		"GUIoptsToggle $Wb.spec mANS(Species) PRI" 0 10

      incr RoW 
      GUILabel $Wb.t$RoW "AMU" w grid|$RoW|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.samu grid|$RoW|1 8 mANS(sAMU)

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      incr RoW 
      GUILabel $Wb.t$RoW "Begin Info" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      set eOpts [list "Closest Spin" "Closest Sweep"]

      incr RoW
      GUILabel $Wb.t$RoW "Start At" w grid|$RoW|0|w 2 -1 "" $LFonT
      GUIbuttonToggle $Wb.btm $mANS(BegFlg)  grid|$RoW|1|w||2 $eOpts \
		"GUIoptsToggle $Wb.btm mANS(BegFlg) PRI" 6

      incr RoW 
      GUIblankRow $Wb $RoW 1.0

      incr RoW 
      GUILabel $Wb.t$RoW "Correction Arrays" w grid|$RoW|0|w||3 \
           0 -1 #0000FF $BFonT

      incr RoW 
      GUIblankRow $Wb $RoW 0.5

      incr RoW
      GUILabel $Wb.t$RoW "File" w grid|$RoW|0|w 2 -1 "" $LFonT
      GUIboxEntry $Wb.cfile grid|$RoW|1|ew||3 10 mANS(cFile)

   } else { GUIwindowCtrl $W }
}
