# THIS procedure determines the UDF sources.  These are either UDF based
#   sources or CAA pases sources

package provide MOments 1.0

proc MOgetSrcs { } {
   global mANS 

# THIS is the number of UDF's that need to be opened.

   if ![winfo exists .moVAR] { MOguiVar 1 }
   set W .moVAR.body.list
   set nS [$W index end]

# SEPARATE the sources.  There are sources which belong to MOMENTS,
#   INFO, MAGNETIC FIELD, and POTENTIAL. ONLY INFO can have multiple
#   sources.  Someday MOMENTS might also

   set mANS(MOMENTS) ""
   set mANS(INFO) ""
   set mANS(MAGFIELD) "" 
   set mANS(POTENTIAL) ""
   set mANS(iOffsets) ""
   set mANS(SrcList) ""

   set mANS(iOff) 0

   set PV [list P M E I V]
   for { set S 0 } { $S < $nS } { incr S } {
      set sDef [$W get $S]
      scan $sDef "%d %s" sN dSrc

      set mANS($sN,FmT) $dSrc 
      lappend mANS(SrcList) $sN
      switch -exact -- $dSrc {
         MOMENTS { lappend mANS(MOMENTS) $sN }

         INFO    { lappend mANS(INFO) $sN }

         MF-UDF -
         MF-CAA  { lappend mANS(MAGFIELD) $sN }

         POT-UDF -
         POT-CAA { lappend mANS(POTENTIAL) $sN }
      }

# LOOK for CAA data sources.  We only process UDF ones here.

      if [string match UDF $mANS($sN,sBase)] { 
         set iD UD$sN
         for { set I 0 } { $I < 5 } { incr I } {
	    set ChK [string trim $mANS($iD,[lindex $PV $I])]
	    if { [string length $ChK] == 0 } { 
	       puts stderr "INCOMPLETE PMEIV definition for SOURCE $sN"
	       exit 
	    }
         }
      }
   }
}
